/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item.electric;

import cpw.mods.fml.common.Optional;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2_1710;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="mekanism.api.energy.IEnergizedItem", modid="MekanismAPI"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2")})
public class ItemElectricArmor
extends ItemArmor
implements IItemElectric,
IEnergizedItem,
ISpecialElectricItem {
    private static IElectricItemManager itemManagerIC2;
    public float transferMax;

    public ItemElectricArmor(ItemArmor.ArmorMaterial material, int p_i45325_2_, int p_i45325_3_) {
        super(material, p_i45325_2_, p_i45325_3_);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = new ElectricItemManagerIC2_1710();
        }
    }

    protected void setMaxTransfer() {
        this.transferMax = 200.0f;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        String color = "";
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        list.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setElectricity(itemStack, 0.0f);
    }

    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doTransfer) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(ElectricItemHelper.getUncharged((ItemStack)new ItemStack((Item)this)));
        par3List.add(ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
    }

    public static boolean isElectricItem(Item item) {
        return item instanceof ItemElectricArmor;
    }

    public static boolean isElectricItemEmpty(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        return item instanceof ItemElectricArmor && ((ItemElectricArmor)item).getElectricityStored(itemstack) <= 0.0f;
    }

    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    public boolean isMetadataSpecific(ItemStack itemStack) {
        return false;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }

    public float getMaxElectricityStored(ItemStack theItem) {
        return 0.0f;
    }

    public IElectricItemManager getManager(ItemStack itemStack) {
        return itemManagerIC2;
    }
}

