/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.TCetiSystem;

import galaxyspace.TCetiSystem.TCetiBlocks;
import galaxyspace.TCetiSystem.planets.tcetiE.dimension.WorldProviderTCetiE;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.config.GSConfigDimensions;
import galaxyspace.core.render.sky.SkyProviderBase;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;

public class TCetiPlanets {
    public static SolarSystem tcetiSystem;
    public static Star TCetiA;
    public static Planet tcetiB;
    public static Planet tcetiC;
    public static Planet tcetiD;
    public static Planet tcetiE;
    public static Planet tcetiF;
    public static Planet tcetiG;
    @Deprecated
    public static Planet tcetiH;
    @Deprecated
    public static Planet tcetiI;
    public static Planet tcetiAsteroids;

    public static void preInit() {
        TCetiBlocks.initialize();
    }

    public static void init() {
        tcetiSystem = new SolarSystem("TCetiSystem", "milkyWay").setMapPosition(new Vector3(-2.0, 1.0, 0.0));
        if (GSConfigCore.enableTCeti) {
            GalaxyRegistry.registerSolarSystem((SolarSystem)tcetiSystem);
        }
        TCetiA = (Star)new Star("TCetiA").setParentSolarSystem(tcetiSystem).setTierRequired(-1);
        TCetiA.setBodyIcon(SkyProviderBase.tCetiATexture);
        tcetiSystem.setMainStar(TCetiA);
        tcetiB = new Planet("TCetiB").setParentSolarSystem(tcetiSystem);
        tcetiB.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiB.setPhaseShift(0.7853982f);
        tcetiB.setBodyIcon(SkyProviderBase.tCetiBTexture);
        tcetiB.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f));
        tcetiB.setRelativeOrbitTime(0.3f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiB);
        }
        tcetiC = new Planet("TCetiC").setParentSolarSystem(tcetiSystem);
        tcetiC.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiC.setPhaseShift(1.5707964f);
        tcetiC.setBodyIcon(SkyProviderBase.tCetiCTexture);
        tcetiC.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.75f, 0.75f));
        tcetiC.setRelativeOrbitTime(0.8f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiC);
        }
        tcetiD = new Planet("TCetiD").setParentSolarSystem(tcetiSystem);
        tcetiD.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiD.setPhaseShift((float)Math.PI * 2);
        tcetiD.setBodyIcon(SkyProviderBase.tCetiDTexture);
        tcetiD.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f));
        tcetiD.setRelativeOrbitTime(1.4f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiD);
        }
        tcetiE = new Planet("TCetiE").setParentSolarSystem(tcetiSystem);
        tcetiE.setRingColorRGB(0.1f, 1.1f, 0.6f);
        tcetiE.setPhaseShift((float)Math.PI);
        tcetiE.setTierRequired(8);
        tcetiE.setBodyIcon(SkyProviderBase.tCetiETexture);
        tcetiE.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.25f, 1.25f));
        tcetiE.setRelativeOrbitTime(1.8619934f);
        tcetiE.setDimensionInfo(GSConfigDimensions.dimensionIDTCetiE, WorldProviderTCetiE.class);
        tcetiE.atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.HELIUM).atmosphereComponent(IAtmosphericGas.ARGON).atmosphereComponent(IAtmosphericGas.OXYGEN);
        if (GSConfigDimensions.enableTCetiE) {
            GalaxyRegistry.registerPlanet((Planet)tcetiE);
            GalacticraftRegistry.registerTeleportType(WorldProviderTCetiE.class, (ITeleportType)new WorldProviderTCetiE());
        }
        tcetiF = new Planet("TCetiF").setParentSolarSystem(tcetiSystem);
        tcetiF.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiF.setPhaseShift(1.0471976f);
        tcetiF.setBodyIcon(SkyProviderBase.tCetiFTexture);
        tcetiF.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f));
        tcetiF.setRelativeOrbitTime(2.3f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiF);
        }
        tcetiG = new Planet("TCetiG").setParentSolarSystem(tcetiSystem);
        tcetiG.setRingColorRGB(0.1f, 0.9f, 0.6f);
        tcetiG.setPhaseShift(0.7853982f);
        tcetiG.setBodyIcon(SkyProviderBase.tCetiGTexture);
        tcetiG.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        tcetiG.setRelativeOrbitTime(2.8f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiG);
        }
        tcetiAsteroids = new Planet("TCetiAsteroids").setParentSolarSystem(tcetiSystem);
        tcetiAsteroids.setRingColorRGB(1.1f, 0.1f, 0.1f);
        tcetiAsteroids.setPhaseShift((float)Math.PI);
        tcetiAsteroids.setBodyIcon(SkyProviderBase.tCetiAsteroidsTexture);
        tcetiAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f));
        tcetiAsteroids.setRelativeOrbitTime(11.861994f);
        if (GSConfigDimensions.enableUnreachable) {
            GalaxyRegistry.registerPlanet((Planet)tcetiAsteroids);
        }
    }
}

