/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import openmods.calc.Environment;
import openmods.calc.Frame;
import openmods.calc.ICallable;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.Value;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.ISymbolCallStateTransition;
import openmods.calc.parsing.SameStateSymbolTransition;
import openmods.calc.parsing.SymbolCallNode;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedCalcUtils;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;

public class DoExpressionFactory {
    private final TypeDomain domain;

    public DoExpressionFactory(TypeDomain domain) {
        this.domain = domain;
    }

    public ISymbolCallStateTransition<TypedValue> createStateTransition(ICompilerState<TypedValue> compilerState) {
        return new DoExpr(compilerState);
    }

    public void registerSymbol(Environment<TypedValue> env) {
        env.setGlobalSymbol("do", (TypedValue)((Object)new DoSymbol()));
    }

    private class DoSymbol
    implements ICallable<TypedValue> {
        private DoSymbol() {
        }

        @Override
        public void call(Frame<TypedValue> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            Preconditions.checkState((boolean)argumentsCount.isPresent(), (Object)"'do' symbol requires arguments count");
            Integer argCount = argumentsCount.get();
            Preconditions.checkState((argCount > 1 ? 1 : 0) != 0, (Object)"'do' expects at least one argument");
            Stack<TypedValue> stack = frame.stack().substack(argCount);
            for (TypedValue expr : ImmutableList.copyOf(stack)) {
                stack.clear();
                Code exprCode = expr.as(Code.class);
                exprCode.execute(frame);
            }
            TypedCalcUtils.expectExactReturnCount(returnsCount, stack.size());
        }
    }

    private class DoExpr
    extends SameStateSymbolTransition<TypedValue> {
        public DoExpr(ICompilerState<TypedValue> parentState) {
            super(parentState);
        }

        @Override
        public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
            return new DoNode(children);
        }
    }

    private class DoNode
    extends SymbolCallNode<TypedValue> {
        public DoNode(List<IExprNode<TypedValue>> args) {
            super("do", args);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            int argCount = 0;
            for (IExprNode<TypedValue> iExprNode : this.getChildren()) {
                output.add(Value.create(Code.flattenAndWrap(DoExpressionFactory.this.domain, iExprNode)));
                ++argCount;
            }
            Preconditions.checkState((argCount > 1 ? 1 : 0) != 0, (Object)"'do' expects at least one argument");
            output.add(new SymbolCall(this.symbol, argCount, 1));
        }
    }
}

