/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.Calculator;
import openmods.calc.Compilers;
import openmods.calc.Environment;
import openmods.calc.GenericFunctions;
import openmods.calc.ICompilerMapFactory;
import openmods.calc.IValuePrinter;
import openmods.calc.OperatorDictionary;
import openmods.calc.parsing.IValueParser;

public abstract class SimpleCalculatorFactory<E, M> {
    protected abstract E getNullValue();

    protected Environment<E> createEnvironment() {
        return new Environment<E>(this.getNullValue());
    }

    protected abstract IValueParser<E> getValueParser();

    protected abstract IValuePrinter<E> createValuePrinter();

    protected abstract void configureEnvironment(Environment<E> var1);

    protected abstract void configureOperators(OperatorDictionary<E> var1);

    public Calculator<E, M> create(ICompilerMapFactory<E, M> compilersFactory) {
        OperatorDictionary operators = new OperatorDictionary();
        this.configureOperators(operators);
        Environment<E> env = this.createEnvironment();
        GenericFunctions.createStackManipulationFunctions(env);
        this.configureEnvironment(env);
        Compilers<E, M> compilers = compilersFactory.create(this.getNullValue(), this.getValueParser(), operators, env);
        IValuePrinter<E> printer = this.createValuePrinter();
        return new Calculator<E, M>(env, compilers, printer);
    }
}

