/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.block.ILogType;
import binnie.extratrees.worldgen.BlockTypeLog;
import binnie.extratrees.worldgen.WorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenRoseGum
extends WorldGenTree {
    public WorldGenRoseGum(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int offset = (this.girth - 1) / 2;
        for (int x = 0; x < this.girth; ++x) {
            for (int y = 0; y < this.girth; ++y) {
                for (int i = 0; i < 2; ++i) {
                    this.addBlock(x - offset, i, y - offset, new BlockTypeLog(ILogType.ExtraTreeLog.Eucalyptus2), true);
                }
            }
        }
        float leafSpawn = this.height + 2;
        float bottom = this.randBetween(0.4f, 0.5f) * (float)this.height;
        float width = (float)this.height * this.randBetween(0.05f, 0.1f);
        if (width < 1.5f) {
            width = 1.5f;
        }
        this.bushiness = 0.5f;
        float f = leafSpawn;
        leafSpawn = f - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
        float f2 = leafSpawn;
        leafSpawn = f2 - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
        while (leafSpawn > bottom) {
            this.bushiness = 0.1f;
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.9f, 1.1f) * width, 1, this.leaf, false);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(9, 3);
        this.girth = this.determineGirth(this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

