/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.gardening;

import binnie.botany.Botany;
import binnie.botany.CreativeTabBotany;
import binnie.botany.api.EnumAcidity;
import binnie.botany.api.EnumMoisture;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.gardening.IBlockSoil;
import binnie.botany.gardening.BlockPlant;
import binnie.botany.gardening.Gardening;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSoil
extends Block
implements IBlockSoil {
    protected boolean weedKilled;
    protected IIcon[] iconsTop;
    protected IIcon[] iconsSide;
    protected IIcon[] iconsNoWeed;
    protected EnumSoilType type;

    public BlockSoil(EnumSoilType type, String blockName, boolean weedKilled) {
        super(Material.field_151578_c);
        this.type = type;
        this.weedKilled = weedKilled;
        this.iconsTop = new IIcon[9];
        this.iconsSide = new IIcon[9];
        this.iconsNoWeed = new IIcon[9];
        this.func_149647_a(CreativeTabBotany.instance);
        this.func_149663_c(blockName);
        this.func_149675_a(true);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.9375f, 1.0f);
        this.func_149713_g(255);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149767_g);
    }

    public static int getMeta(EnumAcidity acid, EnumMoisture moisture) {
        return acid.ordinal() * 3 + moisture.ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 9; ++i) {
            list.add(new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int n = meta = meta >= 9 ? 8 : meta;
        if (side == 1) {
            return this.weedKilled ? this.iconsNoWeed[meta] : this.iconsTop[meta];
        }
        return side == 0 ? Blocks.field_150346_d.func_149691_a(side, 0) : this.iconsSide[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (EnumMoisture moisture : EnumMoisture.values()) {
            for (EnumAcidity pH : EnumAcidity.values()) {
                int index = moisture.ordinal() + pH.ordinal() * 3;
                String id = "soil/" + this.getType().getID() + "." + pH.getID() + "." + moisture.getID();
                this.iconsTop[index] = Botany.proxy.getIcon(register, id + ".0");
                this.iconsSide[index] = Botany.proxy.getIcon(register, id + ".1");
                this.iconsNoWeed[index] = Botany.proxy.getIcon(register, id + ".2");
            }
        }
    }

    public EnumSoilType getType() {
        return this.type;
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        int meta2;
        int meta = world.func_72805_g(x, y, z);
        EnumMoisture moisture = EnumMoisture.values()[meta % 3];
        EnumAcidity acidity = EnumAcidity.values()[meta / 3];
        EnumMoisture desiredMoisture = Gardening.getNaturalMoisture(world, x, y, z);
        if (desiredMoisture.ordinal() > moisture.ordinal()) {
            EnumMoisture enumMoisture = moisture = moisture == EnumMoisture.DRY ? EnumMoisture.NORMAL : EnumMoisture.DAMP;
        }
        if (desiredMoisture.ordinal() < moisture.ordinal()) {
            EnumMoisture enumMoisture = moisture = moisture == EnumMoisture.DAMP ? EnumMoisture.NORMAL : EnumMoisture.DRY;
        }
        if (meta != (meta2 = BlockSoil.getMeta(acidity, moisture))) {
            world.func_72921_c(x, y, z, meta2, 2);
        }
        if (!this.weedKilled && random.nextInt(5 - this.getType(world, x, y, z).ordinal()) == 0 && world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
            world.func_147465_d(x, y + 1, z, (Block)Botany.plant, BlockPlant.Type.Weeds.ordinal(), 2);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public EnumAcidity getPH(World world, int x, int y, int z) {
        return EnumAcidity.values()[world.func_72805_g(x, y, z) / 3];
    }

    @Override
    public EnumMoisture getMoisture(World world, int x, int y, int z) {
        return EnumMoisture.values()[world.func_72805_g(x, y, z) % 3];
    }

    @Override
    public EnumSoilType getType(World world, int x, int y, int z) {
        return this.type;
    }

    @Override
    public boolean fertilise(World world, int x, int y, int z, EnumSoilType maxLevel) {
        EnumSoilType type = this.getType(world, x, y, z);
        if (type.ordinal() >= maxLevel.ordinal()) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return world.func_147465_d(x, y, z, Gardening.getSoilBlock(maxLevel, this.weedKilled), meta, 2);
    }

    @Override
    public boolean degrade(World world, int x, int y, int z, EnumSoilType minLevel) {
        EnumSoilType type = this.getType(world, x, y, z);
        if (type.ordinal() <= minLevel.ordinal()) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        return world.func_147465_d(x, y, z, Gardening.getSoilBlock(minLevel, this.weedKilled), meta, 2);
    }

    @Override
    public boolean setPH(World world, int x, int y, int z, EnumAcidity pH) {
        int meta = BlockSoil.getMeta(pH, this.getMoisture(world, x, y, z));
        return world.func_72921_c(x, y, z, meta, 2);
    }

    @Override
    public boolean setMoisture(World world, int x, int y, int z, EnumMoisture moisture) {
        int meta = BlockSoil.getMeta(this.getPH(world, x, y, z), moisture);
        return world.func_72921_c(x, y, z, meta, 2);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN, false)) {
            world.func_147465_d(x, y, z, Blocks.field_150346_d, 0, 2);
        }
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        Block plant = plantable.getPlant(world, x, y + 1, z);
        if (plant == Botany.flower) {
            return true;
        }
        if (plant == Botany.plant) {
            return !this.weedKilled || !BlockPlant.isWeed(world, x, y, z);
        }
        return world instanceof World && Blocks.field_150346_d.canSustainPlant(world, x, y, z, direction, plantable);
    }

    @Override
    public boolean resistsWeeds(World world, int x, int y, int z) {
        return this.weedKilled;
    }
}

