/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.integration.nei;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.storage.BQ_Settings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.themes.gui_args.GArgsNone;
import betterquesting.api2.client.gui.themes.presets.PresetGUIs;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.client.gui2.GuiHome;
import betterquesting.client.gui2.GuiQuest;
import betterquesting.client.gui2.GuiQuestLines;
import betterquesting.client.themes.ThemeRegistry;
import betterquesting.questing.QuestDatabase;
import bq_standard.integration.nei.CustomPositionedStack;
import bq_standard.rewards.IRewardItemOutput;
import bq_standard.rewards.RewardChoice;
import bq_standard.tasks.ITaskItemInput;
import bq_standard.tasks.TaskOptionalRetrieval;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.base.Stopwatch;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class QuestRecipeHandler
extends TemplateRecipeHandler {
    private static final boolean debug = false;
    private static final int SLOT_SIZE = 18;
    private static final int GRID_X_COUNT = 4;
    private static final int GRID_Y_COUNT = 4;
    private static final int GRID_COUNT = 16;
    private static final int GUI_WIDTH = 166;
    private static final int LINE_SPACE = GuiDraw.fontRenderer.field_78288_b + 1;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 59, 16, 13), this.getOverlayIdentifier(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            for (Map.Entry<UUID, IQuest> entry : QuestRecipeHandler.getVisibleQuests().entrySet()) {
                if (QuestRecipeHandler.getTaskItemInputs(QuestRecipeHandler.getTasks(entry.getValue())).isEmpty() && QuestRecipeHandler.getRewardItemOutputs(QuestRecipeHandler.getRewards(entry.getValue())).isEmpty()) continue;
                this.arecipes.add(new CachedQuestRecipe(entry));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        block0: for (Map.Entry<UUID, IQuest> entry : QuestRecipeHandler.getVisibleQuests().entrySet()) {
            for (BigItemStack compareTo : QuestRecipeHandler.getRewardItemOutputs(QuestRecipeHandler.getRewards(entry.getValue()))) {
                if (!QuestRecipeHandler.matchStack(result, compareTo)) continue;
                this.arecipes.add(new CachedQuestRecipe(entry));
                continue block0;
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        block0: for (Map.Entry<UUID, IQuest> entry : QuestRecipeHandler.getVisibleQuests().entrySet()) {
            for (BigItemStack compareTo : QuestRecipeHandler.getTaskItemInputs(QuestRecipeHandler.getTasks(entry.getValue()))) {
                if (!QuestRecipeHandler.matchStack(ingredient, compareTo)) continue;
                this.arecipes.add(new CachedQuestRecipe(entry));
                continue block0;
            }
        }
    }

    public String getGuiTexture() {
        return "bq_standard:textures/gui/nei.png";
    }

    public String getOverlayIdentifier() {
        return "bq_quest";
    }

    public void drawExtras(int recipeIndex) {
        CachedQuestRecipe recipe = (CachedQuestRecipe)((Object)this.arecipes.get(recipeIndex));
        String questTitle = EnumChatFormatting.UNDERLINE + EnumChatFormatting.func_110646_a((String)recipe.questName);
        int color = this.isMouseOverTitle(recipeIndex) ? 11041374 : 0;
        List titleArray = GuiDraw.fontRenderer.func_78271_c(questTitle, 166);
        int y = 16 - (titleArray.size() - 1) * LINE_SPACE;
        for (String line : titleArray) {
            GuiDraw.drawStringC((String)line, (int)83, (int)y, (int)color, (boolean)false);
            y += LINE_SPACE;
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)105);
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipeIndex) {
        CachedQuestRecipe recipe = (CachedQuestRecipe)((Object)this.arecipes.get(recipeIndex));
        for (PositionedStack pStack : recipe.inputs) {
            if (stack != pStack.item || !(pStack instanceof CustomPositionedStack)) continue;
            currenttip.addAll(((CustomPositionedStack)pStack).getTooltips());
        }
        return currenttip;
    }

    public boolean mouseClicked(GuiRecipe<?> gui, int button, int recipeIndex) {
        if (super.mouseClicked(gui, button, recipeIndex)) {
            return true;
        }
        if (this.isMouseOverTitle(recipeIndex)) {
            GuiScreen parentScreen;
            CachedQuestRecipe recipe = (CachedQuestRecipe)((Object)this.arecipes.get(recipeIndex));
            if (GuiHome.bookmark instanceof GuiQuest && BQ_Settings.useBookmark) {
                parentScreen = ((GuiScreenCanvas)GuiHome.bookmark).parent;
            } else if (GuiHome.bookmark instanceof GuiScreenCanvas && BQ_Settings.useBookmark) {
                parentScreen = GuiHome.bookmark;
            } else {
                parentScreen = ThemeRegistry.INSTANCE.getGui(PresetGUIs.HOME, GArgsNone.NONE);
                if (BQ_Settings.useBookmark && BQ_Settings.skipHome) {
                    parentScreen = new GuiQuestLines(parentScreen);
                }
            }
            GuiQuest toDisplay = new GuiQuest(parentScreen, recipe.questID);
            toDisplay.setPreviousScreen(Minecraft.func_71410_x().field_71462_r);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)toDisplay);
            if (BQ_Settings.useBookmark) {
                GuiHome.bookmark = toDisplay;
            }
            return true;
        }
        return false;
    }

    public String getRecipeName() {
        return "BetterQuesting";
    }

    private static Map<UUID, IQuest> getVisibleQuests() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        return QuestDatabase.INSTANCE.filterEntries((arg_0, arg_1) -> QuestRecipeHandler.lambda$getVisibleQuests$0((EntityPlayer)player, arg_0, arg_1));
    }

    private static List<ITask> getTasks(IQuest quest) {
        return quest.getTasks().getEntries().stream().map(DBEntry::getValue).collect(Collectors.toList());
    }

    private static List<BigItemStack> getTaskItemInputs(List<ITask> tasks) {
        ArrayList<BigItemStack> ret = new ArrayList<BigItemStack>();
        for (ITask task : tasks) {
            ret.addAll(QuestRecipeHandler.getTaskItemInputs(task));
        }
        return ret;
    }

    private static List<BigItemStack> getTaskItemInputs(ITask task) {
        if (!(task instanceof ITaskItemInput)) {
            return Collections.emptyList();
        }
        return ((ITaskItemInput)task).getItemInputs();
    }

    private static List<IReward> getRewards(IQuest quest) {
        return quest.getRewards().getEntries().stream().map(DBEntry::getValue).collect(Collectors.toList());
    }

    private static List<BigItemStack> getRewardItemOutputs(List<IReward> rewards) {
        ArrayList<BigItemStack> ret = new ArrayList<BigItemStack>();
        for (IReward reward : rewards) {
            ret.addAll(QuestRecipeHandler.getRewardItemOutputs(reward));
        }
        return ret;
    }

    private static List<BigItemStack> getRewardItemOutputs(IReward reward) {
        if (!(reward instanceof IRewardItemOutput)) {
            return Collections.emptyList();
        }
        return ((IRewardItemOutput)reward).getItemOutputs();
    }

    private static boolean matchStack(ItemStack compared, BigItemStack bigStackCompareTo) {
        for (ItemStack compareTo : QuestRecipeHandler.extractStacks(bigStackCompareTo)) {
            if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)compared, (ItemStack)compareTo)) continue;
            return true;
        }
        return false;
    }

    private static List<ItemStack> extractStacks(BigItemStack bigStack) {
        if (bigStack.hasOreDict()) {
            List<ItemStack> ret = Arrays.asList(bigStack.getOreIngredient().getMatchingStacks());
            ret.forEach(s -> {
                s.field_77994_a = bigStack.stackSize;
            });
            return ret;
        }
        return Collections.singletonList(QuestRecipeHandler.translateBigStack(bigStack));
    }

    private static ItemStack translateBigStack(BigItemStack bigStack) {
        ItemStack stack = bigStack.getBaseStack();
        stack.field_77994_a = bigStack.stackSize;
        return stack;
    }

    private boolean isMouseOverTitle(int recipeIndex) {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiRecipe)) {
            return false;
        }
        GuiRecipe gui = (GuiRecipe)Minecraft.func_71410_x().field_71462_r;
        CachedQuestRecipe recipe = (CachedQuestRecipe)((Object)this.arecipes.get(recipeIndex));
        String questTitle = EnumChatFormatting.UNDERLINE + recipe.questName;
        List titleArray = GuiDraw.fontRenderer.func_78271_c(questTitle, 166);
        int titleWidth = titleArray.stream().map(GuiDraw::getStringWidth).max(Comparator.naturalOrder()).orElse(0);
        int titleHeight = GuiDraw.fontRenderer.field_78288_b + (titleArray.size() - 1) * LINE_SPACE;
        Point offset = gui.getRecipePosition(recipeIndex);
        Point pos = GuiDraw.getMousePosition();
        Point relMousePos = new Point(pos.x - gui.field_147003_i - offset.x, pos.y - gui.field_147009_r - offset.y);
        Rectangle titleArea = new Rectangle(83 - titleWidth / 2 - 1, 16 - (titleArray.size() - 1) * LINE_SPACE, titleWidth + 2, titleHeight + 1);
        return titleArea.contains(relMousePos);
    }

    private static /* synthetic */ boolean lambda$getVisibleQuests$0(EntityPlayer player, UUID id, IQuest quest) {
        return QuestCache.isQuestShown(quest, QuestingAPI.getQuestingUUID(player), player);
    }

    private class CachedQuestRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> inputs;
        private final List<PositionedStack> outputs;
        private final String questName;
        private final UUID questID;

        private CachedQuestRecipe(Map.Entry<UUID, IQuest> entry) {
            super((TemplateRecipeHandler)QuestRecipeHandler.this);
            this.inputs = new ArrayList<PositionedStack>();
            this.outputs = new ArrayList<PositionedStack>();
            this.questName = QuestTranslation.translateQuestName(entry);
            this.questID = entry.getKey();
            this.loadTasks(entry.getValue());
            this.loadRewards(entry.getValue());
        }

        private void loadTasks(IQuest quest) {
            int xOffset = 3;
            int yOffset = 29;
            int index = 0;
            block0: for (ITask task : QuestRecipeHandler.getTasks(quest)) {
                for (BigItemStack stack : QuestRecipeHandler.getTaskItemInputs(task)) {
                    if (index >= 16) continue block0;
                    int x = xOffset + index % 4 * 18;
                    int y = yOffset + index / 4 * 18;
                    if (task instanceof TaskOptionalRetrieval) {
                        this.inputs.add(new CustomPositionedStack((Object)QuestRecipeHandler.extractStacks(stack), x, y, EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + QuestTranslation.translate("bq_standard.task.optional_retrieval", new Object[0])));
                    } else {
                        this.inputs.add(new PositionedStack((Object)QuestRecipeHandler.extractStacks(stack), x, y));
                    }
                    ++index;
                }
            }
        }

        private void loadRewards(IQuest quest) {
            int xOffset = 93;
            int yOffset = 29;
            int index = 0;
            block0: for (IReward reward : QuestRecipeHandler.getRewards(quest)) {
                for (BigItemStack stack : QuestRecipeHandler.getRewardItemOutputs(reward)) {
                    if (index >= 16) continue block0;
                    int x = xOffset + index % 4 * 18;
                    int y = yOffset + index / 4 * 18;
                    if (reward instanceof RewardChoice) {
                        this.inputs.add(new CustomPositionedStack((Object)QuestRecipeHandler.extractStacks(stack), x, y, EnumChatFormatting.DARK_GRAY.toString() + EnumChatFormatting.ITALIC + QuestTranslation.translate("bq_standard.reward.choice", new Object[0])));
                    } else {
                        this.inputs.add(new PositionedStack((Object)QuestRecipeHandler.extractStacks(stack), x, y));
                    }
                    ++index;
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(QuestRecipeHandler.this.cycleticks / 20, this.inputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }
    }
}

