/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_ExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.material.ELEMENT;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class GregtechMetaTileEntity_QuantumForceTransformer
extends GT_MetaTileEntity_ExtendedPowerMultiBlockBase<GregtechMetaTileEntity_QuantumForceTransformer>
implements ISurvivalConstructable {
    private int mCasing;
    protected int mCraftingTier = 0;
    protected int mFocusingTier = 0;
    private boolean mFluidMode = false;
    private boolean doFermium = false;
    private boolean doNeptunium = false;
    private static final Fluid mNeptunium = ELEMENT.getInstance().NEPTUNIUM.getPlasma();
    private static final Fluid mFermium = ELEMENT.getInstance().FERMIUM.getPlasma();
    private static final String MAIN_PIECE = "main";
    private GT_MetaTileEntity_Hatch_Input mNeptuniumHatch;
    private GT_MetaTileEntity_Hatch_Input mFermiumHatch;
    private static final IStructureDefinition<GregtechMetaTileEntity_QuantumForceTransformer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", (String[][])new String[][]{{"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "   BBBBABBBB   ", "   BAAAAAAAB   ", "   BABBABBAB   ", "   BA     AB   ", "    A     A    ", "    A     A    ", "    A     A    "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "   AAABBBAAA   ", "  BAAAAAAAAAB  ", "  B         B  ", "  A         A  ", "  A         A  ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "    AA   AA    ", "  AA       AA  ", " BAA       AAB ", " B           B ", " A           A ", " A           A ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "     BAAAB     ", "   AA     AA   ", " AA         AA ", "BAA         AAB", "B             B", "A             A", "A             A", "A             A", "A             A", "A             A"}, {"      TTT      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "      EEE      ", "      DDD      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "    BAEEEAB    ", "  AA  EEE  AA  ", " A    EEE    A ", "BA    DDD    AB", "B     EEE     B", "B     DDD     B", "      EEE      ", "      EEE      ", "      EEE      ", "      Z~X      "}, {"     TTTTT     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D   D     ", "     ECCCE     ", "     D   D     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D   D     ", "   BAECCCEAB   ", "  A  ECCCE  A  ", " A   ECCCE   A ", "BA   D   D   AB", "B    ECCCE    B", "B    D   D    B", "B    ECCCE    B", "     ECCCE     ", "     ECCCE     ", "     HHHHH     "}, {"    TTTTTTT    ", "    ECCCCCE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "  BAEC   CEAB  ", " B  EC   CE  B ", "BB  EC   CE  BB", "BA  D     D  AB", "A   EC   CE   A", "A   D     D   A", "A   EC   CE   A", "    EC   CE    ", "    EC   CE    ", "    HHHHHHH    "}, {"    TTTTTTT    ", "    ECCCCCE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "  AAEC   CEAA  ", " A  EC   CE  A ", "AB  EC   CE  BA", "AA  D     D  AA", "A   EC   CE   A", "A   D     D   A", "    EC   CE    ", "    EC   CE    ", "    EC   CE    ", "    HHHHHHH    "}, {"    TTTTTTT    ", "    ECCCCCE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    D     D    ", "    EC   CE    ", "    EC   CE    ", "    EC   CE    ", "    D     D    ", "  BAEC   CEAB  ", " B  EC   CE  B ", "BB  EC   CE  BB", "BA  D     D  AB", "A   EC   CE   A", "A   D     D   A", "A   EC   CE   A", "    EC   CE    ", "    EC   CE    ", "    HHHHHHH    "}, {"     TTTTT     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D   D     ", "     ECCCE     ", "     D   D     ", "     ECCCE     ", "     ECCCE     ", "     ECCCE     ", "     D   D     ", "   BAECCCEAB   ", "  A  ECCCE  A  ", " A   ECCCE   A ", "BA   D   D   AB", "B    ECCCE    B", "B    D   D    B", "B    ECCCE    B", "     ECCCE     ", "     ECCCE     ", "     HHHHH     "}, {"      TTT      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "      EEE      ", "      DDD      ", "      EEE      ", "      EEE      ", "      EEE      ", "      DDD      ", "    BAEEEAB    ", "  AA  EEE  AA  ", " A    EEE    A ", "BA    DDD    AB", "B     EEE     B", "B     DDD     B", "      EEE      ", "      EEE      ", "      EEE      ", "      HHH      "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "     BAAAB     ", "   AA     AA   ", " AA         AA ", "BAA          AB", "B             B", "A             A", "A             A", "A             A", "A             A", "A             A"}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "    AA   AA    ", "  AA       AA  ", " BA         AB ", " B           B ", " A           A ", " A           A ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "   AAABBBAAA   ", "  BAAAAAAAAAB  ", "  B         B  ", "  A         A  ", "  A         A  ", "               ", "               ", "               "}, {"               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "               ", "      BAB      ", "   BBBBABBBB   ", "   BBBAAABBB   ", "   ABBAAABBA   ", "   A BA AB A   ", "      A A      ", "      A A      ", "      A A      "}}).addElement('A', StructureUtility.withChannel((String)"manipulator", (IStructureElement)StructureUtility.ofBlocksTiered(GregtechMetaTileEntity_QuantumForceTransformer.craftingTierConverter(), GregtechMetaTileEntity_QuantumForceTransformer.getAllCraftingTiers(), (Object)0, GregtechMetaTileEntity_QuantumForceTransformer::setCraftingTier, GregtechMetaTileEntity_QuantumForceTransformer::getCraftingTier))).addElement('B', StructureUtility.withChannel((String)"shielding", (IStructureElement)StructureUtility.ofBlocksTiered(GregtechMetaTileEntity_QuantumForceTransformer.focusingTierConverter(), GregtechMetaTileEntity_QuantumForceTransformer.getAllFocusingTiers(), (Object)0, GregtechMetaTileEntity_QuantumForceTransformer::setFocusingTier, GregtechMetaTileEntity_QuantumForceTransformer::getFocusingTier))).addElement('C', StructureUtility.ofBlock((Block)ModBlocks.blockCasings4Misc, (int)4)).addElement('D', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12)).addElement('E', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock1(), (int)t.getCasingMeta1()))).addElement('H', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_QuantumForceTransformer.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy.or((IHatchElement)GT_HatchElement.ExoticEnergy)}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(4).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).addElement('T', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_QuantumForceTransformer.class).atLeast(new IHatchElement[]{GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance}).casingIndex(TAE.getIndexFromPage(0, 10)).dot(5).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).addElement('Z', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_QuantumForceTransformer.class).hatchClass(GT_MetaTileEntity_Hatch_Input.class).adder(GregtechMetaTileEntity_QuantumForceTransformer::addNeptuniumHatch).casingIndex(TAE.getIndexFromPage(0, 10)).dot(5).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).addElement('X', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMetaTileEntity_QuantumForceTransformer.class).hatchClass(GT_MetaTileEntity_Hatch_Input.class).adder(GregtechMetaTileEntity_QuantumForceTransformer::addFermiumHatch).casingIndex(TAE.getIndexFromPage(0, 10)).dot(5).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)12))})).build();
    private byte runningTick = 0;

    public GregtechMetaTileEntity_QuantumForceTransformer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_QuantumForceTransformer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_QuantumForceTransformer(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Quantum Force Transformer").addInfo("Controller Block for the Quantum Force Transformer").addInfo("Allows Complex chemical lines to be performed instantly in one step").addInfo("Every recipe requires a catalyst, each catalyst adds 1 parallel and lasts forever").addInfo("Accepts TecTech Energy and Laser Hatches").addInfo("All inputs go on the bottom, all outputs go on the top").addInfo("Put a circuit in the controller to specify the focused output").addInfo("Check NEI to see the order of outputs, and which circuit number you need.").addInfo("If separate input busses are enabled put the circuit in the circuit slot of the bus").addInfo("Uses FocusTier*4*sqrt(parallels) Neptunium Plasma if focusing").addInfo("Can use FocusTier*4*sqrt(parallels) Fermium Plasma for additional chance output").addInfo("This multi gets improved when all casings of some types are upgraded").addInfo("Casing functions:").addInfo("Pulse Manipulators: Recipe Tier Allowed (check NEI for the tier of each recipe)").addInfo("Shielding Cores: Focusing Tier (equal to or higher than recipe tier to allow focus)").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(15, 21, 15, true).addController("Bottom Center").addCasingInfoMin("Bulk Production Frame", 80, false).addCasingInfoMin("Quantum Force Conductor", 177, false).addCasingInfoMin("Force Field Glass", 224, false).addCasingInfoMin("Neutron Pulse Manipulators", 233, false).addCasingInfoMin("Neutron Shielding Cores", 142, false).addInputBus("Bottom Layer", new int[]{4}).addInputHatch("Bottom Layer", new int[]{4}).addOutputHatch("Top Layer", new int[]{5}).addOutputBus("Top Layer", new int[]{5}).addEnergyHatch("Bottom Layer", new int[]{4}).addMaintenanceHatch("Bottom Layer", new int[]{4}).addStructureInfo("Neptunium Plasma Hatch: Left side of Controller").addStructureInfo("Fermium Plasma Hatch: Right side of Controller").toolTipFinisher(GT_Values.AuthorBlueWeabo + EnumChatFormatting.RESET + EnumChatFormatting.GREEN + " + Steelux" + EnumChatFormatting.RESET + " - [GT++]");
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_QuantumForceTransformer> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        if (!this.checkPiece(MAIN_PIECE, 7, 20, 4)) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1 || this.mOutputBusses.size() < 1 || this.mInputBusses.size() < 1 || this.mInputHatches.size() < 1 || this.mOutputHatches.size() < 1) {
            return false;
        }
        if (this.mExoticEnergyHatches.isEmpty() && this.mEnergyHatches.isEmpty()) {
            return false;
        }
        if (this.mExoticEnergyHatches.size() >= 1) {
            if (!this.mEnergyHatches.isEmpty()) {
                return false;
            }
            if (this.mExoticEnergyHatches.size() != 1) {
                return false;
            }
        }
        return this.mEnergyHatches.size() <= 2;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(MAIN_PIECE, stackSize, hintsOnly, 7, 20, 4);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(MAIN_PIECE, stackSize, 7, 20, 4, elementBudget, env, false, true);
    }

    public static List<Pair<Block, Integer>> getAllCraftingTiers() {
        return new ArrayList<Pair<Block, Integer>>(){
            {
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)7));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)8));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)9));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)10));
            }
        };
    }

    public static List<Pair<Block, Integer>> getAllFocusingTiers() {
        return new ArrayList<Pair<Block, Integer>>(){
            {
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)11));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)12));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)13));
                this.add(Pair.of((Object)ModBlocks.blockCasings5Misc, (Object)14));
            }
        };
    }

    public static ITierConverter<Integer> craftingTierConverter() {
        return (block, meta) -> {
            if (block == null) {
                return -1;
            }
            if (block == ModBlocks.blockCasings5Misc) {
                switch (meta) {
                    case 7: {
                        return 1;
                    }
                    case 8: {
                        return 2;
                    }
                    case 9: {
                        return 3;
                    }
                    case 10: {
                        return 4;
                    }
                }
            }
            return -1;
        };
    }

    public static ITierConverter<Integer> focusingTierConverter() {
        return (block, meta) -> {
            if (block == null) {
                return -1;
            }
            if (block == ModBlocks.blockCasings5Misc) {
                switch (meta) {
                    case 11: {
                        return 1;
                    }
                    case 12: {
                        return 2;
                    }
                    case 13: {
                        return 3;
                    }
                    case 14: {
                        return 4;
                    }
                }
            }
            return -1;
        };
    }

    private void setCraftingTier(int tier) {
        this.mCraftingTier = tier;
    }

    private void setFocusingTier(int tier) {
        this.mFocusingTier = tier;
    }

    private int getCraftingTier() {
        return this.mCraftingTier;
    }

    private int getFocusingTier() {
        return this.mFocusingTier;
    }

    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active;
    }

    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Advanced;
    }

    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(0, 10);
    }

    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.quantumForceTransformerRecipes;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){
            private int[] chances;

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                if (recipe.mSpecialValue > GregtechMetaTileEntity_QuantumForceTransformer.this.getCraftingTier()) {
                    return CheckRecipeResultRegistry.insufficientMachineTier((int)recipe.mSpecialValue);
                }
                ItemStack catalyst = null;
                for (ItemStack item : recipe.mInputs) {
                    if (!ItemUtils.isCatalyst(item)) continue;
                    catalyst = item;
                    break;
                }
                if (catalyst == null) {
                    return SimpleCheckRecipeResult.ofFailure((String)"no_catalyst");
                }
                this.maxParallel = 0;
                for (ItemStack item : this.inputItems) {
                    if (!ItemUtils.isCatalyst(item) || !item.func_77969_a(catalyst)) continue;
                    this.maxParallel += item.field_77994_a;
                }
                GregtechMetaTileEntity_QuantumForceTransformer.this.doFermium = false;
                GregtechMetaTileEntity_QuantumForceTransformer.this.doNeptunium = false;
                ItemStack controllerStack = GregtechMetaTileEntity_QuantumForceTransformer.this.getControllerSlot();
                if (recipe.mSpecialValue <= GregtechMetaTileEntity_QuantumForceTransformer.this.getFocusingTier()) {
                    if (GregtechMetaTileEntity_QuantumForceTransformer.this.mFermiumHatch != null && GregtechMetaTileEntity_QuantumForceTransformer.this.mFermiumHatch.getFluid() != null && GregtechMetaTileEntity_QuantumForceTransformer.this.mFermiumHatch.getFluid().getFluid() != null && GregtechMetaTileEntity_QuantumForceTransformer.this.mFermiumHatch.getFluid().getFluid().equals(mFermium)) {
                        GregtechMetaTileEntity_QuantumForceTransformer.this.doFermium = true;
                    }
                    if (GregtechMetaTileEntity_QuantumForceTransformer.this.mNeptuniumHatch != null && GregtechMetaTileEntity_QuantumForceTransformer.this.mNeptuniumHatch.getFluid() != null && GregtechMetaTileEntity_QuantumForceTransformer.this.mNeptuniumHatch.getFluid().getFluid() != null && GregtechMetaTileEntity_QuantumForceTransformer.this.mNeptuniumHatch.getFluid().getFluid().equals(mNeptunium)) {
                        GregtechMetaTileEntity_QuantumForceTransformer.this.doNeptunium = true;
                    }
                }
                this.chances = GregtechMetaTileEntity_QuantumForceTransformer.this.GetChanceOutputs(recipe, GregtechMetaTileEntity_QuantumForceTransformer.this.doNeptunium && controllerStack != null ? controllerStack.func_77960_j() - 1 : -1);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @NotNull
            public GT_ParallelHelper createParallelHelper(@Nonnull GT_Recipe recipe) {
                return super.createParallelHelper(recipe).setCustomItemOutputCalculation(parallel -> {
                    ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                    if (GregtechMetaTileEntity_QuantumForceTransformer.this.mFluidMode) {
                        for (int i = 0; i < recipe.mOutputs.length; ++i) {
                            Materials mat;
                            ItemStack item = recipe.getOutput(i);
                            if (item == null) continue;
                            ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)item);
                            Materials materials = mat = data == null ? null : data.mMaterial.mMaterial;
                            if (mat != null && (mat.getMolten(0L) != null || mat.getFluid(0L) != null)) continue;
                            ItemStack itemToAdd = item.func_77946_l();
                            itemToAdd.field_77994_a = 0;
                            for (int j = 0; j < parallel; ++j) {
                                if (GregtechMetaTileEntity_QuantumForceTransformer.this.getBaseMetaTileEntity().getRandomNumber(10000) >= this.chances[i]) continue;
                                itemToAdd.field_77994_a += item.field_77994_a;
                            }
                            if (itemToAdd.field_77994_a == 0) continue;
                            items.add(itemToAdd);
                        }
                    } else {
                        for (int i = 0; i < recipe.mOutputs.length; ++i) {
                            ItemStack item = recipe.getOutput(i);
                            if (item == null) continue;
                            ItemStack itemToAdd = item.func_77946_l();
                            itemToAdd.field_77994_a = 0;
                            for (int j = 0; j < parallel; ++j) {
                                if (GregtechMetaTileEntity_QuantumForceTransformer.this.getBaseMetaTileEntity().getRandomNumber(10000) >= this.chances[i]) continue;
                                itemToAdd.field_77994_a += item.field_77994_a;
                            }
                            if (itemToAdd.field_77994_a == 0) continue;
                            items.add(itemToAdd);
                        }
                    }
                    return items.toArray(new ItemStack[0]);
                }).setCustomFluidOutputCalculation(parallel -> {
                    int i;
                    ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
                    if (GregtechMetaTileEntity_QuantumForceTransformer.this.mFluidMode) {
                        for (i = 0; i < recipe.mOutputs.length; ++i) {
                            int j;
                            FluidStack fluid;
                            Materials mat;
                            ItemStack item = recipe.getOutput(i);
                            if (item == null) continue;
                            ItemData data = GT_OreDictUnificator.getAssociation((ItemStack)item);
                            Materials materials = mat = data == null ? null : data.mMaterial.mMaterial;
                            if (mat == null) continue;
                            if (mat.getMolten(0L) != null) {
                                fluid = mat.getMolten(0L);
                                for (j = 0; j < parallel; ++j) {
                                    if (GregtechMetaTileEntity_QuantumForceTransformer.this.getBaseMetaTileEntity().getRandomNumber(10000) >= this.chances[i]) continue;
                                    fluid.amount += item.field_77994_a * 144;
                                }
                                if (fluid.amount == 0) continue;
                                fluids.add(fluid);
                                continue;
                            }
                            if (mat.getFluid(0L) == null) continue;
                            fluid = mat.getFluid(0L);
                            for (j = 0; j < parallel; ++j) {
                                if (GregtechMetaTileEntity_QuantumForceTransformer.this.getBaseMetaTileEntity().getRandomNumber(10000) >= this.chances[i]) continue;
                                fluid.amount += item.field_77994_a * 1000;
                            }
                            if (fluid.amount == 0) continue;
                            fluids.add(fluid);
                        }
                    }
                    for (i = 0; i < recipe.mFluidOutputs.length; ++i) {
                        FluidStack fluid = recipe.getFluidOutput(i);
                        if (fluid == null) continue;
                        FluidStack fluidToAdd = fluid.copy();
                        fluidToAdd.amount = 0;
                        for (int j = 0; j < parallel; ++j) {
                            if (GregtechMetaTileEntity_QuantumForceTransformer.this.getBaseMetaTileEntity().getRandomNumber(10000) >= this.chances[i + recipe.mOutputs.length]) continue;
                            fluidToAdd.amount += fluid.amount;
                        }
                        if (fluidToAdd.amount == 0) continue;
                        fluids.add(fluidToAdd);
                    }
                    return fluids.toArray(new FluidStack[0]);
                });
            }
        };
    }

    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(this.getAverageInputVoltage());
        logic.setAvailableAmperage(this.getMaxInputAmps());
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (!super.onRunningTick(aStack)) {
            this.criticalStopMachine();
            return false;
        }
        if (this.runningTick % 20 == 0) {
            FluidStack tLiquid;
            int amount = (int)((double)(this.getFocusingTier() * 4) * Math.sqrt(this.processingLogic.getCurrentParallels()));
            if (this.doFermium && ((tLiquid = this.mFermiumHatch.drain(amount, true)) == null || tLiquid.amount < amount)) {
                this.doFermium = false;
                this.criticalStopMachine();
                return false;
            }
            if (this.doNeptunium && ((tLiquid = this.mNeptuniumHatch.drain(amount, true)) == null || tLiquid.amount < amount)) {
                this.doNeptunium = false;
                this.criticalStopMachine();
                return false;
            }
            this.runningTick = 1;
        } else {
            this.runningTick = (byte)(this.runningTick + 1);
        }
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private int[] GetChanceOutputs(GT_Recipe tRecipe, int aChanceIncreased) {
        int difference = this.getFocusingTier() - tRecipe.mSpecialValue;
        int aOutputsAmount = tRecipe.mOutputs.length + tRecipe.mFluidOutputs.length;
        int aChancePerOutput = 10000 / aOutputsAmount;
        int[] tChances = new int[aOutputsAmount];
        Arrays.fill(tChances, aChancePerOutput);
        switch (difference) {
            case 0: {
                for (int i = 0; i < tChances.length; ++i) {
                    if (this.doNeptunium) {
                        if (i == aChanceIncreased) {
                            tChances[i] = aChancePerOutput / 2 * (aOutputsAmount - 1);
                        } else {
                            int n = i;
                            tChances[n] = tChances[n] / 2;
                        }
                    }
                    if (!this.doFermium) continue;
                    int n = i;
                    tChances[n] = tChances[n] + (10000 - tChances[i]) / 4;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < tChances.length; ++i) {
                    if (this.doNeptunium) {
                        if (i == aChanceIncreased) {
                            tChances[i] = aChancePerOutput * 3 / 4 * (aOutputsAmount - 1);
                        } else {
                            int n = i;
                            tChances[n] = tChances[n] / 4;
                        }
                    }
                    if (!this.doFermium) continue;
                    int n = i;
                    tChances[n] = tChances[n] + (10000 - tChances[i]) / 3;
                }
                break;
            }
            case 2: 
            case 3: {
                for (int i = 0; i < tChances.length; ++i) {
                    if (this.doNeptunium) {
                        tChances[i] = i == aChanceIncreased ? 10000 : 0;
                    }
                    if (!this.doFermium) continue;
                    int n = i;
                    tChances[n] = tChances[n] + (10000 - tChances[i]) / 2;
                }
                break;
            }
        }
        return tChances;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mFluidMode = !this.mFluidMode;
        GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)"miscutils.machines.QFTFluidMode") + " " + this.mFluidMode));
    }

    public boolean addNeptuniumHatch(IGregTechTileEntity aTileEntity, short aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture((int)aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = null;
            this.mNeptuniumHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addFermiumHatch(IGregTechTileEntity aTileEntity, short aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture((int)aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = null;
            this.mFermiumHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public Block getCasingBlock1() {
        return ModBlocks.blockCasings5Misc;
    }

    public byte getCasingMeta1() {
        return 15;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mFluidMode", this.mFluidMode);
        aNBT.func_74757_a("doFermium", this.doFermium);
        aNBT.func_74757_a("doNeptunium", this.doNeptunium);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (!aNBT.func_74764_b("inputSeparation")) {
            this.inputSeparation = aNBT.func_74767_n("mSeparateInputBusses");
        }
        if (!aNBT.func_74764_b("batchMode")) {
            this.batchMode = aNBT.func_74767_n("mBatchMode");
        }
        this.mFluidMode = aNBT.func_74767_n("mFluidMode");
        this.doFermium = aNBT.func_74767_n("doFermium");
        this.doNeptunium = aNBT.func_74767_n("doNeptunium");
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{this.getCasingTexture(), TextureFactory.builder().addIcon(new IIconContainer[]{this.getActiveOverlay()}).extFacing().build()};
            }
            return new ITexture[]{this.getCasingTexture(), TextureFactory.builder().addIcon(new IIconContainer[]{this.getInactiveOverlay()}).extFacing().build()};
        }
        return new ITexture[]{this.getCasingTexture()};
    }

    private ITexture getCasingTexture() {
        return Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureId());
    }

    @SideOnly(value=Side.CLIENT)
    private void renderForceField(double x, double y, double z, int side, double minU, double maxU, double minV, double maxV) {
        Tessellator tes = Tessellator.field_78398_a;
        switch (side) {
            case 0: {
                tes.func_78374_a(x + 3.0, y, z + 7.0, maxU, maxV);
                tes.func_78374_a(x + 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x - 3.0, y + 4.0, z + 7.0, minU, minV);
                tes.func_78374_a(x - 3.0, y, z + 7.0, minU, maxV);
                tes.func_78374_a(x - 3.0, y, z + 7.0, minU, maxV);
                tes.func_78374_a(x - 3.0, y + 4.0, z + 7.0, minU, minV);
                tes.func_78374_a(x + 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x + 3.0, y, z + 7.0, maxU, maxV);
                break;
            }
            case 1: {
                tes.func_78374_a(x + 7.0, y, z + 4.0, maxU, maxV);
                tes.func_78374_a(x + 7.0, y + 4.0, z + 4.0, maxU, minV);
                tes.func_78374_a(x + 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x + 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x + 7.0, y + 4.0, z + 4.0, maxU, minV);
                tes.func_78374_a(x + 7.0, y, z + 4.0, maxU, maxV);
                break;
            }
            case 2: {
                tes.func_78374_a(x + 3.0, y, z - 7.0, maxU, maxV);
                tes.func_78374_a(x + 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x - 3.0, y + 4.0, z - 7.0, minU, minV);
                tes.func_78374_a(x - 3.0, y, z - 7.0, minU, maxV);
                tes.func_78374_a(x - 3.0, y, z - 7.0, minU, maxV);
                tes.func_78374_a(x - 3.0, y + 4.0, z - 7.0, minU, minV);
                tes.func_78374_a(x + 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x + 3.0, y, z - 7.0, maxU, maxV);
                break;
            }
            case 3: {
                tes.func_78374_a(x - 7.0, y, z + 4.0, maxU, maxV);
                tes.func_78374_a(x - 7.0, y + 4.0, z + 4.0, maxU, minV);
                tes.func_78374_a(x - 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x - 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x - 7.0, y + 4.0, z + 4.0, maxU, minV);
                tes.func_78374_a(x - 7.0, y, z + 4.0, maxU, maxV);
                break;
            }
            case 4: {
                tes.func_78374_a(x - 3.0, y, z + 7.0, maxU, maxV);
                tes.func_78374_a(x - 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x - 7.0, y + 4.0, z + 4.0, minU, minV);
                tes.func_78374_a(x - 7.0, y, z + 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y, z + 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y + 4.0, z + 4.0, minU, minV);
                tes.func_78374_a(x - 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x - 3.0, y, z + 7.0, maxU, maxV);
                break;
            }
            case 5: {
                tes.func_78374_a(x - 3.0, y, z - 7.0, maxU, maxV);
                tes.func_78374_a(x - 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x - 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x - 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x - 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x - 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x - 3.0, y, z - 7.0, maxU, maxV);
                break;
            }
            case 6: {
                tes.func_78374_a(x + 3.0, y, z + 7.0, maxU, maxV);
                tes.func_78374_a(x + 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x + 7.0, y + 4.0, z + 4.0, minU, minV);
                tes.func_78374_a(x + 7.0, y, z + 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y, z + 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y + 4.0, z + 4.0, minU, minV);
                tes.func_78374_a(x + 3.0, y + 4.0, z + 7.0, maxU, minV);
                tes.func_78374_a(x + 3.0, y, z + 7.0, maxU, maxV);
                break;
            }
            case 7: {
                tes.func_78374_a(x + 3.0, y, z - 7.0, maxU, maxV);
                tes.func_78374_a(x + 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x + 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x + 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y, z - 4.0, minU, maxV);
                tes.func_78374_a(x + 7.0, y + 4.0, z - 4.0, minU, minV);
                tes.func_78374_a(x + 3.0, y + 4.0, z - 7.0, maxU, minV);
                tes.func_78374_a(x + 3.0, y, z - 7.0, maxU, maxV);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderInWorld(IBlockAccess aWorld, int x, int y, int z, Block block, RenderBlocks renderer) {
        Tessellator tes = Tessellator.field_78398_a;
        IIcon forceField = TexturesGtBlock.ForceField.getIcon();
        if (this.getBaseMetaTileEntity().isActive()) {
            double minU = forceField.func_94209_e();
            double maxU = forceField.func_94212_f();
            double minV = forceField.func_94206_g();
            double maxV = forceField.func_94210_h();
            double xBaseOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
            double zBaseOffset = 3 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            tes.func_78386_a(1.0f, 1.0f, 1.0f);
            tes.func_78380_c(0xF000F0);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 0, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 1, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 2, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 3, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 4, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 5, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 6, minU, maxU, minV, maxV);
            this.renderForceField((double)x + xBaseOffset + 0.5, y, (double)z + zBaseOffset + 0.5, 7, minU, maxU, minV, maxV);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
        return false;
    }

    public boolean supportsInputSeparation() {
        return true;
    }
}

