/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.FlotationRecipeHandler;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GregtechMTE_FrothFlotationCell
extends GregtechMeta_MultiBlockBase<GregtechMTE_FrothFlotationCell>
implements ISurvivalConstructable {
    private int mCasing;
    private static IStructureDefinition<GregtechMTE_FrothFlotationCell> STRUCTURE_DEFINITION = null;
    private String lockedMaterialName = null;

    public GregtechMTE_FrothFlotationCell(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMTE_FrothFlotationCell(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_FrothFlotationCell(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Flotation Cell";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Process that milled ore!").addInfo("You can only ever process one type of material per controller").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(7, 9, 7, true).addController("Front Center").addCasingInfoMin("Inconel Reinforced Casing", 68, false).addCasingInfoMin("Flotation Casing", 52, false).addInputBus("Bottom Casing", new int[]{1}).addInputHatch("Bottom Casing", new int[]{1}).addOutputHatch("Bottom Casing", new int[]{1}).addEnergyHatch("Bottom Casing", new int[]{1}).addMaintenanceHatch("Bottom Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder.get());
        return tt;
    }

    protected SoundResource getProcessStartSound() {
        return SoundResource.IC2_MACHINES_ELECTROFURNACE_LOOP;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Default_Active;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.Overlay_Machine_Controller_Default;
    }

    @Override
    protected int getCasingTextureId() {
        return TAE.getIndexFromPage(2, 1);
    }

    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.flotationCellRecipes;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    public IStructureDefinition<GregtechMTE_FrothFlotationCell> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, (String[][])new String[][]{{"       ", "       ", "   X   ", "  X~X  ", "   X   ", "       ", "       "}, {"       ", "   F   ", "  FFF  ", " FF FF ", "  FFF  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"       ", "   F   ", "  F F  ", " F   F ", "  F F  ", "   F   ", "       "}, {"  CCC  ", " CCCCC ", "CCCCCCC", "CCCCCCC", "CCCCCCC", " CCCCC ", "  CCC  "}, {"  CCC  ", " CCCCC ", "CCCCCCC", "CCCCCCC", "CCCCCCC", " CCCCC ", "  CCC  "}}).addElement('C', (IStructureElement)GT_StructureUtility.buildHatchAdder(GregtechMTE_FrothFlotationCell.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.Maintenance, GT_HatchElement.Energy}).casingIndex(this.getCasingTextureId()).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)1))})).addElement('F', StructureUtility.ofBlock((Block)ModBlocks.blockSpecialMultiCasings, (int)9)).addElement('X', StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)1)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 3, 3, 0) && this.mCasing >= 64 && this.checkHatch();
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d == ForgeDirection.UP;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiFrothFlotationCell;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                Material foundMaterial = FlotationRecipeHandler.getMaterialOfMilledProduct(FlotationRecipeHandler.findMilledStack(recipe));
                String foundMaterialName = null;
                if (foundMaterial != null) {
                    foundMaterialName = foundMaterial.getUnlocalizedName();
                }
                if (foundMaterialName == null) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                if (GregtechMTE_FrothFlotationCell.this.lockedMaterialName == null) {
                    GregtechMTE_FrothFlotationCell.this.lockedMaterialName = foundMaterialName;
                }
                if (!Objects.equals(GregtechMTE_FrothFlotationCell.this.lockedMaterialName, foundMaterialName)) {
                    return SimpleCheckRecipeResult.ofFailure((String)"machine_locked_to_different_recipe");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        };
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        if (this.lockedMaterialName != null) {
            aNBT.func_74778_a("lockedMaterialName", this.lockedMaterialName);
        }
        super.setItemNBT(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.lockedMaterialName != null) {
            aNBT.func_74778_a("lockedMaterialName", this.lockedMaterialName);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.func_150297_b("lockedMaterialName", 8)) {
            this.lockedMaterialName = aNBT.func_74779_i("lockedMaterialName");
        }
    }

    public void addAdditionalTooltipInformation(ItemStack stack, List<String> tooltip) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("lockedMaterialName")) {
            tooltip.add(StatCollector.func_74838_a((String)"tooltip.flotationCell.lockedTo") + " " + StatCollector.func_74838_a((String)stack.func_77978_p().func_74779_i("lockedMaterialName")));
        }
    }

    @Override
    public String[] getExtraInfoData() {
        return new String[]{"Locked material: " + this.lockedMaterialName};
    }

    public boolean isRecipeLockingEnabled() {
        return this.lockedMaterialName != null && !this.lockedMaterialName.equals("");
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.lockedMaterialName, val -> {
            this.lockedMaterialName = val;
        }));
    }
}

