/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.GregtechMetaTileEntity_LargerTurbineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_TurbineProvider
extends GT_MetaTileEntity_Hatch_InputBus {
    private GT_MetaTileEntity_LargeTurbine mParent = null;
    private int mRefreshTime = 1200;
    private boolean mDescending = true;

    public GT_MetaTileEntity_Hatch_TurbineProvider(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public GT_MetaTileEntity_Hatch_TurbineProvider(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_TurbineProvider(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public String[] getDescription() {
        return new String[]{"An automation port for Large Turbines", "Will attempt once per 1200 ticks to fill the turbine slot of it's parent turbine", "You may adjust this with a screwdriver", "Hold shift to adjust in finer amounts", "Hold control to adjust direction", "Left Click with Screwdriver to reset", "This module assumes the entire turbine is in the same Chunk", CORE.GT_Tooltip.get()};
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        super.onPostTick(aBaseMetaTileEntity, aTimer);
        if (aTimer % (long)this.mRefreshTime == 0L && this.getBaseMetaTileEntity().isServerSide()) {
            this.tryRefillTurbine();
        }
    }

    private void tryFindParentTurbine() {
        Logger.INFO("This turbine housing has no parent, searching world.");
        IGregTechTileEntity T = this.getBaseMetaTileEntity();
        World W = T.getWorld();
        Chunk C = W.func_72938_d(T.getXCoord(), T.getZCoord());
        for (Object o : C.field_150816_i.values()) {
            IGregTechTileEntity G;
            IMetaTileEntity aMetaTileEntity;
            if (!(o instanceof IGregTechTileEntity) || (aMetaTileEntity = (G = (IGregTechTileEntity)o).getMetaTileEntity()) == null || !(aMetaTileEntity instanceof GT_MetaTileEntity_LargeTurbine)) continue;
            GT_MetaTileEntity_LargeTurbine aTurb = (GT_MetaTileEntity_LargeTurbine)aMetaTileEntity;
            for (GT_MetaTileEntity_Hatch_InputBus ee : aTurb.mInputBusses) {
                if (!ee.equals((Object)this)) continue;
                this.mParent = aTurb;
                Logger.INFO("Found a Parent to attach to this housing.");
                return;
            }
        }
    }

    private void tryRefillTurbine() {
        if (this.mParent == null) {
            this.tryFindParentTurbine();
        }
        if (this.mParent != null && this.mParent.mInventory[1] == null) {
            for (ItemStack aStack : this.mInventory) {
                if (!this.isItemStackTurbine(aStack)) continue;
                this.setGUIItemStack(aStack);
            }
        }
    }

    protected boolean setGUIItemStack(ItemStack aNewGuiSlotContents) {
        boolean result = false;
        if (this.mParent.mInventory[1] == null) {
            this.mParent.mInventory[1] = aNewGuiSlotContents != null ? aNewGuiSlotContents.func_77946_l() : null;
            this.mParent.depleteInput(aNewGuiSlotContents);
            this.mParent.updateSlots();
            this.updateSlots();
            result = true;
        }
        return result;
    }

    public boolean isItemStackTurbine(ItemStack aStack) {
        return aStack.func_77973_b() instanceof GT_MetaGenerated_Tool && aStack.func_77960_j() >= 170 && aStack.func_77960_j() <= 176;
    }

    public boolean isItemStackScrewdriver(ItemStack aStack) {
        return aStack.func_77973_b() instanceof GT_MetaGenerated_Tool && (aStack.func_77960_j() == 22 || aStack.func_77960_j() == 150);
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return this.isItemStackTurbine(aStack);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mRefreshTime", this.mRefreshTime);
        aNBT.func_74757_a("mDescending", this.mDescending);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mRefreshTime = aNBT.func_74762_e("mRefreshTime");
        this.mDescending = aNBT.func_74767_n("mDescending");
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer != null) {
            if (KeyboardUtils.isCtrlKeyDown()) {
                this.mDescending = !this.mDescending;
                PlayerUtils.messagePlayer(aPlayer, "Direction: " + (this.mDescending ? "DOWN" : "UP"));
            } else {
                int aAmount = 0;
                aAmount = KeyboardUtils.isShiftKeyDown() ? 10 : 100;
                if (this.mDescending) {
                    this.mRefreshTime -= aAmount;
                    if (this.mRefreshTime < 0) {
                        this.mRefreshTime = 1200;
                    }
                } else {
                    this.mRefreshTime += aAmount;
                    if (this.mRefreshTime > 1200) {
                        this.mRefreshTime = 0;
                    }
                }
                PlayerUtils.messagePlayer(aPlayer, "Set check time to be every " + this.mRefreshTime + " ticks.");
            }
        }
    }

    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        boolean aDidScrewdriver = false;
        if (aPlayer != null && aPlayer.func_70694_bm() != null && this.isItemStackScrewdriver(aPlayer.func_70694_bm())) {
            aDidScrewdriver = true;
            this.mRefreshTime = 1200;
            PlayerUtils.messagePlayer(aPlayer, "Reset check time to " + this.mRefreshTime + " ticks.");
        }
        if (!aDidScrewdriver) {
            super.onLeftclick(aBaseMetaTileEntity, aPlayer);
        }
    }

    public boolean allowSelectCircuit() {
        return false;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setFilter(GregtechMetaTileEntity_LargerTurbineBase::isValidTurbine).setAccess(false, true).setPos(79, 34));
    }
}

