/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry;

import binnie.extratrees.genetics.ExtraTreeSpecies;
import cpw.mods.fml.common.Optional;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IIndividual;
import forestry.arboriculture.genetics.TreeDefinition;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.forestry.bees.items.FR_ItemRegistry;
import gtPlusPlus.xmod.forestry.bees.recipe.FR_Gregtech_Recipes;
import gtPlusPlus.xmod.forestry.bees.registry.GTPP_Bees;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.GregtechMetaTileEntityTreeFarm;
import net.minecraft.item.ItemStack;

public class HANDLER_FR {
    public static void preInit() {
        if (Mods.Forestry.isModLoaded()) {
            FR_ItemRegistry.Register();
        }
    }

    public static void postInit() {
        if (Mods.Forestry.isModLoaded()) {
            FR_Gregtech_Recipes.registerItems();
            new GTPP_Bees();
            HANDLER_FR.mapForestrySaplingToLog();
        }
        if (Mods.ExtraTrees.isModLoaded()) {
            HANDLER_FR.mapExtraTreesSaplingToLog();
        }
    }

    @Optional.Method(modid="Forestry")
    private static void mapForestrySaplingToLog() {
        for (TreeDefinition value : TreeDefinition.values()) {
            ItemStack aLog;
            ItemStack aSaplingStack = value.getMemberStack(EnumGermlingType.SAPLING);
            EnumWoodType woodType = (EnumWoodType)ReflectionUtils.getField(value, "woodType");
            if (woodType != null) {
                aLog = TreeManager.woodItemAccess.getLog(woodType, false);
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID(), aLog);
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID() + "fireproof", TreeManager.woodItemAccess.getLog(woodType, true));
            } else {
                aLog = (ItemStack)ReflectionUtils.getField(value, "vanillaWood");
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID(), (ItemStack)ReflectionUtils.getField(value, "vanillaWood"));
            }
            GregtechMetaTileEntityTreeFarm.addFakeRecipeToNEI(aSaplingStack, aLog);
        }
    }

    @Optional.Method(modid="ExtraTrees")
    private static void mapExtraTreesSaplingToLog() {
        for (ExtraTreeSpecies value : ExtraTreeSpecies.values()) {
            ItemStack aSaplingStack = TreeManager.treeRoot.getMemberStack((IIndividual)TreeManager.treeRoot.templateAsIndividual(value.getTemplate()), 0);
            ItemStack aLog = null;
            if (value.getLog() != null) {
                aLog = value.getLog().getItemStack();
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID(), aLog);
                GregtechMetaTileEntityTreeFarm.sLogCache.put(value.getUID() + "fireproof", aLog);
            }
            GregtechMetaTileEntityTreeFarm.addFakeRecipeToNEI(aSaplingStack, aLog);
        }
    }
}

