/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft;

import codechicken.nei.api.API;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.base.dusts.BaseItemDustUnique;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.item.chemistry.GenericChem;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.minecraft.OreDictUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.CORE_Preloader;
import gtPlusPlus.xmod.gregtech.api.items.Gregtech_MetaTool;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechTools;
import gtPlusPlus.xmod.gregtech.loaders.RecipeGen_DustGeneration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtils {
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;
    private static final Map<Item, String> mModidCache = new HashMap<Item, String>();

    public static ItemStack getSimpleStack(Item x) {
        return ItemUtils.getSimpleStack(x, 1);
    }

    public static ItemStack getSimpleStack(Block x) {
        return ItemUtils.simpleMetaStack(Item.func_150898_a((Block)x), 0, 1);
    }

    public static ItemStack getSimpleStack(Block x, int i) {
        if (i == 0) {
            return ItemUtils.getSimpleStack(x, i, 1);
        }
        return ItemUtils.getSimpleStack(x, 0, i);
    }

    public static ItemStack getSimpleStack(Block x, int meta, int i) {
        return ItemUtils.simpleMetaStack(Item.func_150898_a((Block)x), meta, i);
    }

    public static ItemStack getSimpleStack(Item x, int i) {
        return new ItemStack(x, i);
    }

    public static ItemStack getSimpleStack(ItemStack x, int i) {
        if (x == null) {
            return null;
        }
        ItemStack r = x.func_77946_l();
        r.field_77994_a = i;
        return r;
    }

    public static ItemStack getWildcardStack(ItemStack x) {
        return ItemUtils.simpleMetaStack(x, Short.MAX_VALUE, 1);
    }

    public static ItemStack getIC2Cell(int meta) {
        return GT_ModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCellEmpty", (long)1L, (int)meta);
    }

    public static ItemStack getEmptyCell() {
        return ItemUtils.getEmptyCell(1);
    }

    public static ItemStack getEmptyCell(int i) {
        if (ItemList.Cell_Empty.hasBeenSet()) {
            return ItemList.Cell_Empty.get((long)i, new Object[0]);
        }
        ItemStack temp = GT_ModHandler.getModItem((String)Mods.IndustrialCraft2.ID, (String)"itemCellEmpty", (long)i, (int)0);
        return temp != null ? temp : null;
    }

    public static void getItemForOreDict(String FQRN, String oreDictName, String itemName, int meta) {
        try {
            Item em = null;
            Item em1 = ItemUtils.getItemFromFQRN(FQRN);
            if (em1 != null) {
                em = em1;
            }
            if (em != null) {
                ItemStack metaStack = new ItemStack(em, 1, meta);
                GT_OreDictUnificator.registerOre((Object)oreDictName, (ItemStack)metaStack);
            }
        }
        catch (NullPointerException e) {
            Logger.ERROR(itemName + " not found. [NULL]");
        }
    }

    public static void addItemToOreDictionary(ItemStack stack, String oreDictName, boolean useWildcardMeta) {
        if (useWildcardMeta) {
            stack = ItemUtils.getWildcardStack(stack);
        }
        try {
            OreDictionary.registerOre((String)oreDictName, (ItemStack)stack);
        }
        catch (NullPointerException e) {
            Logger.ERROR(ItemUtils.getItemName(stack) + " not registered. [NULL]");
        }
    }

    public static void addItemToOreDictionary(ItemStack stack, String oreDictName) {
        ItemUtils.addItemToOreDictionary(stack, oreDictName, false);
    }

    public static ItemStack getItemStackWithMeta(boolean MOD, String FQRN, String itemName, int meta, int itemstackSize) {
        if (MOD) {
            try {
                Item em = null;
                Item em1 = ItemUtils.getItemFromFQRN(FQRN);
                if (em1 != null) {
                    if (null == em) {
                        em = em1;
                    }
                    if (em != null) {
                        ItemStack metaStack = new ItemStack(em, itemstackSize, meta);
                        return metaStack;
                    }
                }
                return null;
            }
            catch (NullPointerException e) {
                Logger.ERROR(itemName + " not found. [NULL]");
                return null;
            }
        }
        return null;
    }

    public static ItemStack simpleMetaStack(String FQRN, int meta, int itemstackSize) {
        try {
            Item em = null;
            Item em1 = ItemUtils.getItemFromFQRN(FQRN);
            if (em1 != null) {
                if (null == em) {
                    em = em1;
                }
                if (em != null) {
                    ItemStack metaStack = new ItemStack(em, itemstackSize, meta);
                    return metaStack;
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            Logger.ERROR(FQRN + " not found. [NULL]");
            return null;
        }
    }

    public static ItemStack simpleMetaStack(ItemStack simpleStack, int meta, int size) {
        return ItemUtils.simpleMetaStack(simpleStack.func_77973_b(), meta, size);
    }

    public static ItemStack simpleMetaStack(Item item, int meta, int size) {
        if (item == null) {
            return null;
        }
        if (meta < 0 || meta > Short.MAX_VALUE) {
            meta = 0;
        }
        if (size < 0 || size > 64) {
            size = 1;
        }
        return new ItemStack(item, size, meta);
    }

    public static ItemStack simpleMetaStack(Block block, int meta, int size) {
        return ItemUtils.simpleMetaStack(Item.func_150898_a((Block)block), meta, size);
    }

    public static ItemStack getCorrectStacktype(String fqrn, int stackSize) {
        String oreDict = "ore:";
        if (fqrn.toLowerCase().contains("ore:".toLowerCase())) {
            String sanitizedName = fqrn.replace("ore:", "");
            ItemStack temp = ItemUtils.getItemStackFromFQRN(sanitizedName, stackSize);
            return temp;
        }
        String[] fqrnSplit = fqrn.split(":");
        String temp1 = fqrnSplit[1];
        String temp2 = fqrnSplit.length < 3 ? "0" : fqrnSplit[2];
        ItemStack temp = ItemUtils.getItemStackWithMeta(true, fqrn, temp1, Integer.parseInt(temp2), stackSize);
        return temp;
    }

    public static Item getItemFromFQRN(String fqrn) {
        String[] fqrnSplit = fqrn.split(":");
        return GameRegistry.findItem((String)fqrnSplit[0], (String)fqrnSplit[1]);
    }

    public static ItemStack getItemStackFromFQRN(String fqrn, int Size) {
        Logger.INFO("Trying to split string '" + fqrn + "'.");
        String[] fqrnSplit = fqrn.split(":");
        if (fqrnSplit.length < 2) {
            return null;
        }
        if (fqrnSplit.length == 2) {
            Logger.INFO("Mod: " + fqrnSplit[0] + ", Item: " + fqrnSplit[1]);
            return GameRegistry.findItemStack((String)fqrnSplit[0], (String)fqrnSplit[1], (int)Size);
        }
        if (fqrnSplit.length == 3 && fqrnSplit[2] != null && fqrnSplit[2].length() > 0) {
            Logger.INFO("Mod: " + fqrnSplit[0] + ", Item: " + fqrnSplit[1] + ", Meta: " + fqrnSplit[2]);
            ItemStack aStack = GameRegistry.findItemStack((String)fqrnSplit[0], (String)fqrnSplit[1], (int)Size);
            int aMeta = Integer.parseInt(fqrnSplit[2]);
            if (aStack != null && aMeta >= 0 && aMeta <= Short.MAX_VALUE) {
                return ItemUtils.simpleMetaStack(aStack, aMeta, Size);
            }
            Logger.INFO("Could not find instance of Item: " + fqrnSplit[1]);
        }
        return null;
    }

    public static ItemStack[] validItemsForOreDict(String oredictName) {
        List<?> validNames = MaterialUtils.oreDictValuesForEntry(oredictName);
        ItemStack[] inputs = new ItemStack[validNames.size()];
        for (int i = 0; i < validNames.size(); ++i) {
            inputs[i] = (ItemStack)validNames.get(i);
        }
        return inputs;
    }

    public static ItemStack getItemStackOfAmountFromOreDict(String oredictName, int amount) {
        String mTemp = oredictName;
        mTemp = oredictName.contains("-") || oredictName.contains("_") ? Utils.sanitizeString(mTemp, new char[]{'-', '_'}) : Utils.sanitizeString(mTemp);
        if (oredictName.contains("rod")) {
            String s;
            oredictName = s = "stick" + oredictName.substring(3);
        }
        if (oredictName.toLowerCase().contains("ingotclay")) {
            return ItemUtils.getSimpleStack(Items.field_151119_aD, amount);
        }
        ArrayList oreDictList = OreDictionary.getOres((String)mTemp);
        if (!oreDictList.isEmpty()) {
            ItemStack returnValue = ((ItemStack)oreDictList.get(0)).func_77946_l();
            returnValue.field_77994_a = amount;
            return returnValue;
        }
        Logger.INFO("Failed to find `" + oredictName + "` in OD.");
        return ItemUtils.getErrorStack(amount, oredictName + " x" + amount);
    }

    public static ItemStack getItemStackOfAmountFromOreDictNoBroken(String oredictName, int amount) {
        if (CORE_Preloader.DEBUG_MODE) {
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(1));
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(2));
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(3));
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(4));
            Logger.WARNING("Looking up: " + oredictName + " - from method: " + ReflectionUtils.getMethodName(5));
        }
        try {
            String MaterialName;
            Materials m;
            oredictName = oredictName.contains("-") || oredictName.contains("_") ? Utils.sanitizeString(oredictName, new char[]{'-', '_'}) : Utils.sanitizeString(oredictName);
            ItemStack returnValue = null;
            if (oredictName.toLowerCase().contains("dust") && (m = Materials.get((String)(MaterialName = oredictName.toLowerCase().replace("dust", "")))) != null && m != Materials._NULL && ItemUtils.checkForInvalidItems(returnValue = ItemUtils.getGregtechDust(m, amount))) {
                return returnValue;
            }
            if (returnValue == null && ItemUtils.checkForInvalidItems(returnValue = ItemUtils.getItemStackOfAmountFromOreDict(oredictName, amount))) {
                return returnValue.func_77946_l();
            }
            Logger.RECIPE(oredictName + " was not valid.");
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ItemStack getGregtechDust(Materials material, int amount) {
        ItemStack returnValue = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)material, (long)1L);
        if (returnValue != null && ItemUtils.checkForInvalidItems(returnValue)) {
            return returnValue.func_77946_l();
        }
        Logger.WARNING(material + " was not valid.");
        return null;
    }

    public static Item[] generateSpecialUseDusts(String unlocalizedName, String materialName, int Colour) {
        return ItemUtils.generateSpecialUseDusts(unlocalizedName, materialName, "NullFormula", Colour);
    }

    public static Item[] generateSpecialUseDusts(String unlocalizedName, String materialName, String mChemForm, int Colour) {
        GT_LanguageManager.addStringLocalization((String)("gtplusplus.material." + materialName), (String)materialName);
        Item[] output = new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, mChemForm, Colour, "Dust"), new BaseItemDustUnique("itemDustSmall" + unlocalizedName, materialName, mChemForm, Colour, "Small"), new BaseItemDustUnique("itemDustTiny" + unlocalizedName, materialName, mChemForm, Colour, "Tiny")};
        ItemStack normalDust = ItemUtils.getSimpleStack(output[0]);
        ItemStack smallDust = ItemUtils.getSimpleStack(output[1]);
        ItemStack tinyDust = ItemUtils.getSimpleStack(output[2]);
        CORE.RA.addpackagerRecipe(ItemList.Schematic_Dust.get(0L, new Object[0]), smallDust, tinyDust, normalDust);
        if (ItemUtils.checkForInvalidItems(tinyDust) && ItemUtils.checkForInvalidItems(normalDust)) {
            if (RecipeUtils.addShapedRecipe(tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, tinyDust, normalDust)) {
                Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("9 Tiny dust to 1 Dust Recipe: " + materialName + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(normalDust, null, null, null, null, null, null, null, null, ItemUtils.getSimpleStack(tinyDust, 9))) {
                Logger.WARNING("9 Tiny dust from 1 Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("9 Tiny dust from 1 Recipe: " + materialName + " - Failed");
            }
        }
        if (ItemUtils.checkForInvalidItems(smallDust) && ItemUtils.checkForInvalidItems(normalDust)) {
            if (RecipeUtils.addShapedRecipe(smallDust, smallDust, null, smallDust, smallDust, null, null, null, null, normalDust)) {
                Logger.WARNING("4 Small dust to 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("4 Small dust to 1 Dust Recipe: " + materialName + " - Failed");
            }
            if (RecipeUtils.addShapedRecipe(null, normalDust, null, null, null, null, null, null, null, ItemUtils.getSimpleStack(smallDust, 4))) {
                Logger.WARNING("4 Small dust from 1 Dust Recipe: " + materialName + " - Success");
            } else {
                Logger.WARNING("4 Small dust from 1 Dust Recipe: " + materialName + " - Failed");
            }
        }
        return output;
    }

    public static Item[] generateSpecialUseDusts(Material material, boolean onlyLargeDust) {
        return ItemUtils.generateSpecialUseDusts(material, onlyLargeDust, false);
    }

    public static Item[] generateSpecialUseDusts(Material material, boolean onlyLargeDust, boolean disableExtraRecipes) {
        String materialName = material.getUnlocalizedName();
        String unlocalizedName = Utils.sanitizeString(materialName);
        int Colour = material.getRgbAsHex();
        String aChemForm = material.vChemicalFormula;
        boolean isChemFormvalid = aChemForm != null && aChemForm.length() > 0;
        Item[] output = null;
        output = !onlyLargeDust ? new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Dust"), new BaseItemDustUnique("itemDustSmall" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Small"), new BaseItemDustUnique("itemDustTiny" + unlocalizedName, materialName, isChemFormvalid ? aChemForm : "", Colour, "Tiny")} : new Item[]{new BaseItemDustUnique("itemDust" + unlocalizedName, materialName, Colour, "Dust")};
        new RecipeGen_DustGeneration(material, disableExtraRecipes);
        return output;
    }

    public static boolean isRadioactive(String materialName) {
        int sRadiation = 0;
        if (materialName.toLowerCase().contains("uranium")) {
            sRadiation = 2;
        } else if (materialName.toLowerCase().contains("plutonium")) {
            sRadiation = 4;
        } else if (materialName.toLowerCase().contains("thorium")) {
            sRadiation = 1;
        }
        return sRadiation >= 1;
    }

    public static int getRadioactivityLevel(String materialName) {
        int sRadiation = 0;
        if (materialName.toLowerCase().contains("uranium")) {
            sRadiation = 2;
        } else if (materialName.toLowerCase().contains("plutonium")) {
            sRadiation = 4;
        } else if (materialName.toLowerCase().contains("thorium")) {
            sRadiation = 1;
        }
        return sRadiation;
    }

    public static String getArrayStackNames(FluidStack[] aStack) {
        String itemNames = "Fluid Array: ";
        for (FluidStack alph : aStack) {
            String temp;
            if (alph != null) {
                temp = itemNames;
                itemNames = temp + ", " + alph.getLocalizedName() + " x" + alph.amount;
                continue;
            }
            temp = itemNames;
            itemNames = temp + ", null x0";
        }
        return itemNames;
    }

    public static String getArrayStackNames(ItemStack[] aStack) {
        String itemNames = "";
        int aPos = 0;
        for (ItemStack alph : aStack) {
            if (alph == null || alph == null) continue;
            String temp = itemNames;
            itemNames = temp + (aPos > 0 ? ", " : "") + alph.func_82833_r() + " x" + alph.field_77994_a;
            ++aPos;
        }
        return itemNames;
    }

    public static ItemStack getGregtechCircuit(int Meta) {
        return ItemUtils.getItemStackWithMeta(true, "gregtech:gt.integrated_circuit", "Gregtech Circuit", Meta, 0);
    }

    private static String getModId(Item item) {
        if (mModidCache.containsKey(item)) {
            return mModidCache.get(item);
        }
        String value = "";
        try {
            GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)item);
            if (id != null) {
                String modname = id.modId == null ? id.name : id.modId;
                value = id == null || id.modId.equals("") ? Mods.Minecraft.ID : modname;
            }
        }
        catch (Throwable t) {
            try {
                GameRegistry.UniqueIdentifier t2 = GameRegistry.findUniqueIdentifierFor((Block)Block.func_149634_a((Item)item));
                if (t2 != null) {
                    String modname = t2.modId == null ? t2.name : t2.modId;
                    value = t2 == null || t2.modId.equals("") ? Mods.Minecraft.ID : modname;
                }
            }
            catch (Throwable t3) {
                t3.printStackTrace();
                value = "bad modid";
            }
        }
        if (!mModidCache.containsKey(item)) {
            return mModidCache.put(item, value);
        }
        return value;
    }

    public static String getModId(ItemStack key) {
        return ItemUtils.getModId(key.func_77973_b());
    }

    public static ItemStack getGregtechDust(String oredictName, int amount) {
        ArrayList oreDictList = OreDictionary.getOres((String)oredictName);
        if (!oreDictList.isEmpty()) {
            for (ItemStack itemStack : oreDictList) {
                String modid = ItemUtils.getModId(itemStack.func_77973_b());
                if (modid == null || !modid.equals(Mods.GregTech.ID) && !modid.equals(Mods.GTPlusPlus.ID)) continue;
                ItemStack returnvalue = itemStack.func_77946_l();
                returnvalue.field_77994_a = amount;
                return returnvalue;
            }
        }
        return ItemUtils.getNonTinkersDust(oredictName, amount);
    }

    public static ItemStack getNonTinkersDust(String oredictName, int amount) {
        ArrayList oreDictList = OreDictionary.getOres((String)oredictName);
        if (!oreDictList.isEmpty()) {
            for (ItemStack itemStack : oreDictList) {
                String modid = ItemUtils.getModId(itemStack.func_77973_b());
                if (modid == null || modid.equals("tconstruct")) continue;
                ItemStack returnvalue = itemStack.func_77946_l();
                returnvalue.field_77994_a = amount;
                return returnvalue;
            }
        }
        return ItemUtils.getItemStackOfAmountFromOreDictNoBroken(oredictName, amount);
    }

    public static ItemStack getOrePrefixStack(OrePrefixes mPrefix, Material mMat, int mAmount) {
        String mName = Utils.sanitizeString(mMat.getLocalizedName());
        String mItemName = mPrefix.name() + mName;
        ItemStack gregstack = ItemUtils.getItemStackOfAmountFromOreDictNoBroken(mItemName, mAmount);
        if (gregstack == null) {
            return null;
        }
        return gregstack;
    }

    public static ItemStack getOrePrefixStack(OrePrefixes mPrefix, Materials mMat, int mAmount) {
        ItemStack aGtStack;
        if (mPrefix == OrePrefixes.rod) {
            mPrefix = OrePrefixes.stick;
        }
        if ((aGtStack = GT_OreDictUnificator.get((OrePrefixes)mPrefix, (Object)mMat, (long)mAmount)) == null) {
            Logger.INFO("Failed to find `" + mPrefix + MaterialUtils.getMaterialName(mMat) + "` in OD. [Prefix Search]");
            return ItemUtils.getErrorStack(mAmount, mPrefix.toString() + MaterialUtils.getMaterialName(mMat) + " x" + mAmount);
        }
        return aGtStack;
    }

    public static ItemStack getErrorStack(int mAmount) {
        return ItemUtils.getErrorStack(mAmount, null);
    }

    public static ItemStack getErrorStack(int mAmount, String aName) {
        ItemStack g = ItemUtils.getSimpleStack(ModItems.AAA_Broken, 1);
        if (aName != null) {
            NBTUtils.setBookTitle(g, EnumChatFormatting.RED + aName);
        }
        return g;
    }

    public static ItemStack[] getStackOfAllOreDictGroup(String oredictname) {
        ArrayList oreDictList = OreDictionary.getOres((String)oredictname);
        if (!oreDictList.isEmpty()) {
            ItemStack[] returnValues = new ItemStack[oreDictList.size()];
            for (int i = 0; i < oreDictList.size(); ++i) {
                if (oreDictList.get(i) == null) continue;
                returnValues[i] = (ItemStack)oreDictList.get(i);
            }
            return returnValues.length > 0 ? returnValues : null;
        }
        return null;
    }

    public static boolean registerFuel(ItemStack aBurnable, int burn) {
        return CORE.burnables.add(new Pair<Integer, ItemStack>(burn, aBurnable));
    }

    public static boolean checkForInvalidItems(ItemStack mInput) {
        return ItemUtils.checkForInvalidItems(new ItemStack[]{mInput});
    }

    public static boolean checkForInvalidItems(ItemStack[] mInput) {
        return ItemUtils.checkForInvalidItems(mInput, new ItemStack[0]);
    }

    public static boolean checkForInvalidItems(ItemStack[] mInputs, ItemStack[] mOutputs) {
        if (mInputs == null || mOutputs == null) {
            return false;
        }
        if (mInputs.length > 0) {
            for (ItemStack stack : mInputs) {
                if (stack != null) {
                    if (stack.func_77973_b() == null) continue;
                    if (stack.func_77973_b() == ModItems.AAA_Broken || stack.func_77973_b().getClass() == ModItems.AAA_Broken.getClass()) {
                        return false;
                    }
                    if (stack.func_77973_b() != ModItems.ZZZ_Empty && stack.func_77973_b().getClass() != ModItems.ZZZ_Empty.getClass()) continue;
                    return false;
                }
                return false;
            }
        }
        if (mOutputs.length > 0) {
            for (ItemStack stack : mOutputs) {
                if (stack != null) {
                    if (stack.func_77973_b() == null) continue;
                    if (stack.func_77973_b() == ModItems.AAA_Broken || stack.func_77973_b().getClass() == ModItems.AAA_Broken.getClass()) {
                        return false;
                    }
                    if (stack.func_77973_b() != ModItems.ZZZ_Empty && stack.func_77973_b().getClass() != ModItems.ZZZ_Empty.getClass()) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static IInventory organiseInventory(IInventory aInputInventory) {
        ItemStack[] p = new ItemStack[aInputInventory.func_70302_i_()];
        for (int o = 0; o < aInputInventory.func_70302_i_(); ++o) {
            p[o] = aInputInventory.func_70301_a(o);
        }
        IInventory aTemp = aInputInventory;
        for (int i = 0; i < p.length; ++i) {
            for (int j = i + 1; j < p.length; ++j) {
                if (p[j] == null || p[i] != null && !GT_Utility.areStacksEqual((ItemStack)p[i], (ItemStack)p[j])) continue;
                GT_Utility.moveStackFromSlotAToSlotB((IInventory)aTemp, (IInventory)aTemp, (int)j, (int)i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
        return aTemp;
    }

    public static String getFluidName(FluidStack aFluid) {
        return aFluid != null ? aFluid.getFluid().getLocalizedName(aFluid) : "NULL";
    }

    public static String getItemName(ItemStack aStack) {
        if (aStack == null) {
            return "ERROR - Empty Stack";
        }
        String aDisplay = null;
        try {
            NBTTagCompound nbttagcompound;
            aDisplay = ("" + StatCollector.func_74838_a((String)(aStack.func_77973_b().func_77657_g(aStack) + ".name"))).trim();
            if (aStack.func_77942_o() && aStack.field_77990_d != null && aStack.field_77990_d.func_150297_b("display", 10) && (nbttagcompound = aStack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
                aDisplay = nbttagcompound.func_74779_i("Name");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        aDisplay = aDisplay == null || aDisplay.length() <= 0 ? aStack.func_77977_a() + ":" + aStack.func_77960_j() : aDisplay + " | Meta: " + aStack.func_77960_j();
        return aDisplay;
    }

    public static String getUnlocalizedItemName(ItemStack aStack) {
        if (aStack == null) {
            return "ERROR.Empty.Stack";
        }
        String aDisplay = null;
        try {
            aDisplay = aStack.func_77977_a().trim();
        }
        catch (Throwable t) {
            aDisplay = aStack.func_77973_b().func_77658_a();
        }
        if (aDisplay == null || aDisplay.length() <= 0) {
            aDisplay = aStack.func_77973_b().func_77657_g(aStack);
        }
        return aDisplay;
    }

    public static boolean isItemGregtechTool(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        Item mItem = aStack.func_77973_b();
        Item aSkookum = ItemUtils.getItemFromFQRN("miscutils:gt.plusplus.metatool.01");
        Class<?> aSkookClass = aSkookum.getClass();
        return aSkookClass.isInstance(mItem) || mItem instanceof GT_MetaGenerated_Tool_01 || mItem instanceof MetaGeneratedGregtechTools || mItem instanceof Gregtech_MetaTool || mItem == aSkookum;
    }

    public static boolean isToolScrewdriver(ItemStack aScrewdriver) {
        return ItemUtils.isItemGregtechTool(aScrewdriver) && (aScrewdriver.func_77960_j() == 22 || aScrewdriver.func_77960_j() == 150);
    }

    public static ItemStack[] cleanItemStackArray(ItemStack[] input) {
        int aArraySize = input.length;
        ItemStack[] aOutput = new ItemStack[aArraySize];
        AutoMap<ItemStack> aCleanedItems = new AutoMap<ItemStack>();
        for (ItemStack checkStack : input) {
            if (!ItemUtils.checkForInvalidItems(checkStack)) continue;
            aCleanedItems.put(checkStack);
        }
        for (int i = 0; i < aArraySize; ++i) {
            ItemStack aMappedStack = (ItemStack)aCleanedItems.get(i);
            if (aMappedStack == null) continue;
            aOutput[i] = aMappedStack;
        }
        return aOutput;
    }

    public static boolean doesOreDictHaveEntryFor(String string) {
        return OreDictUtils.containsValidEntries(string);
    }

    public static void hideItemFromNEI(ItemStack aItemToHide) {
        API.hideItem((ItemStack)aItemToHide);
    }

    public static ItemStack getNullStack() {
        return GT_Values.NI;
    }

    public static ItemStack depleteStack(ItemStack aStack) {
        return ItemUtils.depleteStack(aStack, 1);
    }

    public static ItemStack depleteStack(ItemStack aStack, int aAmount) {
        int cap = aStack.field_77994_a;
        if (cap >= 1 && cap >= aAmount) {
            ItemStack aDepStack = aStack.func_77946_l();
            aDepStack.field_77994_a = MathUtils.balance(aDepStack.field_77994_a - 1, 0, 64);
            if (aDepStack.field_77994_a > 0) {
                return aDepStack;
            }
        }
        return ItemUtils.getNullStack();
    }

    public static boolean isControlCircuit(ItemStack aStack) {
        Item aItem;
        return aStack != null && ((aItem = aStack.func_77973_b()) == CI.getNumberedBioCircuit(0).func_77973_b() || aItem == CI.getNumberedCircuit(0).func_77973_b() || aItem == CI.getNumberedAdvancedCircuit(0).func_77973_b());
    }

    public static boolean isCatalyst(ItemStack aStack) {
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mBlueCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mBrownCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mOrangeCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mPurpleCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mRedCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mYellowCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mPinkCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mFormaldehydeCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mSolidAcidCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mInfiniteMutationCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)AgriculturalChem.mGreenCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mPlatinumGroupCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mPlasticPolymerCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mRubberPolymerCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mAdhesionPromoterCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mTitaTungstenIndiumCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mRadioactivityCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mRareEarthGroupCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mSimpleNaquadahCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mAdvancedNaquadahCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mRawIntelligenceCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mUltimatePlasticCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mBiologicalIntelligenceCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.TemporalHarmonyCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mLimpidWaterCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mFlawlessWaterCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mParticleAccelerationCatalyst, (boolean)true)) {
            return true;
        }
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mSynchrotronCapableCatalyst, (boolean)true)) {
            return true;
        }
        return GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mAlgagenicGrowthPromoterCatalyst, (boolean)true);
    }

    public static boolean isMillingBall(ItemStack aStack) {
        if (GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mMillingBallAlumina, (boolean)true)) {
            return true;
        }
        return GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)GenericChem.mMillingBallSoapstone, (boolean)true);
    }
}

