/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.tool.staballoy;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.MiningUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class StaballoySpade
extends ItemSpade {
    private int miningLevel;

    public double getDurabilityForDisplay(ItemStack stack) {
        if (super.getDurabilityForDisplay(stack) > 0.0) {
            return super.getDurabilityForDisplay(stack);
        }
        return 0.0;
    }

    private static boolean createNBT(ItemStack rStack) {
        NBTTagCompound tagMain = new NBTTagCompound();
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.func_74757_a("FACING_HORIZONTAL", true);
        tagNBT.func_74778_a("FACING", "north");
        tagNBT.func_74778_a("lookingDirection", "");
        tagMain.func_74782_a("PickStats", (NBTBase)tagNBT);
        rStack.func_77982_d(tagMain);
        return true;
    }

    public static final boolean isFacingHorizontal(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("PickStats")) != null) {
                return aNBT.func_74767_n("FACING_HORIZONTAL");
            }
        } else {
            StaballoySpade.createNBT(aStack);
        }
        return true;
    }

    public static final boolean setFacingHorizontal(ItemStack aStack, boolean aFacingHorizontal) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("PickStats")) != null) {
            aNBT.func_74757_a("FACING_HORIZONTAL", aFacingHorizontal);
            return true;
        }
        return false;
    }

    public static final String getFacingDirection(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("PickStats")) != null) {
                return aNBT.func_74779_i("FACING");
            }
        } else {
            StaballoySpade.createNBT(aStack);
        }
        return "north";
    }

    public static final boolean setFacingDirection(ItemStack aStack, String aFacingHorizontal) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("PickStats")) != null) {
            aNBT.func_74778_a("FACING", aFacingHorizontal);
            return true;
        }
        return false;
    }

    public static final String getLookingDirection(ItemStack aStack) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null) {
            if ((aNBT = aNBT.func_74775_l("PickStats")) != null) {
                return aNBT.func_74779_i("lookingDirection");
            }
        } else {
            StaballoySpade.createNBT(aStack);
        }
        return "";
    }

    public static final boolean setLookingDirection(ItemStack aStack, String aFacingHorizontal) {
        NBTTagCompound aNBT = aStack.func_77978_p();
        if (aNBT != null && (aNBT = aNBT.func_74775_l("PickStats")) != null) {
            aNBT.func_74778_a("lookingDirection", aFacingHorizontal);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer aPlayer) {
        return super.func_77659_a(stack, world, aPlayer);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int X, int Y, int Z, EntityLivingBase entity) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.GetDestroyOrientation((EntityPlayer)entity, StaballoySpade.getLookingDirection(stack), world, X, Y, Z, stack);
        }
        return super.func_150894_a(stack, world, block, X, Y, Z, entity);
    }

    public Boolean canPickaxeBlock(Block currentBlock, World currentWorld, int[] xyz) {
        String correctTool = "";
        if (!currentWorld.field_72995_K) {
            try {
                correctTool = currentBlock.getHarvestTool(0);
                Logger.WARNING("Tool for Block: " + correctTool + " | Current block: " + currentBlock.func_149732_F());
                if (MiningUtils.getBlockType(currentBlock, currentWorld, xyz, this.miningLevel) || correctTool.equals("shovel")) {
                    return true;
                }
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return false;
    }

    private void GetDestroyOrientation(EntityPlayer player, String FACING, World world, int X, int Y, int Z, ItemStack heldItem) {
        float DURABILITY_LOSS = 0.0f;
        if (!world.field_72995_K) {
            switch (FACING) {
                case "below": 
                case "above": {
                    int j;
                    int i;
                    DURABILITY_LOSS = 0.0f;
                    for (i = -1; i < 2; ++i) {
                        for (j = -1; j < 2; ++j) {
                            DURABILITY_LOSS += (float)this.removeBlockAndDropAsItem(world, X + i, Y, Z + j, heldItem);
                        }
                    }
                    break;
                }
                case "facingEast": 
                case "facingWest": {
                    int j;
                    int i;
                    DURABILITY_LOSS = 0.0f;
                    for (i = -1; i < 2; ++i) {
                        for (j = -1; j < 2; ++j) {
                            DURABILITY_LOSS += (float)this.removeBlockAndDropAsItem(world, X, Y + i, Z + j, heldItem);
                        }
                    }
                    break;
                }
                case "facingNorth": 
                case "facingSouth": {
                    int j;
                    int i;
                    DURABILITY_LOSS = 0.0f;
                    for (i = -1; i < 2; ++i) {
                        for (j = -1; j < 2; ++j) {
                            DURABILITY_LOSS += (float)this.removeBlockAndDropAsItem(world, X + j, Y + i, Z, heldItem);
                        }
                    }
                    break;
                }
            }
            Logger.WARNING("Total Loss: " + (int)DURABILITY_LOSS);
            Logger.WARNING("1x: " + heldItem.func_77960_j());
            int itemdmg = heldItem.func_77960_j();
            int maxdmg = heldItem.func_77958_k();
            int dodmg = (int)DURABILITY_LOSS;
            int durNow = maxdmg - itemdmg;
            int durLeft = (int)((float)(maxdmg - itemdmg) - DURABILITY_LOSS);
            Logger.WARNING("Current Damage: " + itemdmg + " Max Damage: " + maxdmg + " Durability to be lost: " + dodmg + " Current Durability: " + durNow + " Remaining Durability: " + durLeft);
            if (durNow - dodmg <= 900 && itemdmg != 0) {
                Logger.WARNING("Breaking Tool");
                heldItem.field_77994_a = 0;
            } else {
                Logger.WARNING("" + (durNow - durLeft));
                this.damageItem(heldItem, durNow - durLeft - 1, player);
            }
            DURABILITY_LOSS = 0.0f;
        }
    }

    public void damageItem(ItemStack item, int damage, EntityPlayer localPlayer) {
        item.func_77972_a(damage, (EntityLivingBase)localPlayer);
    }

    public void setItemDamage(ItemStack item, int damage) {
        item.func_77964_b(damage - 1);
    }

    public int removeBlockAndDropAsItem(World world, int X, int Y, int Z, ItemStack heldItem) {
        Logger.WARNING("Trying to drop/remove a block.");
        try {
            Block block = world.func_147439_a(X, Y, Z);
            Logger.WARNING(block.toString());
            String removalTool = "";
            removalTool = block.getHarvestTool(0);
            if (removalTool != null) {
                if (removalTool.equals("shovel")) {
                    if (this.canPickaxeBlock(block, world, new int[]{X, Y, Z}).booleanValue()) {
                        if (block != Blocks.field_150357_h && block.func_149712_f(world, X, Y, Z) != -1.0f && block.func_149712_f(world, X, Y, Z) <= 100.0f && block != Blocks.field_150355_j && block != Blocks.field_150353_l) {
                            int itemdmg = heldItem.func_77960_j();
                            int maxdmg = heldItem.func_77958_k();
                            int dodmg = 100;
                            int durNow = maxdmg - itemdmg;
                            int durLeft = maxdmg - itemdmg - 100;
                            if (durNow - 100 <= 900 && itemdmg != 0) {
                                return 0;
                            }
                            block.func_149697_b(world, X, Y, Z, world.func_72805_g(X, Y, Z), 0);
                            world.func_147468_f(X, Y, Z);
                            Logger.WARNING("Adding 100 damage to item.");
                            return 100;
                        }
                        Logger.WARNING("Incorrect Tool for mining this block. Wrong Block Water/lava/bedrock/blacklist");
                        return 0;
                    }
                    Logger.WARNING("Incorrect Tool for mining this block. Cannot Shovel this block type.");
                    return 0;
                }
                Logger.WARNING("Incorrect Tool for mining this block. Blocks mining tool is now Shovel.");
                return 0;
            }
            Logger.WARNING("Either the block was air or it declares an invalid mining tool.");
            return 0;
        }
        catch (NullPointerException e) {
            Logger.WARNING("Something Broke");
            e.printStackTrace();
            return 0;
        }
    }

    public boolean checkFacing(ItemStack aStack, EntityPlayer aPlayer, World world) {
        if (aPlayer != null) {
            int direction = MathHelper.func_76128_c((double)((double)(aPlayer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            MovingObjectPosition movingobjectposition = this.func_77621_a(world, aPlayer, false);
            if (movingobjectposition != null) {
                int sideHit = movingobjectposition.field_72310_e;
                String playerStandingPosition = "";
                if (movingobjectposition != null) {
                    // empty if block
                }
                if (sideHit == 0) {
                    playerStandingPosition = "above";
                    StaballoySpade.setFacingHorizontal(aStack, false);
                } else if (sideHit == 1) {
                    playerStandingPosition = "below";
                    StaballoySpade.setFacingHorizontal(aStack, false);
                } else if (sideHit == 2) {
                    playerStandingPosition = "facingSouth";
                    StaballoySpade.setFacingHorizontal(aStack, true);
                } else if (sideHit == 3) {
                    playerStandingPosition = "facingNorth";
                    StaballoySpade.setFacingHorizontal(aStack, true);
                } else if (sideHit == 4) {
                    playerStandingPosition = "facingEast";
                    StaballoySpade.setFacingHorizontal(aStack, true);
                } else if (sideHit == 5) {
                    playerStandingPosition = "facingWest";
                    StaballoySpade.setFacingHorizontal(aStack, true);
                }
                StaballoySpade.setLookingDirection(aStack, playerStandingPosition);
                if (direction == 0) {
                    StaballoySpade.setFacingDirection(aStack, "south");
                } else if (direction == 1) {
                    StaballoySpade.setFacingDirection(aStack, "west");
                } else if (direction == 2) {
                    StaballoySpade.setFacingDirection(aStack, "north");
                } else if (direction == 3) {
                    StaballoySpade.setFacingDirection(aStack, "east");
                }
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add(EnumChatFormatting.GOLD + "Spades a 3x3 area in the direction you are facing.");
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.rare;
    }

    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer aPlayer) {
        this.checkFacing(itemstack, aPlayer, aPlayer.field_70170_p);
        return super.onBlockStartBreak(itemstack, X, Y, Z, aPlayer);
    }

    public StaballoySpade(String unlocalizedName, Item.ToolMaterial material) {
        super(material);
        this.func_77655_b(unlocalizedName);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":" + unlocalizedName);
        this.func_77625_d(1);
        this.func_77656_e(3200);
    }
}

