/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Mods;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.bauble.BaseBauble;
import gtPlusPlus.core.util.math.MathUtils;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles"), @Optional.Interface(iface="baubles.api.BaubleType", modid="Baubles")})
public abstract class ElectricBaseBauble
extends BaseBauble
implements IElectricItem,
IElectricItemManager,
IBauble {
    public final int mTier;
    private final double maxValueEU;
    private final BaubleType mType;

    public ElectricBaseBauble(BaubleType aType, int aTier, double aMaxEU, String aUnlocalName) {
        super(aType, aUnlocalName, 0);
        this.mType = aType;
        this.mTier = aTier;
        this.maxValueEU = aMaxEU;
        this.func_77655_b(aUnlocalName);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":" + this.getTextureNameForBauble());
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(AddToCreativeTab.tabMachines);
        if (GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)aUnlocalName) == null) {
            GameRegistry.registerItem((Item)this, (String)aUnlocalName);
        }
    }

    public abstract String getTextureNameForBauble();

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack charged;
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getEmptyItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 0.0, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getChargedItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
    }

    public void func_77663_a(ItemStack itemStack, World worldObj, Entity player, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(itemStack, worldObj, player, p_77663_4_, p_77663_5_);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        double aItemCharge = ElectricItem.manager.getCharge(itemStack);
        return aItemCharge > 0.0;
    }

    public final Item getChargedItem(ItemStack itemStack) {
        ItemStack x = itemStack.func_77946_l();
        x.func_77964_b(27);
        return x.func_77973_b();
    }

    public final Item getEmptyItem(ItemStack itemStack) {
        ItemStack x = itemStack.func_77946_l();
        x.func_77964_b(0);
        return x.func_77973_b();
    }

    public final double getMaxCharge(ItemStack itemStack) {
        return this.maxValueEU;
    }

    public final int getTier(ItemStack itemStack) {
        return this.mTier;
    }

    public final double getTransferLimit(ItemStack itemStack) {
        return GT_Values.V[this.mTier];
    }

    public final double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add("");
        String aEuInfo = StatCollector.func_74838_a((String)"GTPP.info.euInfo");
        String aTier = StatCollector.func_74838_a((String)"GTPP.machines.tier");
        String aInputLimit = StatCollector.func_74838_a((String)"GTPP.info.inputLimit");
        String aCurrentPower = StatCollector.func_74838_a((String)"GTPP.info.currentPower");
        String aEU = StatCollector.func_74838_a((String)"GTPP.info.eu");
        String aEUT = aEU + "/t";
        list.add(EnumChatFormatting.GOLD + aEuInfo + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GRAY + aTier + ": [" + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)this.getTier(stack)) + EnumChatFormatting.GRAY + "] " + aInputLimit + ": [" + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((double)this.getTransferLimit(stack)) + EnumChatFormatting.GRAY + aEUT + "]");
        list.add(EnumChatFormatting.GRAY + aCurrentPower + ": [" + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((double)this.getCharge(stack)) + EnumChatFormatting.GRAY + aEU + "] [" + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((double)MathUtils.findPercentage(this.getCharge(stack), this.getMaxCharge(stack))) + EnumChatFormatting.GRAY + "%]");
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public final double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return ElectricItem.manager.charge(stack, amount, tier, true, simulate);
    }

    public final double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        return ElectricItem.manager.discharge(stack, amount, tier, ignoreTransferLimit, externally, simulate);
    }

    public final double getCharge(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack);
    }

    public final boolean canUse(ItemStack stack, double amount) {
        return ElectricItem.manager.canUse(stack, amount);
    }

    public final boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return ElectricItem.manager.use(stack, amount, entity);
    }

    public final void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        ElectricItem.manager.chargeFromArmor(stack, entity);
    }

    public String getToolTip(ItemStack stack) {
        return null;
    }

    @Override
    public final BaubleType getBaubleType(ItemStack arg0) {
        return this.mType;
    }
}

