/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import cpw.mods.fml.relauncher.Side;
import net.glease.tc4tweak.asm.TC4Transformer;
import net.glease.tc4tweak.asm.TransformerFactory;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class NodeLikeRendererVisitor
extends ClassVisitor {
    private final String target;

    public NodeLikeRendererVisitor(int api, ClassVisitor cv, String target) {
        super(api, cv);
        this.target = target;
    }

    public static TransformerFactory createFactory(String target) {
        return new TransformerFactory((api, cv) -> new NodeLikeRendererVisitor((int)api, (ClassVisitor)cv, target), Side.CLIENT);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals(this.target)) {
            TC4Transformer.log.debug("Visiting {}", new Object[]{this.target});
            return new RenderNodeVisitor(this.api, mv);
        }
        return mv;
    }

    private static class RenderNodeVisitor
    extends MethodVisitor {
        public RenderNodeVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (owner.equals("thaumcraft/client/lib/UtilsFX") && name.equals("renderFacingStrip")) {
                TC4Transformer.log.trace("Replacing renderFacingStrip");
                super.visitMethodInsn(opcode, "net/glease/tc4tweak/asm/ASMCallhook", name, desc, false);
            } else {
                super.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }
    }
}

