/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import net.glease.tc4tweak.ConfigurationHandler;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.research.ResearchCategories;

public class CommonUtils {
    private static final LinkedHashSet<String> originalTabOrders = new LinkedHashSet();

    public static String toString(AspectList al) {
        return al.aspects.entrySet().stream().filter(e -> e.getKey() != null && e.getValue() != null).map(e -> String.format("%dx%s", e.getValue(), ((Aspect)e.getKey()).getName())).collect(Collectors.joining(";"));
    }

    public static String toString(CrucibleRecipe r) {
        return "CrucibleRecipe{key=" + r.key + ",catalyst=" + r.catalyst + ",output=" + r.getRecipeOutput() + ",aspects=" + CommonUtils.toString(r.aspects) + "}";
    }

    static void sortResearchCategories(boolean force) {
        if (force || !ConfigurationHandler.INSTANCE.getCategoryOrder().isEmpty()) {
            LinkedHashMap categories = ResearchCategories.researchCategories;
            originalTabOrders.addAll(categories.keySet());
            LinkedHashSet<String> realOrder = new LinkedHashSet<String>(ConfigurationHandler.INSTANCE.getCategoryOrder());
            realOrder.addAll(originalTabOrders);
            LinkedHashMap newCategories = new LinkedHashMap();
            for (String tab : realOrder) {
                if (!categories.containsKey(tab)) continue;
                newCategories.put(tab, categories.get(tab));
            }
            ResearchCategories.researchCategories = newCategories;
        }
    }

    public static <T> T reflectGet(Field f, Object instance) {
        try {
            return (T)f.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName, int index) {
        try {
            Field f = null;
            Field[] fields = clazz.getDeclaredFields();
            if (index >= 0 && fields.length > index) {
                f = fields[index];
            }
            if (f == null || !f.getName().equalsIgnoreCase(fieldName)) {
                f = clazz.getDeclaredField(fieldName);
            }
            f.setAccessible(true);
            return f;
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

