/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.gregtechCrops;

import com.github.bartimaeusnek.cropspp.CCropUtility;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicDecorationCrop;
import gregtech.api.enums.Materials;
import ic2.api.crops.ICropTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class StonelillyCrop
extends BasicDecorationCrop {
    private final String color;

    public StonelillyCrop(String color) {
        this.color = color;
    }

    @Override
    public ItemStack getDisplayItem() {
        switch (this.color) {
            case "Red": {
                return Materials.GraniteRed.getDust(9);
            }
            case "Black": {
                return Materials.GraniteBlack.getDust(9);
            }
            case "White": {
                return Materials.Marble.getDust(9);
            }
            case "Gray": {
                return Materials.Stone.getDust(9);
            }
            case "Yellow": {
                return Materials.Endstone.getDust(2);
            }
            case "Nether": {
                return Materials.Netherrack.getDust(9);
            }
        }
        return new ItemStack(Blocks.field_150347_e);
    }

    public String name() {
        return this.color + " Stonelilly";
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        if (this.color.equals("Yellow") && crop.getSize() >= this.maxSize() - 1 && crop.isBlockBelow(Blocks.field_150377_bs)) {
            return 550;
        }
        return 300;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        if (!super.canGrow(crop)) {
            return false;
        }
        if (ConfigValues.debug) {
            return true;
        }
        if (crop.getSize() < this.maxSize() - 1) {
            return true;
        }
        switch (this.color) {
            case "Red": {
                return crop.isBlockBelow("stoneGraniteRed") || crop.isBlockBelow("blockGranite");
            }
            case "Black": {
                return crop.isBlockBelow("stoneGraniteBlack") || crop.isBlockBelow("stoneBasalt");
            }
            case "White": {
                return crop.isBlockBelow("blockMarble") || crop.isBlockBelow("blockDiorite");
            }
            case "Gray": {
                return crop.isBlockBelow(Blocks.field_150347_e) || crop.isBlockBelow(Blocks.field_150348_b) || crop.isBlockBelow("blockAndesite");
            }
            case "Yellow": {
                return crop.isBlockBelow(Blocks.field_150377_bs) || crop.isBlockBelow((Block)Blocks.field_150354_m) || crop.isBlockBelow(Blocks.field_150322_A);
            }
            case "Nether": {
                return crop.isBlockBelow(Blocks.field_150424_aL) || crop.isBlockBelow(Blocks.field_150385_bj);
            }
        }
        return false;
    }

    @Override
    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity / 0.8 + (double)nutrients / 1.4 + (double)air / 0.8);
    }

    public String[] attributes() {
        switch (this.color) {
            case "Red": {
                return new String[]{this.color, "Stone", "Fire"};
            }
            case "Black": {
                return new String[]{this.color, "Stone", "Dark"};
            }
            case "White": {
                return new String[]{this.color, "Stone", "Shiny"};
            }
            case "Gray": {
                return new String[]{this.color, "Stone", "Metal"};
            }
            case "Yellow": {
                return new String[]{this.color, "Stone", "Alien"};
            }
            case "Nether": {
                return new String[]{this.color, "Stone", "Evil"};
            }
        }
        return new String[]{this.color, "Stone"};
    }

    @Override
    public List<String> getCropInformation() {
        ArrayList<String> information = new ArrayList<String>();
        switch (this.color) {
            case "Red": {
                information.add("Needs a Block of Red Granite or Granite(Non-GT) below to fully Mature");
                break;
            }
            case "Black": {
                information.add("Needs a Block of Black Granite or Basalt below to fully Mature");
                break;
            }
            case "White": {
                information.add("Needs a Block of Marble or Diorite below to fully Mature");
                break;
            }
            case "Gray": {
                information.add("Needs a Block of Cobblestone, Stone or Andesite below to fully Mature");
                break;
            }
            case "Yellow": {
                information.add("Needs a Block of Endstone, Sand or Sandstone below to fully Mature");
                break;
            }
            case "Nether": {
                information.add("Needs a Block of Netherrack or Netherbrick below to fully Mature");
            }
        }
        information.add("Has increased Nutrient requirements (x1.4)");
        information.add("Has decreased humidity and air requirements (x0.8)");
        return information;
    }

    public ItemStack getGain(ICropTile crop) {
        switch (this.color) {
            case "Red": {
                if (crop.isBlockBelow("stoneGraniteRed")) {
                    return Materials.GraniteRed.getDust(9);
                }
                if (!crop.isBlockBelow("blockGranite")) break;
                return CCropUtility.getCopiedOreStack("blockGranite");
            }
            case "Black": {
                if (crop.isBlockBelow("stoneGraniteBlack")) {
                    return Materials.GraniteBlack.getDust(9);
                }
                if (!crop.isBlockBelow("stoneBasalt")) break;
                return Materials.Basalt.getDust(9);
            }
            case "White": {
                if (crop.isBlockBelow("blockMarble")) {
                    return Materials.Marble.getDust(9);
                }
                if (!crop.isBlockBelow("blockDiorite")) break;
                return CCropUtility.getCopiedOreStack("blockDiorite");
            }
            case "Gray": {
                if (crop.isBlockBelow(Blocks.field_150347_e) || crop.isBlockBelow(Blocks.field_150348_b)) {
                    return Materials.Stone.getDust(9);
                }
                if (!crop.isBlockBelow("blockAndesite")) break;
                return CCropUtility.getCopiedOreStack("blockAndesite");
            }
            case "Yellow": {
                if (crop.isBlockBelow(Blocks.field_150377_bs)) {
                    return Materials.Endstone.getDust(2);
                }
                if (!crop.isBlockBelow((Block)Blocks.field_150354_m) && !crop.isBlockBelow(Blocks.field_150322_A)) break;
                return new ItemStack((Block)Blocks.field_150354_m, 4);
            }
            case "Nether": {
                if (!crop.isBlockBelow(Blocks.field_150424_aL) && !crop.isBlockBelow(Blocks.field_150385_bj)) break;
                return Materials.Netherrack.getDust(9);
            }
        }
        return null;
    }
}

