/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.common.gui.controls.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.GuiLabelClickable;
import com.creativemd.creativecore.common.gui.controls.GuiScrollBox;
import com.creativemd.creativecore.common.gui.event.ControlClickEvent;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;

public class GuiListBox
extends GuiScrollBox {
    protected ArrayList<String> lines = new ArrayList();
    public int selected = -1;

    public GuiListBox(String name, EntityPlayer player, int x, int y, int width, int height, ArrayList<String> lines) {
        super(name, player, x, y, width, height);
        this.lines = lines;
        this.refreshControls();
    }

    @Override
    public void init() {
        this.parent.addListener(this);
    }

    public void clear() {
        this.lines.clear();
        this.selected = -1;
        this.maxScroll = 0;
        this.scrolled = 0;
        this.refreshControls();
    }

    public int size() {
        return this.lines.size();
    }

    public String get(int id) {
        return this.lines.get(id);
    }

    public void add(String input) {
        this.lines.add(input);
        this.refreshControls();
    }

    public void remove(int id) {
        this.lines.remove(id);
        this.refreshControls();
    }

    public void refreshControls() {
        this.gui.controls.clear();
        for (int i = 0; i < this.lines.size(); ++i) {
            int color = 0xE0E0E0;
            if (i == this.selected) {
                color = 0xFFFF28;
            }
            GuiLabelClickable label = new GuiLabelClickable(this.lines.get(i), 3, 1 + i * 15, color);
            label.width = this.width - 20;
            label.height = 15;
            this.addControl(label);
        }
    }

    @CustomEventSubscribe
    public void onLabelClicked(ControlClickEvent event) {
        int index;
        if (event.source instanceof GuiLabel && (index = this.gui.controls.indexOf(event.source)) != -1) {
            if (this.selected != -1 && this.selected < this.gui.controls.size()) {
                ((GuiLabel)this.gui.controls.get((int)this.selected)).color = 0xE0E0E0;
            }
            this.selected = index;
            ((GuiLabel)this.gui.controls.get((int)this.selected)).color = 0xFFFF28;
            this.onSelectionChange();
        }
    }

    public void onSelectionChange() {
    }
}

