/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.beebetteratbees.client.util;

public class SimpleBinaryTree<E> {
    private Node<E> root;
    private RootProvider<E> rootProvider;

    public SimpleBinaryTree(int maxDepth, E rootValue, RootProvider<E> provider) {
        this.rootProvider = provider;
        this.root = this.buildSubTree(rootValue, maxDepth);
    }

    public SimpleBinaryTree(E rootValue, RootProvider<E> provider) {
        this(Integer.MAX_VALUE, rootValue, provider);
    }

    public Node<E> getRoot() {
        return this.root;
    }

    private Node<E> buildSubTree(E superNodeValue, int maxFollowingDepth) {
        E[] subNodes = this.rootProvider.provideSubNodes(superNodeValue);
        if (subNodes == null || subNodes.length == 0 || maxFollowingDepth <= 0) {
            return new Leaf(superNodeValue);
        }
        Node<E> left = this.buildSubTree(subNodes[0], maxFollowingDepth - 1);
        Node<E> right = this.buildSubTree(subNodes[1], maxFollowingDepth - 1);
        int depth = Math.max(left.getMaxFollowingDepth(), right.getMaxFollowingDepth());
        return new Node(superNodeValue, left, right, depth + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleBinaryTree that = (SimpleBinaryTree)o;
        return !(this.root == null ? that.root != null : !this.root.equals(that.root));
    }

    public int hashCode() {
        return this.root != null ? this.root.hashCode() : 0;
    }

    public static abstract class RootProvider<E> {
        public abstract E[] provideSubNodes(E var1);
    }

    public static class Node<E> {
        protected final E value;
        private int maxFollowingDepth;
        private Node<E> left;
        private Node<E> right;

        private Node(E value, Node<E> left, Node<E> right, int depth) {
            this.value = value;
            this.left = left;
            this.right = right;
            this.maxFollowingDepth = depth;
        }

        public int getMaxFollowingDepth() {
            return this.maxFollowingDepth;
        }

        public E getValue() {
            return this.value;
        }

        public Node<E> getLeftNode() {
            return this.left;
        }

        public Node<E> getRightNode() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return !(this.value == null ? node.value != null : !this.value.equals(node.value));
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "[" + this.left.toString() + "], " + this.value.toString() + ", [" + this.right.toString() + "]";
        }

        public void removeDuplicate() {
            this.left = null;
            this.right = null;
            this.maxFollowingDepth = 1;
        }
    }

    private static class Leaf<E>
    extends Node<E> {
        private Leaf(E value) {
            super(value, null, null, 0);
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

