/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.handlers;

import ic2.api.crops.CropCard;
import ic2.api.item.IC2Items;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import speiger.src.crops.IC2NeiPlugin;
import speiger.src.crops.api.ICropInfo;

public class ClassicInfoLoader
implements ICropInfo {
    public Map<String, ItemStack> data;

    @Override
    public List<CropCard> getSupportedCrops() {
        return IC2NeiPlugin.ALL_CROPS;
    }

    @Override
    public List<String> getCropInformation(CropCard card) {
        ArrayList<String> result = new ArrayList<String>();
        String name = card.name();
        if (name.equalsIgnoreCase("Wheat") || name.equalsIgnoreCase("Coffee") || name.equalsIgnoreCase("Hops")) {
            result.addAll(this.translateToLocalFormatted("info.requiresLight.name", "+9"));
        } else if (name.equalsIgnoreCase("Potato") || name.equalsIgnoreCase("Carrots") || name.equalsIgnoreCase("Dandelion") || name.equalsIgnoreCase("Rose") || name.equalsIgnoreCase("Blackthorn") || name.equalsIgnoreCase("Tulip") || name.equalsIgnoreCase("Cyazint") || name.equalsIgnoreCase("Venomilia")) {
            result.addAll(this.translateToLocalFormatted("info.requiresLight.name", "+12"));
        } else if (name.equalsIgnoreCase("Cocoa")) {
            result.addAll(this.translateToLocalFormatted("info.requiresNutrient.name", "+3"));
        } else if (name.equalsIgnoreCase("Ferru")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlock.name", new ItemStack(Blocks.field_150366_p).func_82833_r()));
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlockExtension.name", new ItemStack(Blocks.field_150339_S).func_82833_r()));
        } else if (name.equalsIgnoreCase("Aurelia")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlock.name", new ItemStack(Blocks.field_150352_o).func_82833_r()));
            result.addAll(this.translateToLocalFormatted("info.requiresSoilBlockExtension.name", new ItemStack(Blocks.field_150340_R).func_82833_r()));
        } else if (name.equalsIgnoreCase("Redwheat")) {
            result.addAll(this.translateToLocalFormatted("info.requiresSpecialLight.name", "5", "10"));
        } else if (name.equalsIgnoreCase("Red Mushroom") || name.equalsIgnoreCase("RedMushroom") || name.equalsIgnoreCase("Brown Mushroom") || name.equalsIgnoreCase("BrownMushroom")) {
            result.addAll(this.translateToLocalFormatted("info.requiresHydration.name", "1"));
        } else if (name.equalsIgnoreCase("Cacti")) {
            result.addAll(this.translateToLocalFormatted("classicInfo.requiresAir.name", "4"));
        } else if (name.equalsIgnoreCase("Tea")) {
            result.addAll(this.translateToLocalFormatted("info.requiresLight.name", "+7"));
        }
        return result;
    }

    public List<String> translateToLocal(String par1) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(StatCollector.func_74838_a((String)par1).split("%n ")));
        return result;
    }

    public List<String> translateToLocalFormatted(String par1, Object ... par2) {
        String[] array;
        ArrayList<String> result = new ArrayList<String>();
        String text = StatCollector.func_74838_a((String)par1);
        for (String current : array = text.split("%n ")) {
            try {
                result.add(String.format(current, par2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public ItemStack getDisplayItems(CropCard card) {
        if (this.data == null) {
            this.load();
        }
        String name = card.name();
        return this.data.get(name);
    }

    void load() {
        this.data = new HashMap<String, ItemStack>();
        this.data.put("Wheat", new ItemStack(Items.field_151015_O));
        this.data.put("Coffee", IC2Items.getItem((String)"coffeePowder").func_77946_l());
        this.data.put("Hops", IC2Items.getItem((String)"hops").func_77946_l());
        this.data.put("Potato", new ItemStack(Items.field_151174_bG));
        this.data.put("Carrots", new ItemStack(Items.field_151172_bF));
        this.data.put("Dandelion", new ItemStack(Items.field_151100_aR, 1, 11));
        this.data.put("Rose", new ItemStack(Items.field_151100_aR, 1, 1));
        this.data.put("Blackthorn", new ItemStack(Items.field_151100_aR, 1, 0));
        this.data.put("Tulip", new ItemStack(Items.field_151100_aR, 1, 5));
        this.data.put("Cyazint", new ItemStack(Items.field_151100_aR, 1, 6));
        this.data.put("Venomilia", new ItemStack(Items.field_151100_aR, 1, 5));
        this.data.put("Reed", new ItemStack(Items.field_151120_aE));
        this.data.put("Stickreed", IC2Items.getItem((String)"resin").func_77946_l());
        this.data.put("Cocoa", new ItemStack(Items.field_151100_aR, 1, 3));
        this.data.put("Ferru", new ItemStack(Items.field_151042_j));
        this.data.put("Aurelia", new ItemStack(Items.field_151043_k));
        this.data.put("Redwheat", new ItemStack(Items.field_151137_ax));
        this.data.put("RedMushroom", new ItemStack((Block)Blocks.field_150337_Q));
        this.data.put("BrownMushroom", new ItemStack((Block)Blocks.field_150338_P));
        this.data.put("Cacti", new ItemStack(Blocks.field_150434_aF));
        this.data.put("NetherWart", new ItemStack(Items.field_151075_bm));
        this.data.put("TerraWart", IC2Items.getItem((String)"terraWart").func_77946_l());
        this.data.put("Pumpkin", new ItemStack(Blocks.field_150423_aK));
        this.data.put("Melon", new ItemStack(Items.field_151127_ba));
        if (IC2Items.getItem((String)"teaLeaf") != null) {
            this.data.put("Tea", IC2Items.getItem((String)"teaLeaf").func_77946_l());
        }
        this.data.put("Red Mushroom", new ItemStack((Block)Blocks.field_150337_Q));
        this.data.put("Brown Mushroom", new ItemStack((Block)Blocks.field_150338_P));
        this.data.put("Nether Wart", new ItemStack(Items.field_151075_bm));
        this.data.put("Terra Wart", IC2Items.getItem((String)"terraWart").func_77946_l());
    }
}

