/*
 * Decompiled with CFR 0.152.
 */
package com.darkona.adventurebackpack.util;

import com.darkona.adventurebackpack.block.BlockSleepingBag;
import com.darkona.adventurebackpack.block.TileAdventureBackpack;
import com.darkona.adventurebackpack.init.ModBlocks;
import com.darkona.adventurebackpack.util.LogHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CoordsUtils {
    private CoordsUtils() {
    }

    public static ChunkCoordinates findBlock2D(World world, int cX, int cY, int cZ, Block block, int range) {
        for (int i = cX - range; i <= cX + range; ++i) {
            for (int j = cZ - range; j <= cZ + range; ++j) {
                if (world.func_147439_a(i, cY, j) != block) continue;
                return new ChunkCoordinates(i, cY, j);
            }
        }
        return null;
    }

    public static ChunkCoordinates findBlock3D(World world, int cX, int cY, int cZ, Block block, int hRange, int vRange) {
        for (int i = cY - vRange; i <= cY + vRange; ++i) {
            for (int j = cX - hRange; j <= cX + hRange; ++j) {
                for (int k = cZ - hRange; k <= cZ + hRange; ++k) {
                    if (world.func_147439_a(j, i, k) != block) continue;
                    return new ChunkCoordinates(j, i, k);
                }
            }
        }
        return null;
    }

    @Nullable
    private static ChunkCoordinates checkCoordsForBackpack(IBlockAccess world, int cX, int cY, int cZ) {
        return CoordsUtils.isAirOrReplaceable(world, cX, cY, cZ) ? new ChunkCoordinates(cX, cY, cZ) : null;
    }

    private static boolean isAirOrReplaceable(IBlockAccess world, int cX, int cY, int cZ) {
        return world.func_147437_c(cX, cY, cZ) || world.func_147439_a(cX, cY, cZ).isReplaceable(world, cX, cY, cZ);
    }

    private static ChunkCoordinates checkCoordsForPlayer(IBlockAccess world, int origX, int origZ, int cX, int cY, int cZ, boolean except) {
        LogHelper.info("Checking coordinates in X=" + cX + ", Y=" + cY + ", Z=" + cZ);
        if (except && world.isSideSolid(cX, cY - 1, cZ, ForgeDirection.UP, true) && world.func_147437_c(cX, cY, cZ) && world.func_147437_c(cX, cY + 1, cZ) && !CoordsUtils.areCoordinatesTheSame2D(origX, origZ, cX, cZ)) {
            LogHelper.info("Found spot with the exception of the origin point");
            return new ChunkCoordinates(cX, cY, cZ);
        }
        if (!except && world.isSideSolid(cX, cY - 1, cZ, ForgeDirection.UP, true) && world.func_147437_c(cX, cY, cZ) && world.func_147437_c(cX, cY + 1, cZ)) {
            LogHelper.info("Found spot without exceptions");
            return new ChunkCoordinates(cX, cY, cZ);
        }
        return null;
    }

    public static ChunkCoordinates getNearestEmptyChunkCoordinatesSpiral(IBlockAccess world, int origX, int origZ, int cX, int cY, int cZ, int radius, boolean except, int steps, byte pass, boolean type) {
        int j;
        int i;
        if (steps >= radius) {
            return null;
        }
        if (steps % 2 == 0) {
            if (pass == 0) {
                for (i = cX; i <= cX + steps; ++i) {
                    ChunkCoordinates coords;
                    ChunkCoordinates chunkCoordinates = coords = type ? CoordsUtils.checkCoordsForPlayer(world, origX, origZ, cX, cY, cZ, except) : CoordsUtils.checkCoordsForBackpack(world, cX, cY, cZ);
                    if (coords == null) continue;
                    return coords;
                }
                pass = (byte)(pass + 1);
                return CoordsUtils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, i, cY, j, radius, except, steps, pass, type);
            }
            if (pass == 1) {
                for (j = cZ; j >= cZ - steps; --j) {
                    ChunkCoordinates coords;
                    ChunkCoordinates chunkCoordinates = coords = type ? CoordsUtils.checkCoordsForPlayer(world, origX, origZ, cX, cY, cZ, except) : CoordsUtils.checkCoordsForBackpack(world, cX, cY, cZ);
                    if (coords == null) continue;
                    return coords;
                }
                pass = (byte)(pass - 1);
                return CoordsUtils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, i, cY, j, radius, except, ++steps, pass, type);
            }
        }
        if (steps % 2 == 1) {
            if (pass == 0) {
                while (i >= cX - steps) {
                    ChunkCoordinates coords;
                    ChunkCoordinates chunkCoordinates = coords = type ? CoordsUtils.checkCoordsForPlayer(world, origX, origZ, cX, cY, cZ, except) : CoordsUtils.checkCoordsForBackpack(world, cX, cY, cZ);
                    if (coords != null) {
                        return coords;
                    }
                    --i;
                }
                pass = (byte)(pass + 1);
                return CoordsUtils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, i, cY, j, radius, except, steps, pass, type);
            }
            if (pass == 1) {
                while (j <= cZ + steps) {
                    ChunkCoordinates coords;
                    ChunkCoordinates chunkCoordinates = coords = type ? CoordsUtils.checkCoordsForPlayer(world, origX, origZ, cX, cY, cZ, except) : CoordsUtils.checkCoordsForBackpack(world, cX, cY, cZ);
                    if (coords != null) {
                        return coords;
                    }
                    ++j;
                }
                pass = (byte)(pass - 1);
                return CoordsUtils.getNearestEmptyChunkCoordinatesSpiral(world, origX, origZ, i, cY, j, radius, except, ++steps, pass, type);
            }
        }
        return null;
    }

    public static int[] canDeploySleepingBag(World world, EntityPlayer player, int cX, int cY, int cZ, boolean isTile) {
        int switchBy;
        block2: {
            block1: {
                switchBy = -1;
                if (!isTile) break block1;
                TileAdventureBackpack te = (TileAdventureBackpack)world.func_147438_o(cX, cY, cZ);
                if (te.isSleepingBagDeployed()) break block2;
                switchBy = world.func_72805_g(cX, cY, cZ) & 3;
                break block2;
            }
            int playerDirection = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int[] tileSequence = new int[]{2, 3, 0, 1};
            for (int i = 0; i < tileSequence.length; ++i) {
                if (playerDirection != i) continue;
                switchBy = tileSequence[i];
                break;
            }
        }
        return CoordsUtils.getDirectionAndCoordsForSleepingBag(switchBy, world, cX, cY, cZ);
    }

    private static int[] getDirectionAndCoordsForSleepingBag(int switchBy, World world, int cX, int cY, int cZ) {
        int direction = -1;
        switch (switchBy) {
            case 0: {
                if (!CoordsUtils.isAirAboveSolid(world, cX, cY, --cZ) || !CoordsUtils.isAirAboveSolid(world, cX, cY, cZ - 1)) break;
                direction = 2;
                break;
            }
            case 1: {
                if (!CoordsUtils.isAirAboveSolid(world, ++cX, cY, cZ) || !CoordsUtils.isAirAboveSolid(world, cX + 1, cY, cZ)) break;
                direction = 3;
                break;
            }
            case 2: {
                if (!CoordsUtils.isAirAboveSolid(world, cX, cY, ++cZ) || !CoordsUtils.isAirAboveSolid(world, cX, cY, cZ + 1)) break;
                direction = 0;
                break;
            }
            case 3: {
                if (!CoordsUtils.isAirAboveSolid(world, --cX, cY, cZ) || !CoordsUtils.isAirAboveSolid(world, cX - 1, cY, cZ)) break;
                direction = 1;
                break;
            }
        }
        return new int[]{direction, cX, cY, cZ};
    }

    private static boolean isAirAboveSolid(World world, int cX, int cY, int cZ) {
        return world.func_147437_c(cX, cY, cZ) && world.func_147439_a(cX, cY - 1, cZ).func_149688_o().func_76220_a();
    }

    public static boolean spawnSleepingBag(EntityPlayer player, World world, int meta, int cX, int cY, int cZ) {
        BlockSleepingBag sleepingBag = ModBlocks.blockSleepingBag;
        if (world.func_147465_d(cX, cY, cZ, (Block)sleepingBag, meta, 3)) {
            world.func_72956_a((Entity)player, Block.field_149775_l.func_150496_b(), 0.5f, 1.0f);
            switch (meta & 3) {
                case 0: {
                    ++cZ;
                    break;
                }
                case 1: {
                    --cX;
                    break;
                }
                case 2: {
                    --cZ;
                    break;
                }
                case 3: {
                    ++cX;
                }
            }
            return world.func_147465_d(cX, cY, cZ, (Block)sleepingBag, meta + 8, 3);
        }
        return false;
    }

    private static boolean areCoordinatesTheSame(int cX1, int cY1, int cZ1, int cX2, int cY2, int cZ2) {
        return cX1 == cX2 && cY1 == cY2 && cZ1 == cZ2;
    }

    private static boolean areCoordinatesTheSame2D(int cX1, int cZ1, int cX2, int cZ2) {
        return cX1 == cX2 && cZ1 == cZ2;
    }
}

