/*
 * Decompiled with CFR 0.152.
 */
package api.undercurrent.iface.editorTypes;

import api.undercurrent.iface.editorTypes.EditorType;

public class IntegerEditorType
extends EditorType {
    private int minValue;
    private int maxValue;

    public IntegerEditorType(String fieldName, int fieldValue, String displayName, String displayDescription, int minValue, int maxValue) {
        super(EditorType.EditorTypes.INT);
        this.fieldName = fieldName;
        this.fieldValue = fieldValue;
        this.displayName = displayName;
        this.displayDescription = displayDescription;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object getFieldValue() {
        return (Integer)this.fieldValue;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayDescription() {
        return this.displayDescription;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean validateValue(Object obj) throws Exception {
        try {
            double objcast = Integer.valueOf(String.valueOf(obj)).intValue();
            if (objcast > (double)this.getMaxValue()) {
                return false;
            }
            return !(objcast < (double)this.getMinValue());
        }
        catch (Exception e) {
            return false;
        }
    }
}

