/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.galacticraft.atmosphere;

import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.github.bartimaeusnek.crossmod.BartWorksCrossmod;
import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISubTagContainer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;

public final class BWAtmosphereManager {
    private static final Map<Integer, Integer[]> COEFFICIENT_MAP = new HashMap<Integer, Integer[]>();
    public static final BWAtmosphereManager INSTANCE = new BWAtmosphereManager();
    private static final ArrayListMultimap<Integer, Pair<ISubTagContainer, Integer>> gasConcentration = ArrayListMultimap.create();

    private BWAtmosphereManager() {
        COEFFICIENT_MAP.put(1, new Integer[]{100});
        COEFFICIENT_MAP.put(2, new Integer[]{70, 30});
        COEFFICIENT_MAP.put(3, new Integer[]{60, 25, 15});
        COEFFICIENT_MAP.put(4, new Integer[]{50, 25, 15, 10});
        COEFFICIENT_MAP.put(5, new Integer[]{45, 25, 15, 10, 5});
        COEFFICIENT_MAP.put(6, new Integer[]{45, 20, 15, 10, 5, 5});
        COEFFICIENT_MAP.put(7, new Integer[]{40, 20, 15, 10, 5, 5, 5});
        COEFFICIENT_MAP.put(8, new Integer[]{35, 20, 15, 10, 5, 5, 5, 5});
        COEFFICIENT_MAP.put(9, new Integer[]{35, 15, 15, 10, 5, 5, 5, 5, 5});
    }

    public static List<Pair<ISubTagContainer, Integer>> getGasFromWorldID(int worldID) {
        return gasConcentration.get((Object)worldID);
    }

    public static void removeGasFromWorld(int worldID, ISubTagContainer gas) {
        for (Pair pair : gasConcentration.get((Object)worldID)) {
            if (!((ISubTagContainer)pair.getKey()).equals(gas)) continue;
            gasConcentration.get((Object)worldID).remove(pair);
            return;
        }
    }

    public static void addGasToWorld(int worldID, ISubTagContainer gas, int amount) {
        Pair<ISubTagContainer, Integer> toadd = new Pair<ISubTagContainer, Integer>(gas, amount);
        gasConcentration.put((Object)worldID, toadd);
    }

    public static void addGasToWorld(int worldID, Pair<ISubTagContainer, Integer> toPut) {
        gasConcentration.put((Object)worldID, toPut);
    }

    @SafeVarargs
    public static void addGasToWorld(int worldID, Pair<ISubTagContainer, Integer> ... toPut) {
        Arrays.stream(toPut).forEach(toadd -> gasConcentration.put((Object)worldID, toadd));
    }

    private static boolean addGCGasToWorld(int worldID, IAtmosphericGas gas, int aNumber, int aMaxNumber) {
        if (IAtmosphericGas.CO2.equals((Object)gas)) {
            BWAtmosphereManager.addGasToWorld(worldID, (ISubTagContainer)Materials.CarbonDioxide, COEFFICIENT_MAP.get(aMaxNumber)[aNumber]);
            return true;
        }
        String name = gas.toString();
        Object mat = Materials.get((String)(name = name.charAt(0) + name.substring(1).toLowerCase(Locale.US)));
        if (mat == Materials._NULL) {
            mat = WerkstoffLoader.getWerkstoff(name);
        }
        if (mat == Werkstoff.default_null_Werkstoff) {
            return false;
        }
        BWAtmosphereManager.addGasToWorld(worldID, (ISubTagContainer)mat, COEFFICIENT_MAP.get(aMaxNumber)[aNumber]);
        return true;
    }

    @SubscribeEvent
    public void gcAutoRegister(GalaxyRegistry.PlanetRegisterEvent event) {
        CelestialBody planet = (CelestialBody)GalaxyRegistry.getRegisteredPlanets().get(event.planetName);
        for (int i = 0; i < planet.atmosphere.size(); ++i) {
            if (BWAtmosphereManager.addGCGasToWorld(planet.getDimensionID(), (IAtmosphericGas)planet.atmosphere.get(i), i, planet.atmosphere.size())) continue;
            BartWorksCrossmod.LOGGER.warn("Unidentified Fluid (" + planet.atmosphere.get(i) + ") in the Atmosphere of: " + planet.getLocalizedName());
        }
    }
}

