/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.recipe;

import com.github.bartimaeusnek.bartworks.system.material.BW_GT_MaterialReference;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.werkstoff_loaders.IWerkstoffRunnable;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import net.minecraft.item.ItemStack;

public class CasingLoader
implements IWerkstoffRunnable {
    @Override
    public void run(Werkstoff werkstoff) {
        if (werkstoff == BW_GT_MaterialReference.Wood) {
            CasingLoader.addCasingRecipes(werkstoff, OrePrefixes.plank);
        } else {
            if (!(werkstoff.hasGenerationFeature(OrePrefixes.blockCasing) && werkstoff.doesOreDictedItemExists(OrePrefixes.plate) && werkstoff.doesOreDictedItemExists(OrePrefixes.screw) && werkstoff.doesOreDictedItemExists(OrePrefixes.gearGtSmall) && werkstoff.doesOreDictedItemExists(OrePrefixes.gearGt) && werkstoff.doesOreDictedItemExists(OrePrefixes.plateDouble))) {
                return;
            }
            CasingLoader.addCasingRecipes(werkstoff, OrePrefixes.plateDouble);
        }
    }

    private static void addCasingRecipes(Werkstoff werkstoff, OrePrefixes reboltedCasingsOuterStuff) {
        GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.blockCasing), (Object[])new Object[]{"PSP", "PGP", "PSP", Character.valueOf('P'), werkstoff.get(OrePrefixes.plate), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw), Character.valueOf('G'), werkstoff.get(OrePrefixes.gearGtSmall)});
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(OrePrefixes.plate, 6), werkstoff.get(OrePrefixes.screw, 2), werkstoff.get(OrePrefixes.gearGtSmall)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.blockCasing)}).duration(200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
        GT_ModHandler.addCraftingRecipe((ItemStack)werkstoff.get(OrePrefixes.blockCasingAdvanced), (Object[])new Object[]{"PSP", "PGP", "PSP", Character.valueOf('P'), werkstoff.get(reboltedCasingsOuterStuff), Character.valueOf('S'), werkstoff.get(OrePrefixes.screw), Character.valueOf('G'), werkstoff.get(OrePrefixes.gearGt)});
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack[]{werkstoff.get(reboltedCasingsOuterStuff, 6), werkstoff.get(OrePrefixes.screw, 2), werkstoff.get(OrePrefixes.gearGt)}).itemOutputs(new ItemStack[]{werkstoff.get(OrePrefixes.blockCasingAdvanced)}).duration(200).eut(TierEU.RECIPE_LV).addTo((IRecipeMap)RecipeMaps.assemblerRecipes);
    }
}

