/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration;

import com.github.bartimaeusnek.bartworks.API.recipe.BWNBTDependantCraftingRecipe;
import com.github.bartimaeusnek.bartworks.API.recipe.BartWorksRecipeMaps;
import com.github.bartimaeusnek.bartworks.ASM.BWCoreStaticReplacementMethodes;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_Meta_Items;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.CircuitData;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.util.BW_Util;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CircuitImprintLoader {
    public static short reverseIDs = (short)32766;
    public static final ArrayListMultimap<NBTTagCompound, GT_Recipe> recipeTagMap = ArrayListMultimap.create();
    public static final HashBiMap<Short, ItemList> circuitIIconRefs = HashBiMap.create((int)20);
    public static final HashSet<ItemStack> blacklistSet = new HashSet();
    static final HashBiMap<CircuitData, ItemStack> bwCircuitTagMap = HashBiMap.create((int)20);
    private static final HashSet<IRecipe> recipeWorldCache = new HashSet();
    private static final HashSet<GT_Recipe> gtrecipeWorldCache = new HashSet();
    private static final HashSet<GT_Recipe> ORIGINAL_CAL_RECIPES = new HashSet();
    private static final HashSet<GT_Recipe> MODIFIED_CAL_RECIPES = new HashSet();
    private static final List<Pair<ItemStack, ItemStack>> circuitPartsToReplace = Collections.unmodifiableList(Arrays.asList(new Pair<ItemStack, ItemStack>(ItemList.Circuit_Parts_Resistor.get(1L, new Object[0]), ItemList.Circuit_Parts_ResistorSMD.get(1L, new Object[0])), new Pair<ItemStack, ItemStack>(ItemList.Circuit_Parts_Diode.get(1L, new Object[0]), ItemList.Circuit_Parts_DiodeSMD.get(1L, new Object[0])), new Pair<ItemStack, ItemStack>(ItemList.Circuit_Parts_Transistor.get(1L, new Object[0]), ItemList.Circuit_Parts_TransistorSMD.get(1L, new Object[0])), new Pair<ItemStack, ItemStack>(ItemList.Circuit_Parts_Capacitor.get(1L, new Object[0]), ItemList.Circuit_Parts_CapacitorSMD.get(1L, new Object[0])), new Pair<ItemStack, ItemStack>(ItemList.Circuit_Parts_Coil.get(1L, new Object[0]), ItemList.Circuit_Parts_InductorSMD.get(1L, new Object[0]))));

    public static void run() {
        HashSet<GT_Recipe> toRem = new HashSet<GT_Recipe>();
        HashSet<GT_Recipe> toAdd = new HashSet<GT_Recipe>();
        CircuitImprintLoader.deleteCALRecipesAndTags();
        CircuitImprintLoader.rebuildCircuitAssemblerMap(toRem, toAdd);
        CircuitImprintLoader.exchangeRecipesInList(toRem, toAdd);
        CircuitImprintLoader.makeCircuitImprintRecipes();
        toRem = null;
        toAdd = null;
    }

    private static void reAddOriginalRecipes() {
        RecipeMaps.circuitAssemblerRecipes.getBackend().removeRecipes(MODIFIED_CAL_RECIPES);
        ORIGINAL_CAL_RECIPES.forEach(arg_0 -> ((RecipeMap)RecipeMaps.circuitAssemblerRecipes).add(arg_0));
        ORIGINAL_CAL_RECIPES.clear();
        MODIFIED_CAL_RECIPES.clear();
    }

    private static void rebuildCircuitAssemblerMap(HashSet<GT_Recipe> toRem, HashSet<GT_Recipe> toAdd) {
        CircuitImprintLoader.reAddOriginalRecipes();
        RecipeMaps.circuitAssemblerRecipes.getAllRecipes().forEach(e -> CircuitImprintLoader.handleCircuitRecipeRebuilding(e, toRem, toAdd));
    }

    private static void handleCircuitRecipeRebuilding(GT_Recipe circuitRecipe, HashSet<GT_Recipe> toRem, HashSet<GT_Recipe> toAdd) {
        ItemStack[] outputs = circuitRecipe.mOutputs;
        boolean isOrePass = CircuitImprintLoader.isCircuitOreDict(outputs[0]);
        String unlocalizedName = outputs[0].func_77977_a();
        if (isOrePass || unlocalizedName.contains("Circuit") || unlocalizedName.contains("circuit")) {
            Fluid solderUEV;
            recipeTagMap.put((Object)CircuitImprintLoader.getTagFromStack(outputs[0]), (Object)circuitRecipe.copy());
            Fluid solderIndalloy = FluidRegistry.getFluid((String)"molten.indalloy140") != null ? FluidRegistry.getFluid((String)"molten.indalloy140") : FluidRegistry.getFluid((String)"molten.solderingalloy");
            Fluid fluid = solderUEV = FluidRegistry.getFluid((String)"molten.mutatedlivingsolder") != null ? FluidRegistry.getFluid((String)"molten.mutatedlivingsolder") : FluidRegistry.getFluid((String)"molten.solderingalloy");
            if (circuitRecipe.mFluidInputs[0].isFluidEqual(Materials.SolderingAlloy.getMolten(0L)) || circuitRecipe.mFluidInputs[0].isFluidEqual(new FluidStack(solderIndalloy, 0)) || circuitRecipe.mFluidInputs[0].isFluidEqual(new FluidStack(solderUEV, 0))) {
                GT_Recipe newRecipe = CircuitImprintLoader.reBuildRecipe(circuitRecipe);
                if (newRecipe != null) {
                    BartWorksRecipeMaps.circuitAssemblyLineRecipes.addRecipe(newRecipe);
                }
                CircuitImprintLoader.addCutoffRecipeToSets(toRem, toAdd, circuitRecipe);
            } else if ((long)circuitRecipe.mEUt > BW_Util.getTierVoltage(ConfigHandler.cutoffTier)) {
                toRem.add(circuitRecipe);
            }
        }
    }

    private static boolean isCircuitOreDict(ItemStack item) {
        return BW_Util.isTieredCircuit(item) || BW_Util.getOreNames(item).stream().anyMatch(s -> "circuitPrimitiveArray".equals(s));
    }

    private static void exchangeRecipesInList(HashSet<GT_Recipe> toRem, HashSet<GT_Recipe> toAdd) {
        toAdd.forEach(arg_0 -> ((RecipeMap)RecipeMaps.circuitAssemblerRecipes).add(arg_0));
        RecipeMaps.circuitAssemblerRecipes.getBackend().removeRecipes(toRem);
        ORIGINAL_CAL_RECIPES.addAll(toRem);
        MODIFIED_CAL_RECIPES.addAll(toAdd);
    }

    private static void addCutoffRecipeToSets(HashSet<GT_Recipe> toRem, HashSet<GT_Recipe> toAdd, GT_Recipe circuitRecipe) {
        if ((long)circuitRecipe.mEUt > BW_Util.getTierVoltage(ConfigHandler.cutoffTier)) {
            toRem.add(circuitRecipe);
            toAdd.add(CircuitImprintLoader.makeMoreExpensive(circuitRecipe));
        }
    }

    public static GT_Recipe makeMoreExpensive(GT_Recipe original) {
        GT_Recipe newRecipe = original.copy();
        for (ItemStack is : newRecipe.mInputs) {
            if (BW_Util.isTieredCircuit(is)) continue;
            is.field_77994_a = Math.min(is.field_77994_a * 6, 64);
            if (is.field_77994_a <= is.func_77973_b().func_77639_j() && is.field_77994_a <= is.func_77976_d()) continue;
            is.field_77994_a = is.func_77976_d();
        }
        newRecipe.mFluidInputs[0].amount *= 4;
        newRecipe.mDuration *= 4;
        return newRecipe;
    }

    public static GT_Recipe reBuildRecipe(GT_Recipe original) {
        ItemStack[] in = new ItemStack[6];
        BiMap inversed = circuitIIconRefs.inverse();
        for (int i = 0; i < 6; ++i) {
            try {
                CircuitImprintLoader.replaceCircuits((BiMap<ItemList, Short>)inversed, original, in, i);
                CircuitImprintLoader.replaceComponents(in, original, i);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                break;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        if (CircuitImprintLoader.checkForBlacklistedComponents(in)) {
            return null;
        }
        return new GT_Recipe(false, in, new ItemStack[]{CircuitImprintLoader.getOutputMultiplied(original)}, (Object)BW_Meta_Items.getNEWCIRCUITS().getStackWithNBT(CircuitImprintLoader.getTagFromStack(original.mOutputs[0]), 0, 0), null, original.mFluidInputs, null, original.mDuration * 12, original.mEUt, 0);
    }

    private static ItemStack getOutputMultiplied(GT_Recipe original) {
        ItemStack out = original.copy().getOutput(0);
        out.field_77994_a *= 16;
        return out;
    }

    private static void replaceCircuits(BiMap<ItemList, Short> inversed, GT_Recipe original, ItemStack[] in, int index) {
        for (ItemList il : inversed.keySet()) {
            if (!GT_Utility.areStacksEqual((ItemStack)il.get(1L, new Object[0]), (ItemStack)CircuitImprintLoader.replaceCircuitParts(original.mInputs[index]))) continue;
            in[index] = BW_Meta_Items.getNEWCIRCUITS().getStack(((Short)inversed.get((Object)il)).shortValue(), original.mInputs[index].field_77994_a);
        }
    }

    private static ItemStack replaceCircuitParts(ItemStack stack) {
        for (Pair<ItemStack, ItemStack> pair : circuitPartsToReplace) {
            if (!GT_Utility.areStacksEqual((ItemStack)pair.getKey(), (ItemStack)stack)) continue;
            ItemStack newStack = pair.getValue();
            newStack.field_77994_a = stack.field_77994_a;
            return newStack;
        }
        return stack;
    }

    private static void replaceComponents(ItemStack[] in, GT_Recipe original, int index) throws ArrayIndexOutOfBoundsException {
        if (original.mInputs[index] != null && in[index] == null) {
            if (BW_Util.checkStackAndPrefix(original.mInputs[index]) && GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mPrefix == OrePrefixes.wireGt01) {
                in[index] = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt16, (Object)GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mMaterial.mMaterial, (long)original.mInputs[index].field_77994_a);
            } else if (BW_Util.checkStackAndPrefix(original.mInputs[index]) && GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mPrefix == OrePrefixes.wireFine) {
                in[index] = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireGt04, (Object)GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mMaterial.mMaterial, (long)original.mInputs[index].field_77994_a);
                if (in[index] == null) {
                    in[index] = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.wireFine, (Object)GT_OreDictUnificator.getAssociation((ItemStack)original.mInputs[index]).mMaterial.mMaterial, (long)(original.mInputs[index].field_77994_a * 16));
                }
            } else {
                in[index] = original.mInputs[index].func_77946_l();
                in[index].field_77994_a *= 16;
                if (in[index].field_77994_a > in[index].func_77973_b().func_77639_j() || in[index].field_77994_a > in[index].func_77976_d()) {
                    in[index].field_77994_a = in[index].func_77976_d();
                }
            }
        }
    }

    private static void makeCircuitImprintRecipes() {
        CircuitImprintLoader.removeOldRecipesFromRegistries();
        recipeTagMap.keySet().forEach(e -> {
            CircuitImprintLoader.makeAndAddSlicingRecipe(e);
            CircuitImprintLoader.makeAndAddCraftingRecipes(e);
        });
    }

    private static boolean checkForBlacklistedComponents(ItemStack[] itemStacks) {
        for (ItemStack is : itemStacks) {
            for (ItemStack is2 : blacklistSet) {
                if (!GT_Utility.areStacksEqual((ItemStack)is, (ItemStack)is2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void removeOldRecipesFromRegistries() {
        recipeWorldCache.forEach(CraftingManager.func_77594_a().func_77592_b()::remove);
        BWCoreStaticReplacementMethodes.clearRecentlyUsedRecipes();
        RecipeMaps.slicerRecipes.getBackend().removeRecipes(gtrecipeWorldCache);
        recipeWorldCache.forEach(r -> {
            try {
                BW_Util.getGTBufferedRecipeList().remove(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        recipeWorldCache.clear();
        gtrecipeWorldCache.clear();
    }

    private static void makeAndAddSlicingRecipe(NBTTagCompound tag) {
        ItemStack stack = CircuitImprintLoader.getStackFromTag(tag);
        int eut = Integer.MAX_VALUE;
        for (GT_Recipe recipe : recipeTagMap.get((Object)tag)) {
            eut = Math.min(eut, recipe.mEUt);
        }
        eut = Math.min(eut, BW_Util.getMachineVoltageFromTier(BW_Util.getCircuitTierFromOreDictName(OreDictionary.getOreName((int)(OreDictionary.getOreIDs((ItemStack)stack) != null && OreDictionary.getOreIDs((ItemStack)stack).length > 0 ? OreDictionary.getOreIDs((ItemStack)stack)[0] : -1)))));
        GT_Recipe slicingRecipe = new GT_Recipe(true, new ItemStack[]{stack, ItemList.Shape_Slicer_Flat.get(0L, new Object[0])}, new ItemStack[]{BW_Meta_Items.getNEWCIRCUITS().getStackWithNBT(tag, 1, 1)}, null, null, null, null, 300, eut, -200);
        gtrecipeWorldCache.add(slicingRecipe);
        RecipeMaps.slicerRecipes.add(slicingRecipe);
    }

    private static void makeAndAddCraftingRecipes(NBTTagCompound tag) {
        ItemStack circuit = BW_Meta_Items.getNEWCIRCUITS().getStackWithNBT(tag, 0, 1);
        Object[] imprintRecipe = new Object[]{" X ", "GPG", " X ", Character.valueOf('P'), BW_Meta_Items.getNEWCIRCUITS().getStackWithNBT(tag, 1, 1), Character.valueOf('G'), WerkstoffLoader.Prasiolite.get(OrePrefixes.gemExquisite, 1), Character.valueOf('X'), BW_Meta_Items.getNEWCIRCUITS().getStack(3)};
        BWNBTDependantCraftingRecipe bwrecipe = new BWNBTDependantCraftingRecipe(circuit, imprintRecipe);
        ShapedOreRecipe gtrecipe = BW_Util.createGTCraftingRecipe(circuit, GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.KEEPNBT | GT_ModHandler.RecipeBits.BUFFERED, imprintRecipe);
        recipeWorldCache.add(bwrecipe);
        GameRegistry.addRecipe((IRecipe)bwrecipe);
        recipeWorldCache.add((IRecipe)gtrecipe);
        GameRegistry.addRecipe((IRecipe)gtrecipe);
    }

    public static NBTTagCompound getTagFromStack(ItemStack stack) {
        if (GT_Utility.isStackValid((ItemStack)stack)) {
            return BW_Util.setStackSize(stack.func_77946_l(), 1).func_77955_b(new NBTTagCompound());
        }
        return new NBTTagCompound();
    }

    public static ItemStack getStackFromTag(NBTTagCompound tagCompound) {
        return ItemStack.func_77949_a((NBTTagCompound)tagCompound);
    }

    private static void deleteCALRecipesAndTags() {
        BartWorksRecipeMaps.circuitAssemblyLineRecipes.getBackend().clearRecipes();
        recipeTagMap.clear();
    }
}

