/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;

public class ProcessingTransforming
implements IOreRecipeRegistrator {
    public ProcessingTransforming() {
        for (OrePrefixes tPrefix : OrePrefixes.values()) {
            if ((tPrefix.mMaterialAmount <= 0L || tPrefix.mIsContainer || tPrefix.mIsEnchantable) && tPrefix != OrePrefixes.plank) continue;
            tPrefix.add(this);
        }
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        if (aPrefix == OrePrefixes.plank) {
            aPrefix = OrePrefixes.plate;
        }
        switch (aMaterial.mName) {
            case "Wood": {
                if (GT_OreDictUnificator.get(aPrefix, Materials.WoodSealed, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.WoodSealed, 1L)).fluidInputs(Materials.SeedOil.getFluid(GT_Utility.translateMaterialToAmount(aPrefix.mMaterialAmount, 120L, true))).duration(100).eut(TierEU.ULV).addTo(RecipeMaps.chemicalBathRecipes);
                break;
            }
            case "Iron": {
                if (GT_OreDictUnificator.get(aPrefix, Materials.FierySteel, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.FierySteel, 1L)).fluidInputs(Materials.FierySteel.getFluid(GT_Utility.translateMaterialToAmount(aPrefix.mMaterialAmount, 250L, true))).duration(100).eut(TierEU.ULV).addTo(RecipeMaps.chemicalBathRecipes);
                }
                if (GT_OreDictUnificator.get(aPrefix, Materials.IronMagnetic, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.IronMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.LV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "WroughtIron": {
                if (GT_OreDictUnificator.get(aPrefix, Materials.FierySteel, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.FierySteel, 1L)).fluidInputs(Materials.FierySteel.getFluid(GT_Utility.translateMaterialToAmount(aPrefix.mMaterialAmount, 225L, true))).duration(100).eut(TierEU.ULV).addTo(RecipeMaps.chemicalBathRecipes);
                }
                if (GT_OreDictUnificator.get(aPrefix, Materials.IronMagnetic, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.IronMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.LV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "Steel": {
                if (GT_OreDictUnificator.get(aPrefix, Materials.FierySteel, 1L) != null) {
                    GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.FierySteel, 1L)).fluidInputs(Materials.FierySteel.getFluid(GT_Utility.translateMaterialToAmount(aPrefix.mMaterialAmount, 200L, true))).duration(100).eut(TierEU.ULV).addTo(RecipeMaps.chemicalBathRecipes);
                }
                if (GT_OreDictUnificator.get(aPrefix, Materials.SteelMagnetic, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.SteelMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.LV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "Neodymium": {
                if (GT_OreDictUnificator.get(aPrefix, Materials.NeodymiumMagnetic, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.NeodymiumMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.HV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "Samarium": {
                if (GT_OreDictUnificator.get(aPrefix, Materials.SamariumMagnetic, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.SamariumMagnetic, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.IV / 2).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
            case "TengamPurified": {
                if (GT_OreDictUnificator.get(aPrefix, Materials.TengamAttuned, 1L) == null) break;
                GT_Values.RA.stdBuilder().itemInputs(GT_Utility.copyAmount(1, aStack)).itemOutputs(GT_OreDictUnificator.get(aPrefix, Materials.TengamAttuned, 1L)).duration((int)Math.max(16L, aPrefix.mMaterialAmount * 128L / 3628800L) * 1).eut((int)TierEU.RECIPE_UHV).addTo(RecipeMaps.polarizerRecipes);
                break;
            }
        }
    }
}

