/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.load;

import buildcraft.api.tools.IToolWrench;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_RecipeConstants;
import gregtech.api.util.GT_Utility;
import gregtech.common.tools.GT_Tool_Scoop;
import mods.railcraft.api.core.items.IToolCrowbar;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class GT_ItemIterator
implements Runnable {
    @Override
    public void run() {
        GT_Log.out.println("GT_Mod: Scanning for certain kinds of compatible Machineblocks.");
        ItemStack tStack2 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Bronze, 1L);
        ItemStack tStack = GT_ModHandler.getRecipeOutput(tStack2, tStack2, tStack2, tStack2, null, tStack2, tStack2, tStack2, tStack2);
        if (null != tStack) {
            GT_Values.RA.stdBuilder().itemInputs(tStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Bronze, 8L)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
            GT_ModHandler.addSmeltingRecipe(tStack, GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Bronze, 8L));
        }
        if (null != (tStack = GT_ModHandler.getRecipeOutput(tStack2 = GT_OreDictUnificator.get(OrePrefixes.plate, Materials.Bronze, 1L), tStack2, tStack2, tStack2, null, tStack2, tStack2, tStack2, tStack2))) {
            GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingRawMachineTier00, tStack);
            GT_Values.RA.stdBuilder().itemInputs(tStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Bronze, 8L)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
            GT_ModHandler.addSmeltingRecipe(tStack, GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Bronze, 8L));
        }
        ItemStack tStack3 = new ItemStack(Blocks.field_150359_w, 1, 0);
        tStack2 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Iron, 1L);
        tStack = GT_ModHandler.getRecipeOutput(tStack2, tStack3, tStack2, tStack3, GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Gold, 1L), tStack3, tStack2, tStack3, tStack2);
        if (null != tStack) {
            GT_Values.RA.stdBuilder().itemInputs(tStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Iron, 4L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Gold, 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        }
        if (null != (tStack = GT_ModHandler.getRecipeOutput(tStack2 = GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Steel, 1L), tStack3 = new ItemStack(Blocks.field_150359_w, 1, 0), tStack2, tStack3, GT_OreDictUnificator.get(OrePrefixes.ingot, Materials.Gold, 1L), tStack3, tStack2, tStack3, tStack2))) {
            GT_Values.RA.stdBuilder().itemInputs(tStack).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Steel, 4L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Gold, 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
        }
        GT_Log.out.println("GT_Mod: Registering various Tools to be usable on GregTech Machines");
        GregTech_API.registerScrewdriver(GT_ModHandler.getRecipeOutput(null, new ItemStack(Items.field_151042_j, 1), null, new ItemStack(Items.field_151055_y, 1)));
        GregTech_API.registerScrewdriver(GT_ModHandler.getRecipeOutput(new ItemStack(Items.field_151042_j, 1), null, null, null, new ItemStack(Items.field_151055_y, 1)));
        GT_Log.out.println("GT_Mod: Adding Food Recipes to the Automatic Canning Machine. (also during the following Item Iteration)");
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151078_bh, 2, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(1L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Spoiled.get(1L, new Object[0])).duration(200).eut(1).addTo(RecipeMaps.cannerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151070_bp, 2, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(1L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Spoiled.get(1L, new Object[0])).duration(100).eut(1).addTo(RecipeMaps.cannerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(ItemList.Food_Poisonous_Potato.get(2L, new Object[0]), ItemList.IC2_Food_Can_Empty.get(1L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Spoiled.get(1L, new Object[0])).duration(100).eut(1).addTo(RecipeMaps.cannerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151105_aU, 1, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(12L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Filled.get(12L, new Object[0])).duration(600).eut(1).addTo(RecipeMaps.cannerRecipes);
        GT_Values.RA.stdBuilder().itemInputs(new ItemStack(Items.field_151009_A, 1, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(6L, new Object[0])).itemOutputs(ItemList.IC2_Food_Can_Filled.get(6L, new Object[0]), new ItemStack(Items.field_151054_z, 1)).duration(300).eut(1).addTo(RecipeMaps.cannerRecipes);
        GT_Log.out.println("GT_Mod: Scanning ItemList.");
        try {
            for (Object o : Item.field_150901_e) {
                int tFoodValue;
                Block tBlock;
                Item tItem;
                String tName;
                Object tObject = o;
                if (!(tObject instanceof Item) || tObject instanceof GT_Generic_Item || (tName = (tItem = (Item)tObject).func_77658_a()) == null) continue;
                if (tItem instanceof IToolCrowbar) {
                    if (!tItem.func_77645_m() && !GT_ModHandler.isElectricItem(new ItemStack(tItem, 1, 0))) {
                        if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.disabledrecipes, "infiniteDurabilityRCCrowbars", false) && GT_ModHandler.removeRecipeByOutput(new ItemStack(tItem, 1, Short.MAX_VALUE))) {
                            GT_Log.out.println("GT_Mod: Removed infinite RC Crowbar: " + tName);
                        }
                    } else if (GregTech_API.registerCrowbar(new ItemStack(tItem, 1, Short.MAX_VALUE))) {
                        GT_Log.out.println("GT_Mod: Registered valid RC Crowbar: " + tName);
                    }
                }
                if (tItem instanceof IToolWrench) {
                    if (!tItem.func_77645_m() && !GT_ModHandler.isElectricItem(new ItemStack(tItem, 1, 0))) {
                        if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.disabledrecipes, "infiniteDurabilityBCWrenches", false) && GT_ModHandler.removeRecipeByOutput(new ItemStack(tItem, 1, Short.MAX_VALUE))) {
                            GT_Log.out.println("GT_Mod: Removed infinite BC Wrench: " + tName);
                        }
                    } else if (GregTech_API.registerWrench(new ItemStack(tItem, 1, Short.MAX_VALUE))) {
                        GT_Log.out.println("GT_Mod: Registered valid BC Wrench: " + tName);
                    }
                }
                if ((tBlock = GT_Utility.getBlockFromStack(new ItemStack(tItem, 1, 0))) != null) {
                    if (tName.endsWith("beehives")) {
                        tBlock.setHarvestLevel("scoop", 0);
                        GT_Tool_Scoop.sBeeHiveMaterial = tBlock.func_149688_o();
                    }
                    if (OrePrefixes.stone.mDefaultStackSize < tItem.getItemStackLimit(new ItemStack(tItem, 1, 0)) && (tBlock.isReplaceableOreGen(GT_Values.DW, 0, 0, 0, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(GT_Values.DW, 0, 0, 0, Blocks.field_150424_aL) || tBlock.isReplaceableOreGen(GT_Values.DW, 0, 0, 0, Blocks.field_150377_bs))) {
                        tItem.func_77625_d((int)OrePrefixes.stone.mDefaultStackSize);
                    }
                }
                if (tItem instanceof ItemFood && tItem != ItemList.IC2_Food_Can_Filled.getItem() && tItem != ItemList.IC2_Food_Can_Spoiled.getItem() && (tFoodValue = ((ItemFood)tItem).func_150905_g(new ItemStack(tItem, 1, 0))) > 0) {
                    GT_RecipeBuilder recipeBuilder = GT_Values.RA.stdBuilder();
                    recipeBuilder.itemInputs(new ItemStack(tItem, 1, Short.MAX_VALUE), ItemList.IC2_Food_Can_Empty.get(tFoodValue, new Object[0]));
                    if (GT_Utility.getContainerItem(new ItemStack(tItem, 1, 0), true) == null) {
                        recipeBuilder.itemOutputs(ItemList.IC2_Food_Can_Filled.get(tFoodValue, new Object[0]));
                    } else {
                        recipeBuilder.itemOutputs(ItemList.IC2_Food_Can_Filled.get(tFoodValue, new Object[0]), GT_Utility.getContainerItem(new ItemStack(tItem, 1, 0), true));
                    }
                    recipeBuilder.duration(tFoodValue * 5 * 20).eut(1).addTo(RecipeMaps.cannerRecipes);
                }
                if (tItem instanceof IFluidContainerItem) {
                    GT_OreDictUnificator.addToBlacklist(new ItemStack(tItem, 1, Short.MAX_VALUE));
                }
                switch (tName) {
                    case "item.fieryBlood": 
                    case "item.fieryTears": {
                        GT_Values.RA.stdBuilder().itemInputs(new ItemStack(tItem, 1, 0)).metadata(GT_RecipeConstants.FUEL_VALUE, 2048).metadata(GT_RecipeConstants.FUEL_TYPE, 5).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "tile.TFRoots": {
                        GT_Values.RA.stdBuilder().itemInputs(new ItemStack(tItem, 1, 0)).itemOutputs(new ItemStack(Items.field_151055_y, 2), new ItemStack(Items.field_151055_y, 1)).outputChances(10000, 3000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                        GT_ModHandler.addSawmillRecipe(new ItemStack(tItem, 1, 0), new ItemStack(Items.field_151055_y, 4), new ItemStack(Items.field_151055_y, 2));
                        GT_Values.RA.stdBuilder().itemInputs(new ItemStack(tItem, 1, 1)).itemOutputs(new ItemStack(Items.field_151055_y, 4)).metadata(GT_RecipeConstants.FUEL_VALUE, 32).metadata(GT_RecipeConstants.FUEL_TYPE, 5).addTo(GT_RecipeConstants.Fuel);
                        break;
                    }
                    case "item.tconstruct.manual": {
                        GT_OreDictUnificator.registerOre("bookTinkersManual", new ItemStack(tItem, 1, Short.MAX_VALUE));
                        break;
                    }
                    case "item.blueprintItem": {
                        GT_OreDictUnificator.registerOre("paperBlueprint", new ItemStack(tItem, 1, Short.MAX_VALUE));
                        break;
                    }
                    case "item.ItemThaumonomicon": {
                        GT_OreDictUnificator.registerOre("bookThaumonomicon", new ItemStack(tItem, 1, Short.MAX_VALUE));
                        break;
                    }
                    case "tile.bop.redRocks": {
                        GT_OreDictUnificator.registerOre(OrePrefixes.stone, Materials.Redrock, new ItemStack(tItem, 1, 0));
                        GT_OreDictUnificator.registerOre(OrePrefixes.stone, Materials.Redrock, new ItemStack(tItem, 1, 1));
                        GT_OreDictUnificator.registerOre(OrePrefixes.stone, Materials.Redrock, new ItemStack(tItem, 1, 2));
                        break;
                    }
                    case "tile.blockCosmeticSolid": {
                        GT_OreDictUnificator.registerOre(OrePrefixes.stone, Materials.Obsidian, new ItemStack(tItem, 1, 0));
                        GT_OreDictUnificator.registerOre(OrePrefixes.stone, Materials.Obsidian, new ItemStack(tItem, 1, 1));
                        GT_OreDictUnificator.registerOre(OrePrefixes.block, Materials.Thaumium, new ItemStack(tItem, 1, 4));
                        break;
                    }
                    case "tile.enderchest": {
                        GT_OreDictUnificator.registerOre((Object)OreDictNames.enderChest, new ItemStack(tItem, 1, Short.MAX_VALUE));
                        break;
                    }
                    case "tile.autoWorkbenchBlock": {
                        GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingWorkBench, new ItemStack(tItem, 1, 0));
                        break;
                    }
                    case "tile.pumpBlock": {
                        GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingPump, new ItemStack(tItem, 1, 0));
                        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.disabledrecipes, "BCPump", false)) break;
                        GT_ModHandler.removeRecipeByOutput(new ItemStack(tItem, 1, 0));
                        break;
                    }
                    case "tile.tankBlock": {
                        GT_OreDictUnificator.registerOre((Object)OreDictNames.craftingTank, new ItemStack(tItem, 1, 0));
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

