/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.GT_Mod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.ITextureBuilder;
import gregtech.common.render.GT_CopiedBlockTexture;
import gregtech.common.render.GT_CopiedCTMBlockTexture;
import gregtech.common.render.GT_MultiTexture;
import gregtech.common.render.GT_RenderedTexture;
import gregtech.common.render.GT_SidedTexture;
import gregtech.common.render.GT_TextureBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_TextureBuilder
implements ITextureBuilder {
    private final List<IIconContainer> iconContainerList;
    private final List<ITexture> textureLayers = new ArrayList<ITexture>();
    private Block fromBlock;
    private int fromMeta;
    private ForgeDirection fromSide;
    private short[] rgba;
    private boolean allowAlpha;
    private boolean stdOrient;
    private boolean extFacing;
    private boolean glow;
    private Boolean worldCoord = null;

    public GT_TextureBuilder() {
        this.iconContainerList = new ArrayList<IIconContainer>();
        this.rgba = Dyes._NULL.mRGBa;
        this.allowAlpha = true;
        this.stdOrient = false;
        this.glow = false;
    }

    @Override
    public ITextureBuilder setFromBlock(Block block, int meta) {
        this.fromBlock = block;
        this.fromMeta = meta;
        this.fromSide = ForgeDirection.UNKNOWN;
        return this;
    }

    @Override
    public ITextureBuilder setFromSide(ForgeDirection side) {
        this.fromSide = side;
        return this;
    }

    @Override
    public ITextureBuilder addIcon(IIconContainer ... iconContainers) {
        this.iconContainerList.addAll(Arrays.asList(iconContainers));
        return this;
    }

    @Override
    public ITextureBuilder setRGBA(short[] rgba) {
        this.rgba = rgba;
        return this;
    }

    @Override
    public ITextureBuilder addLayer(ITexture ... iTextures) {
        this.textureLayers.addAll(Arrays.asList(iTextures));
        return this;
    }

    @Override
    public ITextureBuilder setAllowAlpha(boolean allowAlpha) {
        this.allowAlpha = allowAlpha;
        return this;
    }

    @Override
    public ITextureBuilder stdOrient() {
        this.stdOrient = true;
        return this;
    }

    @Override
    public ITextureBuilder useWorldCoord() {
        this.worldCoord = true;
        return this;
    }

    @Override
    public ITextureBuilder noWorldCoord() {
        this.worldCoord = false;
        return this;
    }

    @Override
    public ITextureBuilder extFacing() {
        this.extFacing = true;
        return this;
    }

    @Override
    public ITextureBuilder glow() {
        this.glow = true;
        return this;
    }

    @Override
    public ITexture build() {
        GT_TextureBase gT_TextureBase;
        if (this.fromBlock != null) {
            if (this.worldCoord == Boolean.TRUE || this.worldCoord == null && this.isCTMBlock(this.fromBlock, this.fromMeta)) {
                return new GT_CopiedCTMBlockTexture(this.fromBlock, this.fromSide.ordinal(), this.fromMeta, this.rgba, this.allowAlpha);
            }
            return new GT_CopiedBlockTexture(this.fromBlock, this.fromSide.ordinal(), this.fromMeta, this.rgba, this.allowAlpha);
        }
        if (this.worldCoord != null) {
            throw new IllegalStateException("worldCoord without from block");
        }
        if (!this.textureLayers.isEmpty()) {
            return new GT_MultiTexture(this.textureLayers.toArray(new ITexture[0]));
        }
        switch (this.iconContainerList.size()) {
            case 1: {
                gT_TextureBase = new GT_RenderedTexture(this.iconContainerList.get(0), this.rgba, this.allowAlpha, this.glow, this.stdOrient, this.extFacing);
                break;
            }
            case 6: {
                gT_TextureBase = new GT_SidedTexture(this.iconContainerList.get(ForgeDirection.DOWN.ordinal()), this.iconContainerList.get(ForgeDirection.UP.ordinal()), this.iconContainerList.get(ForgeDirection.NORTH.ordinal()), this.iconContainerList.get(ForgeDirection.SOUTH.ordinal()), this.iconContainerList.get(ForgeDirection.WEST.ordinal()), this.iconContainerList.get(ForgeDirection.EAST.ordinal()), this.rgba, this.allowAlpha);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid sideIconContainer count");
            }
        }
        return gT_TextureBase;
    }

    private boolean isCTMBlock(Block fromBlock, int fromMeta) {
        return GT_Mod.gregtechproxy.mCTMBlockCache.computeIfAbsent(fromBlock, (byte)fromMeta, GT_TextureBuilder::apply);
    }

    private static Boolean apply(Block b, Byte m) {
        for (Class<?> clazz = b.getClass(); clazz != Block.class; clazz = clazz.getSuperclass()) {
            String className = clazz.getName();
            if (GT_Values.mCTMDisabledBlock.contains(className)) {
                return false;
            }
            if (!GT_Values.mCTMEnabledBlock.contains(className)) continue;
            return true;
        }
        return false;
    }
}

