/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gregtech.common.misc.GlobalMetricsCoverDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.PanelSetting;
import shedar.mods.ic2.nuclearcontrol.api.PanelString;

public class GT_AdvancedSensorCard_Item
extends Item
implements IPanelDataSource {
    public static final UUID CARD_TYPE_ID = UUID.fromString("ff952e84-7608-4c4a-85af-dd6e1aa27fc7");
    private static final String SELF_DESTRUCTED_OUTPUT = EnumChatFormatting.OBFUSCATED + "critical error" + EnumChatFormatting.RESET;
    private static final ImmutableList<String> DECONSTRUCTED_OUTPUT = ImmutableList.of((Object)StatCollector.func_74838_a((String)"gt.item.adv_sensor_card.error.deconstructed.1"), (Object)StatCollector.func_74838_a((String)"gt.item.adv_sensor_card.error.deconstructed.2"));
    private static final String NO_DATA_FOUND = StatCollector.func_74838_a((String)"gt.item.adv_sensor_card.error.no_data");
    private static final String MACHINE_NAME_KEY = "client_machine_name";
    private static final String OUTPUT_ENTRY_KEY = "client_entry_%d";
    private static final String OUTPUT_ENTRY_LENGTH_KEY = "client_entry_length";
    private int payloadSize = 0;
    @SideOnly(value=Side.CLIENT)
    private IIcon normalIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon selfDestructedIcon;

    public GT_AdvancedSensorCard_Item() {
        GameRegistry.registerItem((Item)this, (String)"gt.advancedsensorcard", (String)Mods.GregTech.ID);
        this.func_77655_b("gt.advancedsensorcard");
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<String> tooltip, boolean p_77624_4_) {
        super.func_77624_a(itemStack, player, tooltip, p_77624_4_);
        Optional<GlobalMetricsCoverDatabase.State> cardState = this.getCardState(itemStack);
        if (cardState.isPresent()) {
            GlobalMetricsCoverDatabase.State state = cardState.get();
            if (state == GlobalMetricsCoverDatabase.State.SELF_DESTRUCTED) {
                tooltip.add(StatCollector.func_74838_a((String)"gt.item.adv_sensor_card.tooltip.fried.1"));
                tooltip.add(StatCollector.func_74838_a((String)"gt.item.adv_sensor_card.tooltip.fried.2"));
                tooltip.add(StatCollector.func_74838_a((String)"gt.item.adv_sensor_card.tooltip.fried.3"));
            } else {
                this.getMachineName(itemStack).ifPresent(machineName -> tooltip.add(StatCollector.func_74837_a((String)"gt.item.adv_sensor_card.tooltip.machine", (Object[])new Object[]{machineName})));
                this.getUUID(itemStack).ifPresent(uuid -> tooltip.add(StatCollector.func_74837_a((String)"gt.item.adv_sensor_card.tooltip.frequency", (Object[])new Object[]{uuid.toString()})));
            }
        } else {
            tooltip.add(StatCollector.func_74838_a((String)"gt.item.adv_sensor_card.tooltip.recipe_hint"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aCreativeTab, List<ItemStack> aOutputSubItems) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        super.func_94581_a(aIconRegister);
        this.normalIcon = this.field_77791_bV = aIconRegister.func_94245_a(Mods.GregTech.ID + ":gt.advancedsensorcard");
        this.selfDestructedIcon = aIconRegister.func_94245_a(Mods.GregTech.ID + ":gt.advancedsensorcardburned");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack itemStack) {
        return this.getCardState(itemStack).filter(Predicate.isEqual((Object)GlobalMetricsCoverDatabase.State.SELF_DESTRUCTED)).map(ignored -> this.selfDestructedIcon).orElse(this.normalIcon);
    }

    public CardState update(TileEntity tileEntity, ICardWrapper card, int maxRange) {
        return this.update(tileEntity.func_145831_w(), card, maxRange);
    }

    public CardState update(World world, ICardWrapper card, int maxRange) {
        Optional<GlobalMetricsCoverDatabase.Data> optionalData = this.getDataFromDatabase(card);
        optionalData.ifPresent(data -> {
            GlobalMetricsCoverDatabase.State machineState = data.getState();
            this.reconcileSelfDestructedCard(card.getItemStack(), machineState);
            card.setInt("card_state", Integer.valueOf(machineState.getType()));
            this.getMachineName(card.getItemStack()).ifPresent(name -> card.setString(MACHINE_NAME_KEY, machineState == GlobalMetricsCoverDatabase.State.SELF_DESTRUCTED ? "" : name));
            ImmutableList.Builder builder = ImmutableList.builder();
            switch (machineState) {
                case SELF_DESTRUCTED: {
                    builder.add((Object)SELF_DESTRUCTED_OUTPUT);
                    break;
                }
                case HOST_DECONSTRUCTED: {
                    builder.addAll(DECONSTRUCTED_OUTPUT);
                    break;
                }
                case OPERATIONAL: {
                    data.getCoordinates().ifPresent(coordinates -> builder.add((Object[])new String[]{StatCollector.func_74837_a((String)"gt.item.adv_sensor_card.dimension", (Object[])new Object[]{coordinates.getDimension()}), StatCollector.func_74837_a((String)"gt.item.adv_sensor_card.coords", (Object[])new Object[]{coordinates.getLocalizedCoordinates()})}));
                    data.getPayload().ifPresent(arg_0 -> ((ImmutableList.Builder)builder).addAll(arg_0));
                    break;
                }
                default: {
                    builder.add((Object)NO_DATA_FOUND);
                }
            }
            ImmutableList payload = builder.build();
            card.setInt(OUTPUT_ENTRY_LENGTH_KEY, Integer.valueOf(payload.size()));
            for (int i = 0; i < payload.size(); ++i) {
                card.setString(String.format(OUTPUT_ENTRY_KEY, i), (String)payload.get(i));
            }
        });
        return CardState.OK;
    }

    public List<PanelString> getStringData(int displaySettings, ICardWrapper card, boolean showLabels) {
        int bitmaskOffset;
        ArrayList<PanelString> returned = new ArrayList<PanelString>();
        String machineName = card.getString(MACHINE_NAME_KEY);
        this.payloadSize = card.getInt(OUTPUT_ENTRY_LENGTH_KEY);
        if (!machineName.isEmpty() && (displaySettings & 1) != 0) {
            returned.add(GT_AdvancedSensorCard_Item.panelString(machineName, true));
            ++this.payloadSize;
            bitmaskOffset = 1;
        } else {
            bitmaskOffset = 0;
        }
        IntStream.range(0, card.getInt(OUTPUT_ENTRY_LENGTH_KEY)).forEach(i -> {
            if ((displaySettings & 1 << i + bitmaskOffset) != 0) {
                returned.add(GT_AdvancedSensorCard_Item.panelString(card.getString(String.format(OUTPUT_ENTRY_KEY, i))));
            }
        });
        return returned;
    }

    public List<PanelSetting> getSettingsList() {
        return this.payloadSize == 0 ? ImmutableList.of() : ImmutableList.copyOf(IntStream.range(0, Math.min(this.payloadSize, 31)).mapToObj(i -> new PanelSetting(String.valueOf(i + 1), 1 << i, this.getCardType())).iterator());
    }

    public UUID getCardType() {
        return CARD_TYPE_ID;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int slot, boolean isHeld) {
        super.func_77663_a(stack, worldIn, entityIn, slot, isHeld);
        if (worldIn.func_72820_D() % 20L == 13L) {
            this.getDataFromDatabase(stack).ifPresent(data -> {
                this.reconcileSelfDestructedCard(stack, data.getState());
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("card_state", data.getState().getType());
            });
        }
    }

    private void reconcileSelfDestructedCard(ItemStack stack, GlobalMetricsCoverDatabase.State newState) {
        this.getUUID(stack).ifPresent(uuid -> this.getCardState(stack).ifPresent(oldState -> {
            if (newState == GlobalMetricsCoverDatabase.State.SELF_DESTRUCTED && oldState != GlobalMetricsCoverDatabase.State.SELF_DESTRUCTED) {
                GlobalMetricsCoverDatabase.clearSelfDestructedFrequency(uuid);
            }
        }));
    }

    @NotNull
    private Optional<GlobalMetricsCoverDatabase.State> getCardState(ICardWrapper card) {
        return this.getCardState(card.getItemStack());
    }

    @NotNull
    private Optional<GlobalMetricsCoverDatabase.State> getCardState(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("card_state")) {
            return GlobalMetricsCoverDatabase.State.find(itemStack.func_77978_p().func_74762_e("card_state"));
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<UUID> getUUID(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("gt.metricscover.freq_lsb") && nbt.func_74764_b("gt.metricscover.freq_msb")) {
            return Optional.of(new UUID(nbt.func_74763_f("gt.metricscover.freq_msb"), nbt.func_74763_f("gt.metricscover.freq_lsb")));
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<String> getMachineName(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("machine_name")) {
            try {
                ItemStack machine = ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("machine_name"));
                if (machine != null) {
                    return Optional.of(machine.func_82833_r());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @NotNull
    private Optional<GlobalMetricsCoverDatabase.Data> getDataFromDatabase(ICardWrapper card) {
        return this.getDataFromDatabase(card.getItemStack());
    }

    @NotNull
    private Optional<GlobalMetricsCoverDatabase.Data> getDataFromDatabase(ItemStack stack) {
        return this.getUUID(stack).flatMap(GlobalMetricsCoverDatabase::getData);
    }

    @NotNull
    private static PanelString panelString(String info) {
        return GT_AdvancedSensorCard_Item.panelString(info, false);
    }

    @NotNull
    private static PanelString panelString(String info, boolean center) {
        PanelString panelString = new PanelString();
        if (center) {
            panelString.textCenter = info;
        } else {
            panelString.textLeft = info;
        }
        return panelString;
    }
}

