/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.math.MathExpression;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.BaseTextFieldWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.GT_Cover_ItemMeter;
import gregtech.common.covers.redstone.GT_Cover_AdvancedRedstoneTransmitterBase;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_TextFieldWidget;
import gregtech.common.gui.modularui.widget.ItemWatcherSlotWidget;
import gregtech.common.tileentities.storage.GT_MetaTileEntity_DigitalChestBase;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_Cover_WirelessItemDetector
extends GT_Cover_AdvancedRedstoneTransmitterBase<ItemTransmitterData> {
    public GT_Cover_WirelessItemDetector(ITexture coverTexture) {
        super(ItemTransmitterData.class, coverTexture);
    }

    @Override
    public ItemTransmitterData createDataObject() {
        return new ItemTransmitterData();
    }

    @Override
    public ItemTransmitterData createDataObject(int aLegacyData) {
        return this.createDataObject();
    }

    @Override
    public ItemTransmitterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, ItemTransmitterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        byte signal = GT_Cover_ItemMeter.computeSignalBasedOnItems(aTileEntity, aCoverVariable.invert, aCoverVariable.threshold, aCoverVariable.slot, side.ordinal());
        long hash = GT_Cover_WirelessItemDetector.hashCoverCoords(aTileEntity, side);
        GT_Cover_WirelessItemDetector.setSignalAt(aCoverVariable.getUuid(), aCoverVariable.getFrequency(), hash, signal);
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, ItemTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, ItemTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new WirelessItemDetectorUIFactory(buildContext).createWindow();
    }

    public static class ItemTransmitterData
    extends GT_Cover_AdvancedRedstoneTransmitterBase.TransmitterData {
        private int slot;
        private int threshold;

        public ItemTransmitterData(int frequency, UUID uuid, boolean invert, int threshold, int slot) {
            super(frequency, uuid, invert);
            this.threshold = threshold;
            this.slot = slot;
        }

        public ItemTransmitterData() {
            this.threshold = 0;
            this.slot = -1;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new ItemTransmitterData(this.frequency, this.uuid, this.invert, this.threshold, this.slot);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = (NBTTagCompound)super.saveDataToNBT();
            tag.func_74768_a("threshold", this.threshold);
            tag.func_74768_a("slot", this.slot);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            super.writeToByteBuf(aBuf);
            aBuf.writeInt(this.threshold);
            aBuf.writeInt(this.slot);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            super.loadDataFromNBT(aNBT);
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.threshold = tag.func_74762_e("threshold");
            this.slot = tag.func_74762_e("slot");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            super.readFromPacket(aBuf, aPlayer);
            this.threshold = aBuf.readInt();
            this.slot = aBuf.readInt();
            return this;
        }
    }

    private class WirelessItemDetectorUIFactory
    extends GT_Cover_AdvancedRedstoneTransmitterBase.AdvancedRedstoneTransmitterBaseUIFactory {
        private static final String ALL_TEXT = "All";
        private int maxSlot;
        private int maxThreshold;

        public WirelessItemDetectorUIFactory(GT_CoverUIBuildContext buildContext) {
            super(buildContext);
        }

        @Override
        protected int getFrequencyRow() {
            return 0;
        }

        @Override
        protected int getButtonRow() {
            return 1;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            this.setMaxSlot();
            this.setMaxThreshold();
            super.addUIWidgets(builder);
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ItemWatcherSlotWidget().setGetter(this::getTargetItem).setPos(81, 79))).widget(new TextWidget(GT_Utility.trans("221", "Item threshold")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(100, 65))).widget(new TextWidget(GT_Utility.trans("254.0", "Detect Slot")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(100, 83));
        }

        protected void addUIForDataController(CoverDataControllerWidget<ItemTransmitterData> controller) {
            super.addUIForDataController(controller);
            ((CoverDataControllerWidget)controller.addFollower((Widget)new CoverDataFollower_TextFieldWidget(), coverData -> String.valueOf(((ItemTransmitterData)coverData).threshold), (coverData, state) -> {
                ((ItemTransmitterData)coverData).threshold = (int)MathExpression.parseMathExpression((String)state);
                return coverData;
            }, widget -> widget.setOnScrollNumbers(1, 10, 64).setNumbers(0, this.maxThreshold).setPos(1, 38).setSize(86, 12))).addFollower((Widget)new CoverDataFollower_TextFieldWidget(), coverData -> this.getSlotTextFieldContent(((ItemTransmitterData)coverData).slot), (coverData, state) -> {
                ((ItemTransmitterData)coverData).slot = this.getIntFromText((String)state);
                return coverData;
            }, widget -> widget.setOnScrollText().setValidator(val -> {
                int valSlot = this.getIntFromText((String)val);
                if (valSlot > -1) {
                    return widget.getDecimalFormatter().format(Math.min(valSlot, this.maxSlot));
                }
                return ALL_TEXT;
            }).setPattern(BaseTextFieldWidget.NATURAL_NUMS).setPos(1, 56).setSize(64, 12));
        }

        private void setMaxSlot() {
            IGregTechTileEntity gtTile;
            ICoverable tile = this.getUIBuildContext().getTile();
            this.maxSlot = !tile.isDead() && tile instanceof IGregTechTileEntity && !((gtTile = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof GT_MetaTileEntity_DigitalChestBase) ? tile.func_70302_i_() - 1 : -1;
        }

        private void setMaxThreshold() {
            IGregTechTileEntity gtTile;
            ICoverable tile = this.getUIBuildContext().getTile();
            this.maxThreshold = !tile.isDead() && tile instanceof IGregTechTileEntity && (gtTile = (IGregTechTileEntity)tile).getMetaTileEntity() instanceof GT_MetaTileEntity_DigitalChestBase ? gtTile.getMaxItemCount() : (this.maxSlot > 0 ? this.maxSlot * 64 : Integer.MAX_VALUE);
        }

        private int getIntFromText(String text) {
            try {
                return (int)MathExpression.parseMathExpression((String)text, (double)-1.0);
            }
            catch (Exception e) {
                return -1;
            }
        }

        private String getSlotTextFieldContent(int val) {
            return val < 0 ? ALL_TEXT : String.valueOf(val);
        }

        private ItemStack getTargetItem() {
            ICoverable tile = this.getUIBuildContext().getTile();
            ItemTransmitterData coverVariable = (ItemTransmitterData)this.getCoverData();
            if (coverVariable != null && coverVariable.slot >= 0 && tile instanceof TileEntity && !tile.isDead() && tile.func_70302_i_() >= coverVariable.slot) {
                return tile.func_70301_a(coverVariable.slot);
            }
            return null;
        }
    }
}

