/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_SlotWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_ItemFilter
extends GT_CoverBehaviorBase<ItemFilterData> {
    private final boolean mExport;

    @Deprecated
    public GT_Cover_ItemFilter(boolean isExport) {
        this(isExport, null);
    }

    public GT_Cover_ItemFilter(boolean isExport, ITexture coverTexture) {
        super(ItemFilterData.class, coverTexture);
        this.mExport = isExport;
    }

    @Override
    public ItemFilterData createDataObject(int aLegacyData) {
        return new ItemFilterData((aLegacyData & 1) == 0, GT_Utility.intToStack(aLegacyData >>> 1));
    }

    @Override
    public ItemFilterData createDataObject() {
        return new ItemFilterData();
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    protected ItemFilterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        TileEntity tTileEntity = aTileEntity.getTileEntityAtSide(side);
        ICoverable fromEntity = this.mExport ? aTileEntity : tTileEntity;
        ICoverable toEntity = !this.mExport ? aTileEntity : tTileEntity;
        ForgeDirection fromSide = !this.mExport ? side.getOpposite() : side;
        ForgeDirection toSide = this.mExport ? side.getOpposite() : side;
        List<ItemStack> filter = Collections.singletonList(aCoverVariable.mFilter);
        GT_Utility.moveMultipleItemStacks(fromEntity, toEntity, fromSide, toSide, filter, aCoverVariable.mWhitelist, (byte)64, (byte)1, (byte)64, (byte)1, 64);
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        ItemStack tStack = aPlayer.field_71071_by.func_70448_g();
        if (tStack != null) {
            aCoverVariable.mFilter = tStack;
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("299", "Item Filter: ") + tStack.func_82833_r());
        } else {
            aCoverVariable.mFilter = null;
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("300", "Filter Cleared!"));
        }
        return true;
    }

    @Override
    protected ItemFilterData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        aCoverVariable.mWhitelist = !aCoverVariable.mWhitelist;
        GT_Utility.sendChatToPlayer(aPlayer, aCoverVariable.mWhitelist ? GT_Utility.trans("125.1", "Whitelist Mode") : GT_Utility.trans("124.1", "Blacklist Mode"));
        return aCoverVariable;
    }

    @Override
    protected boolean letsRedstoneGoInImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    protected boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return false;
    }

    @Override
    protected boolean letsItemsInImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean alwaysLookConnectedImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, ItemFilterData aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new ItemFilterUIFactory(buildContext).createWindow();
    }

    public static class ItemFilterData
    implements ISerializableObject {
        private boolean mWhitelist;
        private ItemStack mFilter;

        public ItemFilterData() {
        }

        public ItemFilterData(boolean mWhitelist, ItemStack mFilter) {
            this.mWhitelist = mWhitelist;
            this.mFilter = mFilter;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new ItemFilterData(this.mWhitelist, this.mFilter);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("mWhitelist", this.mWhitelist);
            if (this.mFilter != null) {
                tag.func_74782_a("mFilter", (NBTBase)this.mFilter.func_77955_b(new NBTTagCompound()));
            }
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeBoolean(this.mWhitelist);
            ByteBufUtils.writeItemStack((ByteBuf)aBuf, (ItemStack)this.mFilter);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.mWhitelist = tag.func_74767_n("mWhitelist");
            this.mFilter = tag.func_150297_b("mFilter", 10) ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("mFilter")) : null;
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.mWhitelist = aBuf.readBoolean();
            this.mFilter = ISerializableObject.readItemStackFromGreggyByteBuf(aBuf);
            return this;
        }
    }

    private class ItemFilterUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public ItemFilterUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_ItemFilter.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            ItemStackHandler filterInvHandler = new ItemStackHandler(1);
            if (this.getCoverData() != null) {
                filterInvHandler.setStackInSlot(0, this.setStackSize1(((ItemFilterData)this.getCoverData()).mFilter));
            }
            ((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(((CoverDataControllerWidget)new CoverDataControllerWidget<ItemFilterData>(this::getCoverData, this::setCoverData, GT_Cover_ItemFilter.this).addFollower((Widget)new CoverDataFollower_ToggleButtonWidget(), coverData -> ((ItemFilterData)coverData).mWhitelist, (coverData, state) -> {
                ((ItemFilterData)coverData).mWhitelist = state;
                return coverData;
            }, widget -> widget.setToggleTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_BLACKLIST, (IDrawable)GT_UITextures.OVERLAY_BUTTON_WHITELIST).addTooltip(0, GT_Utility.trans("125.1", "Whitelist Mode")).addTooltip(1, GT_Utility.trans("124.1", "Blacklist Mode")).setPos(0, 0))).addFollower((Widget)new CoverDataFollower_SlotWidget((IItemHandlerModifiable)filterInvHandler, 0, true), coverData -> this.setStackSize1(((ItemFilterData)coverData).mFilter), (coverData, stack) -> {
                ((ItemFilterData)coverData).mFilter = this.setStackSize1((ItemStack)stack);
                return coverData;
            }, widget -> widget.setBackground(new IDrawable[]{GT_UITextures.SLOT_DARK_GRAY}).setPos(0, 36)).setPos(10, 25))).widget(new TextWidget(GT_Utility.trans("317", "Filter: ")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(10, 46))).widget(new TextWidget(GT_Utility.trans("318", "Check Mode")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 28));
        }

        private ItemStack setStackSize1(ItemStack stack) {
            if (stack != null) {
                stack.field_77994_a = 1;
            }
            return stack;
        }
    }
}

