/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.MathExpression;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.BaseTextFieldWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_TextFieldWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_FluidRegulator
extends GT_CoverBehaviorBase<FluidRegulatorData> {
    private static final int SPEED_LENGTH = 20;
    private static final int TICK_RATE_LENGTH = 11;
    private static final int TICK_RATE_MIN = 1;
    private static final int TICK_RATE_MAX = 2048;
    private static final int TICK_RATE_BITMASK = 0x7FF00000;
    public final int mTransferRate;
    private boolean allowFluid = false;

    @Deprecated
    public GT_Cover_FluidRegulator(int aTransferRate) {
        this(aTransferRate, null);
    }

    public GT_Cover_FluidRegulator(int aTransferRate, ITexture coverTexture) {
        super(FluidRegulatorData.class, coverTexture);
        if (aTransferRate > 1048575) {
            throw new IllegalArgumentException("aTransferRate too big: " + aTransferRate);
        }
        this.mTransferRate = aTransferRate;
    }

    @Override
    public FluidRegulatorData createDataObject(int aLegacyData) {
        return new FluidRegulatorData(aLegacyData);
    }

    @Override
    public FluidRegulatorData createDataObject() {
        return new FluidRegulatorData();
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return aCoverVariable.condition.isRedstoneSensitive();
    }

    @Override
    protected FluidRegulatorData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable.speed == 0 || !aCoverVariable.condition.isAllowedToWork(side, aCoverID, aTileEntity)) {
            return aCoverVariable;
        }
        if (aTileEntity instanceof IFluidHandler) {
            ForgeDirection directionTo;
            ForgeDirection directionFrom;
            IFluidHandler tTank1;
            IFluidHandler tTank2;
            if (aCoverVariable.speed > 0) {
                tTank2 = aTileEntity.getITankContainerAtSide(side);
                tTank1 = (IFluidHandler)aTileEntity;
                directionFrom = side;
                directionTo = side.getOpposite();
            } else {
                tTank1 = aTileEntity.getITankContainerAtSide(side);
                tTank2 = (IFluidHandler)aTileEntity;
                directionFrom = side.getOpposite();
                directionTo = side;
            }
            if (tTank1 != null && tTank2 != null) {
                this.allowFluid = true;
                FluidStack tLiquid = tTank1.drain(directionFrom, Math.abs(aCoverVariable.speed), false);
                if (tLiquid != null && this.canTransferFluid(tLiquid)) {
                    tLiquid = tLiquid.copy();
                    tLiquid.amount = tTank2.fill(directionTo, tLiquid, false);
                    if (tLiquid.amount > 0) {
                        tTank2.fill(directionTo, tTank1.drain(directionFrom, tLiquid.amount, true), true);
                    }
                }
                this.allowFluid = false;
            }
        }
        return aCoverVariable;
    }

    private void adjustSpeed(EntityPlayer aPlayer, FluidRegulatorData aCoverVariable, int scale) {
        int tSpeed = aCoverVariable.speed;
        int tTickRate = aCoverVariable.tickRate;
        if (Math.abs(tSpeed += scale) > this.mTransferRate * tTickRate) {
            tSpeed = this.mTransferRate * tTickRate * (tSpeed > 0 ? 1 : -1);
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("316", "Pump speed limit reached!"));
        }
        if (tTickRate == 1) {
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("048", "Pump speed: ") + tSpeed + GT_Utility.trans("049", "L/tick ") + tSpeed * 20 + GT_Utility.trans("050", "L/sec"));
        } else {
            GT_Utility.sendChatToPlayer(aPlayer, String.format(GT_Utility.trans("207", "Pump speed: %dL every %d ticks, %.2f L/sec on average"), tSpeed, tTickRate, (double)tSpeed * 20.0 / (double)tTickRate));
        }
    }

    @Override
    public FluidRegulatorData onCoverScrewdriverClickImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Utility.getClickedFacingCoords(side, aX, aY, aZ)[0] >= 0.5f) {
            this.adjustSpeed(aPlayer, aCoverVariable, aPlayer.func_70093_af() ? 256 : 16);
        } else {
            this.adjustSpeed(aPlayer, aCoverVariable, aPlayer.func_70093_af() ? -256 : -16);
        }
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (GT_Utility.getClickedFacingCoords(side, aX, aY, aZ)[0] >= 0.5f) {
            this.adjustSpeed(aPlayer, aCoverVariable, 1);
        } else {
            this.adjustSpeed(aPlayer, aCoverVariable, -1);
        }
        return true;
    }

    protected boolean canTransferFluid(FluidStack fluid) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoInImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyInImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOutImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsInImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOutImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidInImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.allowFluid;
    }

    @Override
    public boolean letsFluidOutImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return this.allowFluid;
    }

    @Override
    protected boolean alwaysLookConnectedImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(ForgeDirection side, int aCoverID, FluidRegulatorData aCoverVariable, ICoverable aTileEntity) {
        return aCoverVariable.tickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new FluidRegulatorUIFactory(buildContext).createWindow();
    }

    @Override
    public boolean allowsTickRateAddition() {
        return false;
    }

    public static class FluidRegulatorData
    implements ISerializableObject {
        private int tickRate;
        private int speed;
        private Conditional condition;

        private static int getSpeed(int aCoverVariable) {
            return aCoverVariable >= 0 ? aCoverVariable & 0x800FFFFF : aCoverVariable | 0x7FF00000;
        }

        private static int getTickRate(int aCoverVariable) {
            return ((Math.abs(aCoverVariable) & 0x7FF00000) >>> 20) + 1;
        }

        public FluidRegulatorData() {
            this(0);
        }

        public FluidRegulatorData(int legacy) {
            this(FluidRegulatorData.getTickRate(legacy), FluidRegulatorData.getSpeed(legacy), Conditional.Always);
        }

        public FluidRegulatorData(int tickRate, int speed, Conditional condition) {
            this.tickRate = tickRate;
            this.speed = speed;
            this.condition = condition;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new FluidRegulatorData(this.tickRate, this.speed, this.condition);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("mSpeed", this.speed);
            tag.func_74768_a("mTickRate", this.tickRate);
            tag.func_74774_a("mCondition", (byte)this.condition.ordinal());
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeInt(this.tickRate).writeInt(this.speed).writeByte(this.condition.ordinal());
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            if (!(aNBT instanceof NBTTagCompound)) {
                return;
            }
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.speed = tag.func_74762_e("mSpeed");
            this.tickRate = tag.func_74762_e("mTickRate");
            this.condition = Conditional.VALUES[tag.func_74771_c("mCondition")];
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, @Nullable EntityPlayerMP aPlayer) {
            return new FluidRegulatorData(aBuf.readInt(), aBuf.readInt(), Conditional.VALUES[aBuf.readUnsignedByte()]);
        }

        public int getTickRate() {
            return this.tickRate;
        }

        public void setTickRate(int tickRate) {
            this.tickRate = tickRate;
        }

        public int getSpeed() {
            return this.speed;
        }

        public void setSpeed(int speed) {
            this.speed = speed;
        }

        public Conditional getCondition() {
            return this.condition;
        }

        public void setCondition(Conditional condition) {
            this.condition = condition;
        }
    }

    public static enum Conditional {
        Always(false){

            @Override
            boolean isAllowedToWork(ForgeDirection side, int aCoverID, ICoverable aTileEntity) {
                return true;
            }
        }
        ,
        Conditional(true){

            @Override
            boolean isAllowedToWork(ForgeDirection side, int aCoverID, ICoverable aTileEntity) {
                return !(aTileEntity instanceof IMachineProgress) || ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork();
            }
        }
        ,
        Inverted(true){

            @Override
            boolean isAllowedToWork(ForgeDirection side, int aCoverID, ICoverable aTileEntity) {
                return !(aTileEntity instanceof IMachineProgress) || !((IMachineProgress)((Object)aTileEntity)).isAllowedToWork();
            }
        };

        static final Conditional[] VALUES;
        private final boolean redstoneSensitive;

        private Conditional(boolean redstoneSensitive) {
            this.redstoneSensitive = redstoneSensitive;
        }

        abstract boolean isAllowedToWork(ForgeDirection var1, int var2, ICoverable var3);

        boolean isRedstoneSensitive() {
            return this.redstoneSensitive;
        }

        static {
            VALUES = gregtech.common.covers.GT_Cover_FluidRegulator$Conditional.values();
        }
    }

    private class FluidRegulatorUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;

        public FluidRegulatorUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_FluidRegulator.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            AtomicBoolean warn = new AtomicBoolean(false);
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(((CoverDataControllerWidget)((CoverDataControllerWidget)((CoverDataControllerWidget)((CoverDataControllerWidget)((CoverDataControllerWidget)((CoverDataControllerWidget)new CoverDataControllerWidget<FluidRegulatorData>(this::getCoverData, this::setCoverData, GT_Cover_FluidRegulator.this).addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofDisableable(), coverData -> ((FluidRegulatorData)coverData).speed >= 0, (coverData, state) -> {
                ((FluidRegulatorData)coverData).speed = Math.abs(((FluidRegulatorData)coverData).speed);
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GT_Utility.trans("006", "Export")).setPos(0, 0))).addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofDisableable(), coverData -> ((FluidRegulatorData)coverData).speed <= 0, (coverData, state) -> {
                ((FluidRegulatorData)coverData).speed = -Math.abs(((FluidRegulatorData)coverData).speed);
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GT_Utility.trans("007", "Import")).setPos(18, 0))).addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofDisableable(), coverData -> ((FluidRegulatorData)coverData).condition == Conditional.Always, (coverData, state) -> {
                ((FluidRegulatorData)coverData).condition = Conditional.Always;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_CHECKMARK).addTooltip(GT_Utility.trans("224", "Always On")).setPos(0, 18))).addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofDisableable(), coverData -> ((FluidRegulatorData)coverData).condition == Conditional.Conditional, (coverData, state) -> {
                ((FluidRegulatorData)coverData).condition = Conditional.Conditional;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_USE_PROCESSING_STATE).addTooltip(GT_Utility.trans("343", "Use Machine Processing State")).setPos(18, 18))).addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofDisableable(), coverData -> ((FluidRegulatorData)coverData).condition == Conditional.Inverted, (coverData, state) -> {
                ((FluidRegulatorData)coverData).condition = Conditional.Inverted;
                return coverData;
            }, widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_USE_INVERTED_PROCESSING_STATE).addTooltip(GT_Utility.trans("343.1", "Use Inverted Machine Processing State")).setPos(36, 18))).addFollower((Widget)new CoverDataFollower_TextFieldWidget(), coverData -> String.valueOf(((FluidRegulatorData)coverData).speed), (coverData, state) -> {
                ((FluidRegulatorData)coverData).speed = (int)MathExpression.parseMathExpression((String)state);
                return coverData;
            }, widget -> widget.setOnScrollNumbersLong(1L, 5L, 50L).setNumbersLong(val -> {
                int tickRate = this.getCoverData() != null ? ((FluidRegulatorData)this.getCoverData()).tickRate : 0;
                long maxFlow = (long)GT_Cover_FluidRegulator.this.mTransferRate * (long)GT_Utility.clamp(tickRate, 1, 2048);
                warn.set(false);
                if (val > maxFlow) {
                    val = maxFlow;
                    warn.set(true);
                } else if (val < -maxFlow) {
                    val = -maxFlow;
                    warn.set(true);
                }
                return val;
            }).setPattern(BaseTextFieldWidget.WHOLE_NUMS).setFocusOnGuiOpen(true).setPos(0, 38).setSize(69, 12))).addFollower((Widget)new CoverDataFollower_TextFieldWidget(), coverData -> String.valueOf(((FluidRegulatorData)coverData).tickRate), (coverData, state) -> {
                ((FluidRegulatorData)coverData).tickRate = (int)MathExpression.parseMathExpression((String)state);
                return coverData;
            }, widget -> widget.setOnScrollNumbersLong(1L, 5L, 50L).setNumbersLong(val -> {
                int speed = this.getCoverData() != null ? ((FluidRegulatorData)this.getCoverData()).speed : 0;
                warn.set(false);
                if (val > 2048L) {
                    val = 2048L;
                    warn.set(true);
                } else if ((long)Math.abs(speed) > (long)GT_Cover_FluidRegulator.this.mTransferRate * val) {
                    val = Math.min(2048, (Math.abs(speed) + GT_Cover_FluidRegulator.this.mTransferRate - 1) / GT_Cover_FluidRegulator.this.mTransferRate);
                    warn.set(true);
                } else if (val < 1L) {
                    val = 1L;
                }
                return val;
            }).setPattern(BaseTextFieldWidget.WHOLE_NUMS).setPos(90, 38).setSize(33, 12)).setPos(10, 25))).widget(new TextWidget(GT_Utility.trans("229", "Export/Import")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(85, 29))).widget(new TextWidget(GT_Utility.trans("230", "Conditional")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(85, 47))).widget(new TextWidget(GT_Utility.trans("208", " L")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(82, 65))).widget(new TextWidget(GT_Utility.trans("209", " ticks")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(136, 65))).widget(TextWidget.dynamicText(() -> {
                FluidRegulatorData coverVariable = (FluidRegulatorData)this.getCoverData();
                if (coverVariable == null) {
                    return new Text("");
                }
                return new Text(String.format(GT_Utility.trans("210", "Average: %.2f L/sec"), coverVariable.tickRate == 0 ? 0.0 : (double)coverVariable.speed * 20.0 / (double)coverVariable.tickRate)).color((warn.get() ? (Integer)this.COLOR_TEXT_WARN.get() : (Integer)this.COLOR_TEXT_GRAY.get()).intValue());
            }).setSynced(false).setPos(10, 83));
        }
    }
}

