/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.MathExpression;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.BaseTextFieldWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_TextFieldWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class GT_Cover_Arm
extends GT_CoverBehavior {
    public final int mTickRate;
    protected static final int EXPORT_MASK = 0x40000000;
    protected static final int SLOT_ID_MASK = 16383;
    protected static final int SLOT_ID_MIN = 0;
    protected static final int CONVERTED_BIT = Integer.MIN_VALUE;
    private static final String ANY_TEXT = "Any";

    @Deprecated
    public GT_Cover_Arm(int aTickRate) {
        this(aTickRate, null);
    }

    public GT_Cover_Arm(int aTickRate, ITexture coverTexture) {
        super(coverTexture);
        this.mTickRate = aTickRate;
    }

    @Override
    public boolean isRedstoneSensitive(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        int toSlot;
        int fromSlot;
        TileEntity toTile;
        TileEntity fromTile;
        if (aTileEntity instanceof IMachineProgress && !((IMachineProgress)((Object)aTileEntity)).isAllowedToWork()) {
            return aCoverVariable;
        }
        if (aCoverVariable >>> 29 == 0) {
            aCoverVariable = Integer.MIN_VALUE | (aCoverVariable + 1 & 0x3FFF) << 14 | 0x40000000;
        } else if (aCoverVariable >>> 29 == 7) {
            aCoverVariable = Integer.MIN_VALUE | Math.min(Math.abs(aCoverVariable - 1), 16383);
        }
        if ((aCoverVariable & 0x40000000) > 0) {
            fromTile = (TileEntity)aTileEntity;
            toTile = aTileEntity.getTileEntityAtSide(side);
            fromSlot = aCoverVariable & 0x3FFF;
            toSlot = aCoverVariable >> 14 & 0x3FFF;
        } else {
            fromTile = aTileEntity.getTileEntityAtSide(side);
            toTile = (TileEntity)aTileEntity;
            fromSlot = aCoverVariable >> 14 & 0x3FFF;
            toSlot = aCoverVariable & 0x3FFF;
        }
        if (fromSlot > 0 && toSlot > 0) {
            if (fromTile instanceof IInventory) {
                IInventory fromInventory = (IInventory)fromTile;
                if (toTile instanceof IInventory) {
                    IInventory toInventory = (IInventory)toTile;
                    GT_Utility.moveFromSlotToSlot(fromInventory, toInventory, fromSlot - 1, toSlot - 1, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
                }
            }
        } else if (toSlot > 0) {
            ForgeDirection toSide = (aCoverVariable & 0x40000000) > 0 ? side : side.getOpposite();
            GT_Utility.moveOneItemStackIntoSlot(fromTile, toTile, toSide, toSlot - 1, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
        } else if (fromSlot > 0) {
            ForgeDirection toSide = (aCoverVariable & 0x40000000) > 0 ? side : side.getOpposite();
            if (fromTile instanceof IInventory) {
                GT_Utility.moveFromSlotToSide((IInventory)fromTile, toTile, fromSlot - 1, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        } else {
            ForgeDirection toSide;
            ForgeDirection fromSide;
            if ((aCoverVariable & 0x40000000) > 0) {
                fromSide = side;
                toSide = side.getOpposite();
            } else {
                fromSide = side.getOpposite();
                toSide = side;
            }
            GT_Utility.moveOneItemStack(fromTile, toTile, fromSide, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1);
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int step = 0;
        step = GT_Utility.getClickedFacingCoords(side, aX, aY, aZ)[0] >= 0.5f ? (step += aPlayer.func_70093_af() ? 256 : 16) : (step -= aPlayer.func_70093_af() ? 256 : 16);
        aCoverVariable = this.getNewVar(aCoverVariable, step);
        this.sendMessageToPlayer(aPlayer, aCoverVariable);
        return aCoverVariable;
    }

    @Override
    protected boolean onCoverRightClickImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int step = GT_Utility.getClickedFacingCoords(side, aX, aY, aZ)[0] >= 0.5f ? 1 : -1;
        int tCoverVariable = this.getNewVar(aCoverVariable.get(), step);
        this.sendMessageToPlayer(aPlayer, tCoverVariable);
        aCoverVariable.set(tCoverVariable);
        return true;
    }

    @Override
    public boolean onCoverRightclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int step = GT_Utility.getClickedFacingCoords(side, aX, aY, aZ)[0] >= 0.5f ? 1 : -1;
        aCoverVariable = this.getNewVar(aCoverVariable, step);
        this.sendMessageToPlayer(aPlayer, aCoverVariable);
        aTileEntity.setCoverDataAtSide(side, aCoverVariable);
        return true;
    }

    @Override
    protected boolean isGUIClickableImpl(ForgeDirection side, int aCoverID, ISerializableObject.LegacyCoverData aCoverVariable, ICoverable aTileEntity) {
        return false;
    }

    private void sendMessageToPlayer(EntityPlayer aPlayer, int var) {
        if ((var & 0x40000000) != 0) {
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("001", "Puts out into adjacent Slot #") + ((var >> 14 & 0x3FFF) - 1));
        } else {
            GT_Utility.sendChatToPlayer(aPlayer, GT_Utility.trans("002", "Grabs in for own Slot #") + ((var & 0x3FFF) - 1));
        }
    }

    private int getNewVar(int var, int step) {
        int intSlot = var & 0x3FFF;
        int adjSlot = var >> 14 & 0x3FFF;
        if ((var & 0x40000000) == 0) {
            int x = intSlot + step;
            if (x > 16383) {
                return this.createVar(0, 16383, 0);
            }
            if (x < 1) {
                return this.createVar(-step - intSlot + 1, 0, 0x40000000);
            }
            return this.createVar(0, x, 0);
        }
        int x = adjSlot - step;
        if (x > 16383) {
            return this.createVar(16383, 0, 0x40000000);
        }
        if (x < 1) {
            return this.createVar(0, step - adjSlot + 1, 0);
        }
        return this.createVar(x, 0, 0x40000000);
    }

    private int createVar(int adjSlot, int intSlot, int export) {
        return Integer.MIN_VALUE | export | (adjSlot & 0x3FFF) << 14 | intSlot & 0x3FFF;
    }

    @Override
    public boolean letsRedstoneGoIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyIn(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsEnergyOut(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsIn(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean letsItemsOut(ForgeDirection side, int aCoverID, int aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public boolean alwaysLookConnected(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return this.mTickRate;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new ArmUIFactory(buildContext).createWindow();
    }

    private class ArmUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private int maxSlot;

        protected ArmUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_Arm.this, buildContext);
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            this.maxSlot = this.getMaxSlot();
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(((CoverDataControllerWidget)((CoverDataControllerWidget)((CoverDataControllerWidget)new CoverDataControllerWidget<ISerializableObject.LegacyCoverData>(this::getCoverData, this::setCoverData, GT_Cover_Arm.this).addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofDisableable(), coverData -> this.getFlagExport(GT_Cover_Arm.convert(coverData)) > 0, (coverData, state) -> {
                if (state.booleanValue()) {
                    return new ISerializableObject.LegacyCoverData(GT_Cover_Arm.convert(coverData) | 0x40000000 | Integer.MIN_VALUE);
                }
                return new ISerializableObject.LegacyCoverData(GT_Cover_Arm.convert(coverData) & 0xBFFFFFFF | Integer.MIN_VALUE);
            }, widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GT_Utility.trans("006", "Export")).setPos(0, 0))).addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofDisableable(), coverData -> this.getFlagExport(GT_Cover_Arm.convert(coverData)) == 0, (coverData, state) -> {
                if (state.booleanValue()) {
                    return new ISerializableObject.LegacyCoverData(GT_Cover_Arm.convert(coverData) & 0xBFFFFFFF | Integer.MIN_VALUE);
                }
                return new ISerializableObject.LegacyCoverData(GT_Cover_Arm.convert(coverData) | 0x40000000 | Integer.MIN_VALUE);
            }, widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GT_Utility.trans("007", "Import")).setPos(18, 0))).addFollower((Widget)new CoverDataFollower_TextFieldWidget(), coverData -> this.getTextFieldContent(this.getFlagInternalSlot(GT_Cover_Arm.convert(coverData)) - 1), (coverData, state) -> {
                int coverVariable = GT_Cover_Arm.convert(coverData);
                return new ISerializableObject.LegacyCoverData(this.getFlagExport(coverVariable) | this.getIntFromText((String)state) + 1 & 0x3FFF | this.getFlagAdjacentSlot(coverVariable) << 14 | Integer.MIN_VALUE);
            }, widget -> widget.setOnScrollText().setValidator(val -> {
                int valSlot = this.getIntFromText((String)val);
                if (valSlot > -1) {
                    return widget.getDecimalFormatter().format(Math.min(valSlot, this.maxSlot));
                }
                return GT_Cover_Arm.ANY_TEXT;
            }).setPattern(BaseTextFieldWidget.NATURAL_NUMS).setFocusOnGuiOpen(true).setPos(0, 20).setSize(41, 12))).addFollower((Widget)new CoverDataFollower_TextFieldWidget(), coverData -> this.getTextFieldContent(this.getFlagAdjacentSlot(GT_Cover_Arm.convert(coverData)) - 1), (coverData, state) -> {
                int coverVariable = GT_Cover_Arm.convert(coverData);
                return new ISerializableObject.LegacyCoverData(this.getFlagExport(coverVariable) | this.getFlagInternalSlot(coverVariable) | (this.getIntFromText((String)state) + 1 & 0x3FFF) << 14 | Integer.MIN_VALUE);
            }, widget -> widget.setValidator(val -> {
                TileEntity adj;
                int valSlot = this.getIntFromText((String)val);
                ICoverable tile = this.getUIBuildContext().getTile();
                int adjacentMaxSlot = tile instanceof TileEntity && !tile.isDead() ? ((adj = tile.getTileEntityAtSide(this.getUIBuildContext().getCoverSide())) instanceof IInventory ? ((IInventory)adj).func_70302_i_() - 1 : -1) : -1;
                if (valSlot > -1) {
                    return widget.getDecimalFormatter().format(Math.min(valSlot, adjacentMaxSlot));
                }
                return GT_Cover_Arm.ANY_TEXT;
            }).setOnScroll((text, direction) -> {
                int val = this.getIntFromText((String)text);
                int step = (GuiScreen.func_146272_n() ? 50 : (GuiScreen.func_146271_m() ? 5 : 1)) * direction;
                return widget.getDecimalFormatter().format(val + step);
            }).setPattern(BaseTextFieldWidget.NATURAL_NUMS).setPos(0, 38).setSize(41, 12)).setPos(10, 25))).widget(TextWidget.dynamicString(() -> (GT_Cover_Arm.convert((ISerializableObject.LegacyCoverData)this.getCoverData()) & 0x40000000) > 0 ? GT_Utility.trans("006", "Export") : GT_Utility.trans("007", "Import")).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 29))).widget(new TextWidget(GT_Utility.trans("254.1", "Internal slot#")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 47))).widget(new TextWidget(GT_Utility.trans("255", "Adjacent slot#")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(64, 65));
        }

        private int getMaxSlot() {
            ICoverable tile = this.getUIBuildContext().getTile();
            if (tile instanceof TileEntity && !tile.isDead()) {
                return tile.func_70302_i_() - 1;
            }
            return -1;
        }

        private String getTextFieldContent(int val) {
            return val < 0 ? GT_Cover_Arm.ANY_TEXT : String.valueOf(val);
        }

        private int getIntFromText(String text) {
            try {
                return (int)MathExpression.parseMathExpression((String)text, (double)-1.0);
            }
            catch (Exception e) {
                return -1;
            }
        }

        private int getFlagExport(int coverVariable) {
            return coverVariable & 0x40000000;
        }

        private int getFlagInternalSlot(int coverVariable) {
            return coverVariable & 0x3FFF;
        }

        private int getFlagAdjacentSlot(int coverVariable) {
            return coverVariable >> 14 & 0x3FFF;
        }
    }
}

