/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import appeng.util.ReadableNumberConverter;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import gregtech.nei.GT_NEI_DefaultHandler;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpaceProjectFrontend
extends RecipeMapFrontend {
    IDrawable projectTexture;

    public SpaceProjectFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder);
    }

    @Override
    public ModularWindow.Builder createNEITemplate(IItemHandlerModifiable itemInputsInventory, IItemHandlerModifiable itemOutputsInventory, IItemHandlerModifiable specialSlotInventory, IItemHandlerModifiable fluidInputsInventory, IItemHandlerModifiable fluidOutputsInventory, Supplier<Float> progressSupplier, Pos2d windowOffset) {
        ModularWindow.Builder builder = super.createNEITemplate(itemInputsInventory, itemOutputsInventory, specialSlotInventory, fluidInputsInventory, fluidOutputsInventory, progressSupplier, windowOffset);
        builder.widget(new DrawableWidget().setDrawable(() -> this.projectTexture).setSize(18, 18).setPos(new Pos2d(124, 28).add(windowOffset)));
        return builder;
    }

    @Override
    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return UIHelper.getGridPositions(itemInputCount, 16, 28, 3);
    }

    @Override
    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions(fluidInputCount, 88, 28, 1);
    }

    @Override
    protected List<String> handleNEIItemInputTooltip(List<String> currentTip, GT_NEI_DefaultHandler.FixedPositionedStack pStack) {
        super.handleNEIItemOutputTooltip(currentTip, pStack);
        if (pStack.isFluid()) {
            return currentTip;
        }
        currentTip.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"Item Count: ") + GT_Utility.formatNumbers(pStack.realStackSize));
        return currentTip;
    }

    @Override
    public void drawNEIOverlays(GT_NEI_DefaultHandler.CachedDefaultRecipe neiCachedRecipe) {
        ISpaceProject project;
        for (PositionedStack stack : neiCachedRecipe.mInputs) {
            if (!(stack instanceof GT_NEI_DefaultHandler.FixedPositionedStack)) continue;
            GT_NEI_DefaultHandler.FixedPositionedStack pStack = (GT_NEI_DefaultHandler.FixedPositionedStack)stack;
            if (stack.item == null || pStack.isFluid()) continue;
            int stackSize = ((GT_NEI_DefaultHandler.FixedPositionedStack)stack).realStackSize;
            String displayString = stack.item.field_77994_a > 9999 ? ReadableNumberConverter.INSTANCE.toWideReadableForm((long)stackSize) : String.valueOf(stackSize);
            this.drawNEIOverlayText(displayString, stack, 0xFFFFFF, 0.5f, true, Alignment.BottomRight);
        }
        if (neiCachedRecipe.mRecipe instanceof SpaceProjectManager.FakeSpaceProjectRecipe && (project = SpaceProjectManager.getProject(((SpaceProjectManager.FakeSpaceProjectRecipe)neiCachedRecipe.mRecipe).projectName)) != null) {
            this.projectTexture = project.getTexture();
            GuiDraw.drawStringC((String)(EnumChatFormatting.BOLD + project.getLocalizedName()), (int)85, (int)0, (int)0x404040, (boolean)false);
        }
    }

    @Override
    public void addProgressBar(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
        int bar1Width = 17;
        int bar2Width = 18;
        List<Supplier<Float>> splitProgress = SpaceProjectFrontend.splitProgress(progressSupplier, bar1Width, bar2Width);
        builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_1, 17).setDirection(ProgressBar.Direction.RIGHT).setProgress(splitProgress.get(0)).setSynced(false, false).setPos(new Pos2d(70, 28).add(windowOffset)).setSize(bar1Width, 72));
        builder.widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ASSEMBLY_LINE_2, 18).setDirection(ProgressBar.Direction.RIGHT).setProgress(splitProgress.get(1)).setSynced(false, false).setPos(new Pos2d(106, 28).add(windowOffset)).setSize(bar2Width, 72));
    }
}

