/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe;

import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.recipe.HandlerInfo;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.FieldsAreNonnullByDefault;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public final class RecipeCategory {
    public static final Map<String, RecipeCategory> ALL_RECIPE_CATEGORIES = new HashMap<String, RecipeCategory>();
    public final String unlocalizedName;
    public final RecipeMap<?> recipeMap;
    public final ModContainer ownerMod;
    @Nullable
    public final UnaryOperator<HandlerInfo.Builder> handlerInfoCreator;

    public RecipeCategory(String unlocalizedName, RecipeMap<?> recipeMap, @Nullable UnaryOperator<HandlerInfo.Builder> handlerInfoCreator) {
        this.unlocalizedName = unlocalizedName;
        this.recipeMap = recipeMap;
        this.ownerMod = Loader.instance().activeModContainer();
        this.handlerInfoCreator = handlerInfoCreator;
        if (ALL_RECIPE_CATEGORIES.containsKey(unlocalizedName)) {
            throw new IllegalArgumentException("Cannot register recipe category with duplicated unlocalized name: " + unlocalizedName);
        }
        ALL_RECIPE_CATEGORIES.put(unlocalizedName, this);
    }

    RecipeCategory(RecipeMap<?> recipeMap) {
        this(recipeMap.unlocalizedName, recipeMap, recipeMap.getFrontend().neiProperties.handlerInfoCreator);
    }

    public String toString() {
        return "RecipeCategory{unlocalizedName='" + this.unlocalizedName + '\'' + ", recipeMap=" + this.recipeMap.unlocalizedName + ", ownerMod=" + this.ownerMod.getModId() + '}';
    }

    public static DrawableResource createIcon(String resourceLocation) {
        return new DrawableBuilder(resourceLocation, 0, 0, 16, 16).addPadding(-1, 0, -1, 0).setTextureSize(16, 16).build();
    }
}

