/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.GT_Mod;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class OverclockDescriber {
    protected final byte tier;

    public OverclockDescriber(byte tier) {
        this.tier = tier;
    }

    public final byte getTier() {
        return this.tier;
    }

    public abstract String getTierString();

    public abstract GT_OverclockCalculator createCalculator(GT_OverclockCalculator var1, GT_Recipe var2);

    public abstract void drawEnergyInfo(RecipeDisplayInfo var1);

    public void drawDurationInfo(RecipeDisplayInfo recipeInfo) {
        if (this.getDurationTicks(recipeInfo.calculator) <= 0) {
            return;
        }
        String textToDraw = GT_Utility.trans("158", "Time: ");
        if (GT_Mod.gregtechproxy.mNEIRecipeSecondMode) {
            textToDraw = textToDraw + this.getDurationStringSeconds(recipeInfo.calculator);
            if (this.getDurationSeconds(recipeInfo.calculator) <= 1.0) {
                textToDraw = textToDraw + String.format(" (%s)", this.getDurationStringTicks(recipeInfo.calculator));
            }
        } else {
            textToDraw = textToDraw + this.getDurationStringTicks(recipeInfo.calculator);
        }
        recipeInfo.drawText(textToDraw);
    }

    public boolean canHandle(GT_Recipe recipe) {
        byte tier = GT_Utility.getTier(recipe.mEUt);
        return this.tier >= tier;
    }

    private int getDurationTicks(GT_OverclockCalculator calculator) {
        return calculator.getDuration();
    }

    private double getDurationSeconds(GT_OverclockCalculator calculator) {
        return 0.05 * (double)this.getDurationTicks(calculator);
    }

    private String getDurationStringSeconds(GT_OverclockCalculator calculator) {
        return GT_Utility.formatNumbers(this.getDurationSeconds(calculator)) + GT_Utility.trans("161", " secs");
    }

    private String getDurationStringTicks(GT_OverclockCalculator calculator) {
        String ticksString = this.getDurationTicks(calculator) == 1 ? GT_Utility.trans("209.1", " tick") : GT_Utility.trans("209", " ticks");
        return GT_Utility.formatNumbers(this.getDurationTicks(calculator)) + ticksString;
    }
}

