/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class GT_LockedWhileActiveButton
extends ButtonWidget {
    @NotNull
    private final IMachineProgress machine;

    public GT_LockedWhileActiveButton(@NotNull IMachineProgress machine, @NotNull ModularWindow.Builder builder) {
        this.machine = machine;
        super.attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(machine::isActive, a -> {}), (IWidgetBuilder)builder, (widget, aBoolean) -> widget.notifyTooltipChange());
        super.dynamicTooltip(this::generateTooltip);
    }

    @NotNull
    public ButtonWidget setOnClick(@NotNull BiConsumer<Widget.ClickData, Widget> clickAction) {
        return super.setOnClick((clickData, widget) -> {
            if (!this.machine.isActive()) {
                clickAction.accept((Widget.ClickData)clickData, (Widget)widget);
            }
        });
    }

    @NotNull
    public Widget setBackground(IDrawable ... drawables) {
        return super.setBackground(() -> this.appendLockedOverlay(drawables));
    }

    @NotNull
    public Widget setBackground(@NotNull Supplier<IDrawable[]> drawablesSupplier) {
        return super.setBackground(() -> this.appendLockedOverlay((IDrawable[])drawablesSupplier.get()));
    }

    @NotNull
    public Widget dynamicTooltip(@NotNull Supplier<List<String>> dynamicTooltip) {
        return super.dynamicTooltip(() -> {
            ImmutableList.Builder tooltips = ImmutableList.builder().addAll((Iterable)dynamicTooltip.get());
            tooltips.addAll(this.generateTooltip());
            return tooltips.build();
        });
    }

    @NotNull
    private IDrawable[] appendLockedOverlay(@NotNull IDrawable[] drawables) {
        if (this.machine.isActive()) {
            IDrawable[] copy = Arrays.copyOf(drawables, drawables.length + 1);
            copy[drawables.length] = GT_UITextures.OVERLAY_BUTTON_LOCKED;
            return copy;
        }
        return drawables;
    }

    @NotNull
    private List<String> generateTooltip() {
        if (this.machine.isActive()) {
            return ImmutableList.of((Object)StatCollector.func_74838_a((String)"GT5U.gui.button.forbidden_while_running"));
        }
        return ImmutableList.of();
    }
}

