/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.task;

import java.util.HashMap;
import ru.timeconqueror.lootgames.api.task.ITask;
import ru.timeconqueror.timecore.api.exception.NotExistsException;

public abstract class TaskRegistry {
    private static final HashMap<Class<? extends ITask>, ITask.ITaskFactory<?>> TASK_FACTORIES = new HashMap();

    public static <T extends ITask> T createTask(Class<T> taskClass) throws NotExistsException {
        ITask.ITaskFactory<?> factory = TASK_FACTORIES.get(taskClass);
        if (factory == null) {
            throw new NotExistsException("There is no factory for provided task class.");
        }
        return (T)factory.create();
    }

    public static <T extends ITask> void registerTaskFactory(Class<T> taskClass, ITask.ITaskFactory<T> factory) {
        if (TASK_FACTORIES.put(taskClass, factory) != null) {
            throw new IllegalArgumentException("The factory for task class " + taskClass + " has been already registered.");
        }
    }
}

