/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.task;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.task.ITask;
import ru.timeconqueror.lootgames.api.task.TaskRegistry;
import ru.timeconqueror.lootgames.utils.future.INBTSerializable;
import ru.timeconqueror.timecore.api.exception.NotExistsException;

public class TETaskScheduler
implements INBTSerializable<NBTTagList> {
    private final ArrayList<TaskWrapper> tasks = new ArrayList();
    private final TileEntity tileEntity;

    public TETaskScheduler(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public void addTask(ITask task, int timeBeforeStart) {
        this.tasks.add(new TaskWrapper(timeBeforeStart, task));
    }

    public void onUpdate() {
        Iterator<TaskWrapper> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            TaskWrapper task = iterator.next();
            if (task.timeBeforeStart <= 0) {
                task.run(this.tileEntity.func_145831_w());
                iterator.remove();
                continue;
            }
            task.decreaseTimer();
        }
    }

    @Override
    public NBTTagList serializeNBT() {
        NBTTagList out = new NBTTagList();
        for (TaskWrapper wrapper : this.tasks) {
            NBTTagCompound element = new NBTTagCompound();
            element.func_74782_a("task", wrapper.task.serializeNBT());
            element.func_74768_a("time", wrapper.timeBeforeStart);
            element.func_74778_a("name", wrapper.task.getClass().getName());
            out.func_74742_a((NBTBase)element);
        }
        return out;
    }

    @Override
    public void deserializeNBT(NBTTagList nbt) {
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound c = nbt.func_150305_b(i);
            int time = c.func_74762_e("time");
            Class<?> clazz = null;
            try {
                Class<?> taskClass = clazz = Class.forName(c.func_74779_i("name"));
                Object task = TaskRegistry.createTask(taskClass);
                task.deserializeNBT((NBTTagCompound)c.func_74775_l("task"));
                this.tasks.add(new TaskWrapper(time, (ITask)task));
                continue;
            }
            catch (ClassNotFoundException e) {
                LootGames.LOGGER.error("Can't found class for name: {} . Skipping...", new Object[]{c.func_74779_i("name")});
                continue;
            }
            catch (ClassCastException e) {
                LootGames.LOGGER.error("Restored class name {} doesn't inherit {}. Skipping...", new Object[]{clazz, ITask.class});
                e.printStackTrace();
                continue;
            }
            catch (NotExistsException e) {
                LootGames.LOGGER.error("Mod author didn't register factory for task class {} in TaskRegistry. Skipping...", new Object[]{clazz});
                e.printStackTrace();
            }
        }
    }

    private static class TaskWrapper {
        private int timeBeforeStart;
        private final ITask task;

        private TaskWrapper(int timeBeforeStart, ITask task) {
            this.timeBeforeStart = timeBeforeStart;
            this.task = task;
        }

        private void decreaseTimer() {
            --this.timeBeforeStart;
        }

        private void run(World world) {
            this.task.run(world);
        }
    }
}

