/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity.base;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementCheckOnly;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public abstract class GT_MetaTileEntity_LargeTurbineBase
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_LargeTurbineBase>
implements ISurvivalConstructable {
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final ClassValue<IStructureDefinition<GT_MetaTileEntity_LargeTurbineBase>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GT_MetaTileEntity_LargeTurbineBase>>(){

        @Override
        protected IStructureDefinition<GT_MetaTileEntity_LargeTurbineBase> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(GT_MetaTileEntity_LargeTurbineBase.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"     ", "xxxxx", "xxxxx", "xxxxx", "xxxxx"}, {" --- ", "xcccx", "xchcx", "xchcx", "xcccx"}, {" --- ", "xc~cx", "xh-hx", "xh-hx", "xcdcx"}, {" --- ", "xcccx", "xchcx", "xchcx", "xcccx"}, {"     ", "xxxxx", "xxxxx", "xxxxx", "xxxxx"}})).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMeta()))).addElement('d', (IStructureElement)StructureUtility.lazy(t -> GT_HatchElement.Dynamo.newAny(t.getCasingTextureIndex(), 1))).addElement('h', (IStructureElement)StructureUtility.lazy(t -> GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_LargeTurbineBase.class).atLeast(new IHatchElement[]{GT_HatchElement.Maintenance, GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.OutputBus, GT_HatchElement.InputBus, GT_HatchElement.Muffler}).casingIndex(t.getCasingTextureIndex()).dot(2).buildAndChain(t.getCasingBlock(), t.getCasingMeta()))).addElement('x', (IStructureElement)((IStructureElementCheckOnly)(aContext, aWorld, aX, aY, aZ) -> {
                TileEntity tTile = aWorld.func_147438_o(aX, aY, aZ);
                return !(tTile instanceof IGregTechTileEntity) || !(((IGregTechTileEntity)tTile).getMetaTileEntity() instanceof GT_MetaTileEntity_LargeTurbineBase);
            })).build();
        }
    };
    protected int baseEff = 0;
    protected int optFlow = 0;
    protected double realOptFlow = 0.0;
    protected int storedFluid = 0;
    protected int counter = 0;
    protected boolean looseFit = false;
    protected long maxPower = 0L;

    public GT_MetaTileEntity_LargeTurbineBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbineBase(String aName) {
        super(aName);
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return this.getMaxEfficiency(aStack) > 0;
    }

    public IStructureDefinition<GT_MetaTileEntity_LargeTurbineBase> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(((Object)((Object)this)).getClass());
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.maxPower = 0L;
        if (this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 2, 1) && this.mMaintenanceHatches.size() == 1 && this.mMufflerHatches.isEmpty() == (this.getPollutionPerTick(null) == 0)) {
            this.maxPower = this.getMaximumOutput();
            return true;
        }
        return false;
    }

    public abstract Block getCasingBlock();

    public abstract int getCasingMeta();

    public abstract int getCasingTextureIndex();

    public boolean addToMachineList(IGregTechTileEntity tTileEntity, int aBaseCasingIndex) {
        return this.addMaintenanceToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addInputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addOutputToMachineList(tTileEntity, this.getCasingTextureIndex()) || this.addMufflerToMachineList(tTileEntity, this.getCasingTextureIndex());
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
    }

    @NotNull
    public CheckRecipeResult checkProcessing() {
        ItemStack controllerSlot = this.getControllerSlot();
        if (!((this.counter & 7) != 0 || controllerSlot != null && controllerSlot.func_77973_b() instanceof GT_MetaGenerated_Tool && controllerSlot.func_77960_j() >= 170 && controllerSlot.func_77960_j() <= 179)) {
            this.stopMachine();
            return CheckRecipeResultRegistry.NO_TURBINE_FOUND;
        }
        ArrayList tFluids = this.getStoredFluids();
        if (tFluids.size() > 0) {
            if (this.baseEff == 0 || this.optFlow == 0 || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                this.counter = 0;
                this.baseEff = GT_Utility.safeInt((long)((long)((5.0f + ((GT_MetaGenerated_Tool)controllerSlot.func_77973_b()).getToolCombatDamage(controllerSlot)) * 1000.0f)));
                this.optFlow = GT_Utility.safeInt((long)((long)Math.max(Float.MIN_NORMAL, ((GT_MetaGenerated_Tool)controllerSlot.func_77973_b()).getToolStats(controllerSlot).getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)controllerSlot).mToolSpeed * 50.0f)));
                if (this.optFlow <= 0 || this.baseEff <= 0) {
                    this.stopMachine();
                    return CheckRecipeResultRegistry.NO_FUEL_FOUND;
                }
            } else {
                ++this.counter;
            }
        }
        int newPower = this.fluidIntoPower(tFluids, this.optFlow, this.baseEff);
        int difference = newPower - this.mEUt;
        int maxChangeAllowed = Math.max(10, GT_Utility.safeInt((long)((long)Math.abs(difference) / 100L)));
        if (Math.abs(difference) > maxChangeAllowed) {
            int change = maxChangeAllowed * (difference > 0 ? 1 : -1);
            this.mEUt += change;
        } else {
            this.mEUt = newPower;
        }
        if (this.mEUt <= 0) {
            this.mEUt = 0;
            this.mEfficiency = 0;
            return CheckRecipeResultRegistry.NO_FUEL_FOUND;
        }
        this.mMaxProgresstime = 1;
        this.mEfficiencyIncrease = 10;
        return CheckRecipeResultRegistry.GENERATING;
    }

    public abstract int fluidIntoPower(ArrayList<FluidStack> var1, int var2, int var3);

    public int getDamageToComponent(ItemStack aStack) {
        return 1;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((ItemStack)aStack)) {
            return 0;
        }
        if (aStack.func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            return 10000;
        }
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    public long getMaximumOutput() {
        long aTotal;
        block0: {
            aTotal = 0L;
            Iterator iterator = ((ArrayList)GT_Utility.filterValidMTEs((Collection)this.mDynamoHatches)).iterator();
            if (!iterator.hasNext()) break block0;
            GT_MetaTileEntity_Hatch_Dynamo aDynamo = (GT_MetaTileEntity_Hatch_Dynamo)iterator.next();
            long aVoltage = aDynamo.maxEUOutput();
            aTotal = aDynamo.maxAmperesOut() * aVoltage;
        }
        return aTotal;
    }

    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : (ArrayList)GT_Utility.filterValidMTEs((Collection)this.mMufflerHatches)) {
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        String tRunning = this.mMaxProgresstime > 0 ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.running.true") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.running.false") + EnumChatFormatting.RESET;
        String tMaintainance = this.getIdealStatus() == this.getRepairStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.false") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.turbine.maintenance.true") + EnumChatFormatting.RESET;
        int tDura = 0;
        if (this.mInventory[1] != null && this.mInventory[1].func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
            tDura = GT_Utility.safeInt((long)((long)(100.0f / (float)GT_MetaGenerated_Tool.getToolMaxDamage((ItemStack)this.mInventory[1]) * (float)GT_MetaGenerated_Tool.getToolDamage((ItemStack)this.mInventory[1]) + 1.0f)));
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : (ArrayList)GT_Utility.filterValidMTEs((Collection)this.mDynamoHatches)) {
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        String[] ret = new String[]{tRunning + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers((long)this.mEUt) + EnumChatFormatting.RESET + " EU/t", tMaintainance, StatCollector.func_74838_a((String)"GT5U.turbine.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers((long)storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers((long)GT_Utility.safeInt((long)((long)this.realOptFlow))) + EnumChatFormatting.RESET + " L/t" + EnumChatFormatting.YELLOW + " (" + (this.looseFit ? StatCollector.func_74838_a((String)"GT5U.turbine.loose") : StatCollector.func_74838_a((String)"GT5U.turbine.tight")) + ")", StatCollector.func_74838_a((String)"GT5U.turbine.fuel") + ": " + EnumChatFormatting.GOLD + GT_Utility.formatNumbers((long)this.storedFluid) + EnumChatFormatting.RESET + "L", StatCollector.func_74838_a((String)"GT5U.turbine.dmg") + ": " + EnumChatFormatting.RED + tDura + EnumChatFormatting.RESET + "%", StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
        if (!((Object)((Object)this)).getClass().getName().contains("Steam")) {
            ret[4] = StatCollector.func_74838_a((String)"GT5U.turbine.flow") + ": " + EnumChatFormatting.YELLOW + GT_Utility.safeInt((long)((long)this.realOptFlow)) + EnumChatFormatting.RESET + " L/t";
        }
        return ret;
    }

    public boolean hasTurbine() {
        return this.getMaxEfficiency(this.mInventory[1]) > 0;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 2, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 2, 1, elementBudget, env, false, true);
    }
}

