/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader.extras;

import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.MobRecipe;
import com.kuba6000.mobsinfo.loader.extras.IExtraLoader;
import com.kuba6000.mobsinfo.loader.extras.Translations;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.ModItems;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EtFuturum
implements IExtraLoader {
    @Override
    public void process(String k, ArrayList<MobDrop> drops, MobRecipe recipe) {
        MobDrop drop;
        if (ConfigFunctions.enableSkullDrop) {
            ItemStack skull = null;
            if (recipe.entity.getClass() == EntityZombie.class) {
                skull = new ItemStack(Items.field_151144_bL, 1, 2);
            } else if (recipe.entity.getClass() == EntitySkeleton.class && ((EntitySkeleton)recipe.entity).func_82202_m() == 0) {
                skull = new ItemStack(Items.field_151144_bL, 1, 0);
            } else if (recipe.entity.getClass() == EntityCreeper.class) {
                skull = new ItemStack(Items.field_151144_bL, 1, 4);
            }
            if (skull != null) {
                MobDrop drop2 = new MobDrop(skull, MobDrop.DropType.Normal, 0, null, null, false, false);
                drop2.variableChance = true;
                drop2.chanceModifiers.addAll(Arrays.asList(new IExtraLoader.NormalChance(100.0), new DropsOnlyWhenKilledByPoweredCreeperModifier()));
                drops.add(drop2);
            }
        }
        if (ModItems.MUTTON_RAW.isEnabled() && ModItems.MUTTON_COOKED.isEnabled() && recipe.entity instanceof EntitySheep) {
            drop = new MobDrop(new ItemStack(ModItems.MUTTON_RAW.get()), MobDrop.DropType.Normal, (int)(MobDrop.getChanceBasedOnFromTo(1, 3) * 10000.0), null, null, true, false);
            drop.clampChance();
            drops.add(drop);
        }
        if (ModBlocks.WITHER_ROSE.isEnabled()) {
            drop = new MobDrop(ModBlocks.WITHER_ROSE.newItemStack(1, 0), MobDrop.DropType.Additional, 0, null, null, false, false);
            drop.variableChance = true;
            drop.chanceModifiers.addAll(Arrays.asList(new IExtraLoader.NormalChance(100.0), new WitherRoseModifier()));
            drops.add(drop);
        }
    }

    private static class WitherRoseModifier
    implements IChanceModifier {
        private WitherRoseModifier() {
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyTooltip(List<String> currentTooltip) {
            currentTooltip.addAll(Arrays.asList(Translations.ETFUTURUM_WITHER_ROSE.get(), Translations.ETFUTURUM_WITHER_ROSE_1.get()));
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            return attacker instanceof EntityWither ? chance : 0.0;
        }
    }

    private static class DropsOnlyWhenKilledByPoweredCreeperModifier
    implements IChanceModifier {
        private DropsOnlyWhenKilledByPoweredCreeperModifier() {
        }

        @Override
        public String getDescription() {
            return Translations.ETFUTURUM_POWERED_CREEPER.get();
        }

        @Override
        public double apply(double chance, @Nonnull World world, @Nonnull List<ItemStack> drops, Entity attacker, EntityLiving victim) {
            return attacker instanceof EntityCreeper && ((EntityCreeper)attacker).func_70830_n() ? chance : 0.0;
        }
    }
}

