/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.integration;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.p455w0rd.wirelesscraftingterminal.integration.IntegrationNode;
import net.p455w0rd.wirelesscraftingterminal.integration.IntegrationSide;
import net.p455w0rd.wirelesscraftingterminal.integration.IntegrationStage;
import net.p455w0rd.wirelesscraftingterminal.integration.IntegrationType;

public enum IntegrationRegistry {
    INSTANCE;

    private static final String PACKAGE_PREFIX = "net.p455w0rd.wirelesscraftingterminal.integration.modules.";
    private final Collection<IntegrationNode> modules = new LinkedList<IntegrationNode>();

    public void add(IntegrationType type) {
        if (type.side == IntegrationSide.CLIENT && FMLLaunchHandler.side() == Side.SERVER) {
            return;
        }
        if (type.side == IntegrationSide.SERVER && FMLLaunchHandler.side() == Side.CLIENT) {
            return;
        }
        this.modules.add(new IntegrationNode(type.dspName, type.modID, type, PACKAGE_PREFIX + type.name()));
    }

    public void init() {
        for (IntegrationType type : IntegrationType.values()) {
            INSTANCE.add(type);
        }
        for (IntegrationNode node : this.modules) {
            node.call(IntegrationStage.PRE_INIT);
        }
        for (IntegrationNode node : this.modules) {
            node.call(IntegrationStage.INIT);
        }
    }

    public void postInit() {
        for (IntegrationNode node : this.modules) {
            node.call(IntegrationStage.POST_INIT);
        }
    }

    public String getStatus() {
        StringBuilder builder = new StringBuilder(this.modules.size() * 3);
        for (IntegrationNode node : this.modules) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            String integrationState = (Object)((Object)node.getShortName()) + ":" + (node.getState() == IntegrationStage.FAILED ? "OFF" : "ON");
            builder.append(integrationState);
        }
        return builder.toString();
    }

    public boolean isEnabled(IntegrationType name) {
        for (IntegrationNode node : this.modules) {
            if (node.getShortName() != name) continue;
            return node.isActive();
        }
        return false;
    }

    @Nonnull
    public Object getInstance(IntegrationType name) {
        for (IntegrationNode node : this.modules) {
            if (node.getShortName() != name || !node.isActive()) continue;
            return node.getInstance();
        }
        throw new IllegalStateException("integration with " + name.name() + " is disabled.");
    }
}

