/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessage;

public abstract class Log {
    public static void finest(String message) {
        Log.log(Level.TRACE, message);
    }

    public static void finest(String message, Object param) {
        Log.log(Level.TRACE, message, param);
    }

    public static void finest(String message, Object ... params) {
        Log.log(Level.TRACE, message, params);
    }

    public static void finer(String message) {
        Log.log(Level.TRACE, message);
    }

    public static void finer(String message, Object param) {
        Log.log(Level.TRACE, message, param);
    }

    public static void finer(String message, Object ... params) {
        Log.log(Level.TRACE, message, params);
    }

    public static void fine(String message) {
        Log.log(Level.DEBUG, message);
    }

    public static void fine(String message, Object param) {
        Log.log(Level.DEBUG, message, param);
    }

    public static void fine(String message, Object ... params) {
        Log.log(Level.DEBUG, message, params);
    }

    public static void info(String message) {
        Log.log(Level.INFO, message);
    }

    public static void info(String message, Object param) {
        Log.log(Level.INFO, message, param);
    }

    public static void info(String message, Object ... params) {
        Log.log(Level.INFO, message, params);
    }

    public static void warning(String message) {
        Log.log(Level.WARN, message);
    }

    public static void warning(String message, Object param) {
        Log.log(Level.WARN, message, param);
    }

    public static void warning(String message, Object ... params) {
        Log.log(Level.WARN, message, params);
    }

    public static void severe(String message) {
        Log.log(Level.FATAL, message);
    }

    public static void severe(String message, Object param) {
        Log.log(Level.FATAL, message, param);
    }

    public static void severe(String message, Object ... params) {
        Log.log(Level.FATAL, message, params);
    }

    private static void log(Level logLevel, String message) {
        LogManager.getLogger((String)"Forestry").log(logLevel, message);
    }

    private static void log(Level logLevel, String message, Object ... params) {
        LogManager.getLogger((String)"Forestry").log(logLevel, (Message)new MessageFormatMessage(String.format(message, params), params));
    }

    public static void logThrowable(String msg, Throwable error, Object ... args) {
        Log.logThrowable(Level.ERROR, msg, 3, error, args);
    }

    public static void logThrowable(String msg, int lines, Throwable error, Object ... args) {
        Log.logThrowable(Level.ERROR, msg, lines, error, args);
    }

    public static void logThrowable(Level level, String msg, int lines, Throwable error, Object ... args) {
        StackTraceElement[] oldtrace = error.getStackTrace();
        if (lines < oldtrace.length) {
            StackTraceElement[] newtrace = new StackTraceElement[lines];
            System.arraycopy(oldtrace, 0, newtrace, 0, newtrace.length);
            error.setStackTrace(newtrace);
        }
        LogManager.getLogger((String)"Forestry").log(level, (Message)new MessageFormatMessage(msg, args), error);
    }

    public static void logErrorAPI(String mod, Throwable error, Class classFile) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" API error, please update your mods. Error: ").append(error);
        Log.logThrowable(Level.ERROR, msg.toString(), 2, error, new Object[0]);
        if (classFile != null) {
            msg = new StringBuilder(mod);
            msg.append(" API error: ").append(classFile.getSimpleName()).append(" is loaded from ").append(classFile.getProtectionDomain().getCodeSource().getLocation());
            Log.log(Level.ERROR, msg.toString());
        }
    }
}

