/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.tiles.IFilterSlotDelegate;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class ItemInventory
implements IInventory,
IFilterSlotDelegate {
    private static final String KEY_ITEMS = "Items";
    private static final String KEY_SLOTS = "Slots";
    private static final String KEY_UID = "UID";
    private static final Random rand = new Random();
    private final EntityPlayer player;
    private final ItemStack parent;
    private final ItemStack[] inventoryStacks;

    public ItemInventory(EntityPlayer player, int size, ItemStack parent) {
        this.player = player;
        this.parent = parent;
        this.inventoryStacks = new ItemStack[size];
        this.setUID();
        this.readFromNBT(parent.func_77978_p());
    }

    public static int getOccupiedSlotCount(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        if (nbt.func_74764_b(KEY_SLOTS)) {
            NBTTagCompound slotNbt = nbt.func_74775_l(KEY_SLOTS);
            return slotNbt.func_150296_c().size();
        }
        int count = 0;
        if (nbt.func_74764_b(KEY_ITEMS)) {
            NBTTagList nbttaglist = nbt.func_150295_c(KEY_ITEMS, 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                ItemStack itemStack1 = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                if (itemStack1 == null || itemStack1.field_77994_a <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    private void setUID() {
        NBTTagCompound nbt;
        ItemStack parent = this.getParent();
        if (parent.func_77978_p() == null) {
            parent.func_77982_d(new NBTTagCompound());
        }
        if (!(nbt = parent.func_77978_p()).func_74764_b(KEY_UID)) {
            nbt.func_74768_a(KEY_UID, rand.nextInt());
        }
    }

    public boolean isParentItemInventory(ItemStack itemStack) {
        ItemStack parent = this.getParent();
        return ItemInventory.isSameItemInventory(parent, itemStack);
    }

    protected ItemStack getParent() {
        ItemStack equipped = this.player.func_71045_bC();
        if (ItemInventory.isSameItemInventory(equipped, this.parent)) {
            return equipped;
        }
        return this.parent;
    }

    private static boolean isSameItemInventory(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.func_77973_b() != comparison.func_77973_b()) {
            return false;
        }
        if (!base.func_77942_o() || !comparison.func_77942_o()) {
            return false;
        }
        String baseUID = base.func_77978_p().func_74779_i(KEY_UID);
        String comparisonUID = comparison.func_77978_p().func_74779_i(KEY_UID);
        return baseUID != null && !baseUID.isEmpty() && baseUID.equals(comparisonUID);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.func_74764_b(KEY_SLOTS)) {
            NBTTagCompound nbtSlots = nbt.func_74775_l(KEY_SLOTS);
            for (int i = 0; i < this.inventoryStacks.length; ++i) {
                String slotKey = ItemInventory.getSlotNBTKey(i);
                if (nbtSlots.func_74764_b(slotKey)) {
                    ItemStack itemStack;
                    NBTTagCompound itemNbt = nbtSlots.func_74775_l(slotKey);
                    this.inventoryStacks[i] = itemStack = ItemStack.func_77949_a((NBTTagCompound)itemNbt);
                    continue;
                }
                this.inventoryStacks[i] = null;
            }
        } else if (nbt.func_74764_b(KEY_ITEMS)) {
            for (int i = 0; i < this.inventoryStacks.length; ++i) {
                this.inventoryStacks[i] = null;
            }
            NBTTagList nbttaglist = nbt.func_150295_c(KEY_ITEMS, 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                ItemStack itemStack;
                NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound1.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
                this.inventoryStacks[byte0] = itemStack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
            this.writeToParentNBT();
        }
    }

    private void writeToParentNBT() {
        ItemStack parent = this.getParent();
        if (parent == null) {
            return;
        }
        NBTTagCompound nbt = parent.func_77978_p();
        NBTTagCompound slotsNbt = new NBTTagCompound();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_70301_a(i);
            if (itemStack == null) continue;
            String slotKey = ItemInventory.getSlotNBTKey(i);
            NBTTagCompound itemNbt = new NBTTagCompound();
            itemStack.func_77955_b(itemNbt);
            slotsNbt.func_74782_a(slotKey, (NBTBase)itemNbt);
        }
        nbt.func_74782_a(KEY_SLOTS, (NBTBase)slotsNbt);
        nbt.func_82580_o(KEY_ITEMS);
    }

    private static String getSlotNBTKey(int i) {
        return Integer.toString(i, 36);
    }

    public void onSlotClick(EntityPlayer player) {
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.func_70301_a(i);
        if (stack == null) {
            return null;
        }
        if (stack.field_77994_a <= j) {
            this.func_70299_a(i, null);
            return stack;
        }
        ItemStack product = stack.func_77979_a(j);
        this.func_70299_a(i, stack);
        return product;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        NBTTagCompound slotNbt;
        if (itemstack != null && itemstack.field_77994_a == 0) {
            itemstack = null;
        }
        this.inventoryStacks[i] = itemstack;
        ItemStack parent = this.getParent();
        NBTTagCompound nbt = parent.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            parent.func_77982_d(nbt);
        }
        if (!nbt.func_74764_b(KEY_SLOTS)) {
            slotNbt = new NBTTagCompound();
            nbt.func_74782_a(KEY_SLOTS, (NBTBase)slotNbt);
        } else {
            slotNbt = nbt.func_74775_l(KEY_SLOTS);
        }
        String slotKey = ItemInventory.getSlotNBTKey(i);
        if (itemstack == null) {
            slotNbt.func_82580_o(slotKey);
        } else {
            NBTTagCompound itemNbt = new NBTTagCompound();
            itemstack.func_77955_b(itemNbt);
            slotNbt.func_74782_a(slotKey, (NBTBase)itemNbt);
        }
    }

    public ItemStack func_70301_a(int i) {
        return this.inventoryStacks[i];
    }

    public int func_70302_i_() {
        return this.inventoryStacks.length;
    }

    public String func_145825_b() {
        return "BeeBag";
    }

    public int func_70297_j_() {
        return 64;
    }

    public final void func_70296_d() {
        this.writeToParentNBT();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return this.canSlotAccept(slotIndex, itemStack);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack toReturn = this.func_70301_a(slot);
        if (toReturn != null) {
            this.func_70299_a(slot, null);
        }
        return toReturn;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }
}

