/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.commands;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.core.commands.ICommandModeHelper;
import java.util.ArrayList;
import net.minecraft.world.World;

public class BeeModeHelper
implements ICommandModeHelper {
    @Override
    public String[] getModeNames() {
        ArrayList<IBeekeepingMode> beekeepingModes = BeeManager.beeRoot.getBeekeepingModes();
        int modeStringCount = beekeepingModes.size();
        ArrayList<String> modeStrings = new ArrayList<String>(modeStringCount);
        for (IBeekeepingMode mode : beekeepingModes) {
            modeStrings.add(mode.getName());
        }
        return modeStrings.toArray(new String[modeStringCount]);
    }

    @Override
    public String getModeNameMatching(String desired) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(desired);
        if (mode == null) {
            return null;
        }
        return mode.getName();
    }

    @Override
    public String getModeName(World world) {
        return BeeManager.beeRoot.getBeekeepingMode(world).getName();
    }

    @Override
    public void setMode(World world, String modeName) {
        BeeManager.beeRoot.setBeekeepingMode(world, modeName);
    }

    @Override
    public Iterable<String> getDescription(String modeName) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(modeName);
        return mode.getDescription();
    }
}

