/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultkeys.localconfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.blay09.mods.defaultkeys.localconfig.LocalConfigEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeConfigHandler {
    private static final Logger logger = LogManager.getLogger();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void backup(PrintWriter writer, List<LocalConfigEntry> entries, File configFile) {
        foundProperty = new boolean[entries.size()];
        notEntries = new ArrayList<LocalConfigEntry>();
        for (LocalConfigEntry entry : entries) {
            if (!entry.not) continue;
            notEntries.add(entry);
        }
        categoryPath = new ArrayList<String>();
        isInQuotes = false;
        isInList = false;
        consumeList = false;
        try {
            block27: {
                reader = new BufferedReader(new FileReader(configFile));
                while (true) {
                    line = reader.readLine();
                    if (line == null) {
                        i = 0;
                        while (i < foundProperty.length) {
                            if (!foundProperty[i] && !entries.get((int)i).not) {
                                ForgeConfigHandler.logger.warn("Failed to backup local value {}: property not found", new Object[]{entries.get(i).getIdentifier()});
                            }
                            ++i;
                        }
                        return;
                    }
                    break block27;
                    break;
                }
                finally {
                    reader.close();
                }
            }
            buffer = new StringBuilder();
            i = 0;
            while (true) {
                block29: {
                    block30: {
                        block31: {
                            block28: {
                                if (i >= line.length()) ** GOTO lbl-1000
                                c = line.charAt(i);
                                if (!isInQuotes) break block28;
                                if (c == '\"') {
                                    isInQuotes = false;
                                }
                                buffer.append(c);
                                break block29;
                            }
                            if (!isInList) break block30;
                            if (!line.trim().equals(">")) break block31;
                            isInList = false;
                            if (consumeList) {
                                writer.println();
                            }
                            ** GOTO lbl-1000
                        }
                        if (!consumeList) break block29;
                        writer.print(line.trim().replace(",", ",,"));
                        writer.print(", ");
                        ** GOTO lbl-1000
                    }
                    switch (c) {
                        case '#': {
                            ** GOTO lbl-1000
                        }
                        case '\"': {
                            isInQuotes = true;
                            buffer.append(c);
                            break;
                        }
                        case '{': {
                            categoryPath.add(buffer.toString().trim());
                            buffer = new StringBuilder();
                            break;
                        }
                        case '}': {
                            categoryPath.remove(categoryPath.size() - 1);
                            break;
                        }
                        case '<': {
                            isInList = true;
                            consumeList = false;
                            category = StringUtils.join(categoryPath, (String)".");
                            name = buffer.toString().trim();
                            type = name.substring(0, 1);
                            name = name.substring(2);
                            j = 0;
                            while (true) {
                                if (j >= entries.size()) ** GOTO lbl-1000
                                entry = entries.get(j);
                                if (!entry.passesProperty(category, name, type)) ** GOTO lbl92
                                foundProperty[j] = true;
                                if (!entry.containsWildcard()) ** GOTO lbl88
                                for (LocalConfigEntry notEntry : notEntries) {
                                    if (!notEntry.passesProperty(category, name, type)) continue;
                                    ** GOTO lbl-1000
                                }
lbl88:
                                // 2 sources

                                consumeList = true;
                                writer.print(entry.getIdentifier(entry.file, category, type, name));
                                writer.print("=");
                                ** GOTO lbl-1000
lbl92:
                                // 1 sources

                                ++j;
                            }
                        }
                        case '=': {
                            category = StringUtils.join(categoryPath, (String)".");
                            name = buffer.toString().trim();
                            type = name.substring(0, 1);
                            name = name.substring(2);
                            value = line.substring(i + 1);
                            j = 0;
                            while (true) {
                                if (j >= entries.size()) ** GOTO lbl-1000
                                entry = entries.get(j);
                                if (!entry.passesProperty(category, name, type)) ** GOTO lbl112
                                foundProperty[j] = true;
                                if (!entry.containsWildcard()) ** GOTO lbl110
                                for (LocalConfigEntry notEntry : notEntries) {
                                    if (!notEntry.passesProperty(category, name, type)) continue;
                                    ** GOTO lbl-1000
                                }
lbl110:
                                // 2 sources

                                writer.println(entry.getIdentifier(entry.file, category, type, name) + "=" + value);
                                ** continue;
lbl112:
                                // 1 sources

                                ++j;
                            }
                        }
                        default: {
                            buffer.append(c);
                        }
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void restore(List<LocalConfigEntry> entries, File configFile) {
        boolean[] foundProperty = new boolean[entries.size()];
        ArrayList<LocalConfigEntry> notEntries = new ArrayList<LocalConfigEntry>();
        for (LocalConfigEntry entry : entries) {
            if (!entry.not) continue;
            notEntries.add(entry);
        }
        File backupFile = new File(configFile.getParentFile(), configFile.getName() + ".bak");
        try {
            FileUtils.copyFile((File)configFile, (File)backupFile);
        }
        catch (IOException e) {
            logger.error("Could not create backup file {}: {}", new Object[]{backupFile, e});
        }
        try {
            List lines = FileUtils.readLines((File)configFile);
            try (PrintWriter writer = new PrintWriter(configFile);){
                ArrayList<String> categoryPath = new ArrayList<String>();
                boolean isInQuotes = false;
                boolean isInList = false;
                boolean discardList = false;
                block20: for (String line : lines) {
                    StringBuilder buffer = new StringBuilder();
                    block21: for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (isInQuotes) {
                            if (c == '\"') {
                                isInQuotes = false;
                            }
                            buffer.append(c);
                            continue;
                        }
                        if (isInList) {
                            if (line.trim().equals(">")) {
                                isInList = false;
                            }
                            if (!discardList) continue;
                            continue block20;
                        }
                        switch (c) {
                            case '#': {
                                break block21;
                            }
                            case '\"': {
                                isInQuotes = true;
                                buffer.append(c);
                                continue block21;
                            }
                            case '{': {
                                categoryPath.add(buffer.toString().trim());
                                buffer = new StringBuilder();
                                continue block21;
                            }
                            case '}': {
                                categoryPath.remove(categoryPath.size() - 1);
                                continue block21;
                            }
                            case '<': {
                                LocalConfigEntry entry;
                                int j;
                                isInList = true;
                                discardList = false;
                                String category = StringUtils.join(categoryPath, (String)".");
                                String name = buffer.toString().trim();
                                String type = name.substring(0, 1);
                                name = name.substring(2);
                                for (j = 0; j < entries.size(); ++j) {
                                    entry = entries.get(j);
                                    if (!entry.passesProperty(category, name, type)) continue;
                                    foundProperty[j] = true;
                                    if (entry.containsWildcard()) {
                                        for (LocalConfigEntry notEntry : notEntries) {
                                            if (!notEntry.passesProperty(category, name, type)) continue;
                                            break block21;
                                        }
                                    }
                                    discardList = true;
                                    String indent = StringUtils.repeat((char)' ', (int)(categoryPath.size() * 4));
                                    writer.println(line);
                                    String escapedValue = entry.value.replaceAll(",,", "\n");
                                    List<String> values = Arrays.asList(StringUtils.splitPreserveAllTokens((String)escapedValue, (String)","));
                                    if (!values.isEmpty()) {
                                        values = values.subList(0, values.size() - 1);
                                    }
                                    for (String value : values) {
                                        writer.print(indent);
                                        writer.print("    ");
                                        writer.println(value.replace('\n', ',').trim());
                                    }
                                    writer.print(indent);
                                    writer.println(" >");
                                    continue block20;
                                }
                                break block21;
                            }
                            case '=': {
                                LocalConfigEntry entry;
                                int j;
                                String category = StringUtils.join(categoryPath, (String)".");
                                String name = buffer.toString().trim();
                                String type = name.substring(0, 1);
                                name = name.substring(2);
                                for (j = 0; j < entries.size(); ++j) {
                                    entry = entries.get(j);
                                    if (!entry.passesProperty(category, name, type)) continue;
                                    foundProperty[j] = true;
                                    if (entry.containsWildcard()) {
                                        for (LocalConfigEntry notEntry : notEntries) {
                                            if (!notEntry.passesProperty(category, name, type)) continue;
                                            break block21;
                                        }
                                    }
                                    line = line.substring(0, i) + "=" + entry.value;
                                    break block21;
                                }
                                break block21;
                            }
                            default: {
                                buffer.append(c);
                            }
                        }
                    }
                    writer.println(line);
                }
            }
            for (int i = 0; i < foundProperty.length; ++i) {
                if (foundProperty[i] || entries.get((int)i).not) continue;
                logger.warn("Failed to restore local value {}: property not found", new Object[]{entries.get(i).getIdentifier()});
            }
        }
        catch (IOException e) {
            logger.error("Failed to restore local values in {}: {}", new Object[]{configFile, e});
            try {
                FileUtils.copyFile((File)backupFile, (File)configFile);
            }
            catch (IOException e2) {
                logger.error("Could not restore config file {} from backup: {}", new Object[]{configFile, e2});
            }
        }
    }
}

