/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.widget;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Unmodifiable;

public interface IWidgetParent {
    public Size getSize();

    public Pos2d getAbsolutePos();

    public Pos2d getPos();

    public @Unmodifiable List<Widget> getChildren();

    public ModularUIContext getContext();

    default public void initChildren() {
    }

    default public void layoutChildren(int maxWidth, int maxHeight) {
    }

    @SideOnly(value=Side.CLIENT)
    default public void drawChildren(float partialTicks) {
        for (Widget child : this.getChildren()) {
            child.drawInternal(partialTicks);
        }
    }

    default public boolean childrenMustBeInBounds() {
        return false;
    }

    public static boolean forEachByLayer(List<Widget> parent, Function<Widget, Boolean> consumer) {
        return IWidgetParent.forEachByLayer((IWidgetParent)new Wrapper(parent), consumer);
    }

    public static boolean forEachByLayer(Widget parent, Function<Widget, Boolean> consumer) {
        if (parent instanceof IWidgetParent) {
            return IWidgetParent.forEachByLayer((IWidgetParent)((Object)parent), consumer);
        }
        return consumer.apply(parent);
    }

    public static boolean forEachByLayer(IWidgetParent parent, Function<Widget, Boolean> consumer) {
        return IWidgetParent.forEachByLayer(parent, false, consumer);
    }

    public static boolean forEachByLayer(IWidgetParent parent, boolean onlyEnabled, Function<Widget, Boolean> consumer) {
        return IWidgetParent.forEachByLayer(parent, onlyEnabled, widget -> false, consumer);
    }

    public static boolean forEachByLayer(IWidgetParent parent, boolean onlyEnabled, Function<Widget, Boolean> skipChildrenSearch, Function<Widget, Boolean> consumer) {
        LinkedList<IWidgetParent> stack = new LinkedList<IWidgetParent>();
        stack.addLast(parent);
        while (!stack.isEmpty()) {
            IWidgetParent parent1 = (IWidgetParent)stack.pollFirst();
            for (Widget child : parent1.getChildren()) {
                if (onlyEnabled && !child.isEnabled()) continue;
                if (consumer.apply(child).booleanValue()) {
                    return false;
                }
                if (skipChildrenSearch.apply(child).booleanValue() || !(child instanceof IWidgetParent)) continue;
                stack.addLast((IWidgetParent)((Object)child));
            }
        }
        return true;
    }

    public static boolean forEachByBranch(IWidgetParent parent, Function<Widget, Boolean> consumer) {
        for (Widget widget : parent.getChildren()) {
            if (consumer.apply(widget).booleanValue()) {
                return false;
            }
            if (!(widget instanceof IWidgetParent)) continue;
            IWidgetParent.forEachByBranch((IWidgetParent)((Object)widget), consumer);
        }
        return true;
    }

    public static boolean forEachByLayer(Widget parent, Consumer<Widget> consumer) {
        return IWidgetParent.forEachByLayer(parent, (Widget widget) -> {
            consumer.accept((Widget)widget);
            return false;
        });
    }

    public static boolean forEachByLayer(IWidgetParent parent, Consumer<Widget> consumer) {
        return IWidgetParent.forEachByLayer(parent, (Widget widget) -> {
            consumer.accept((Widget)widget);
            return false;
        });
    }

    public static Size getSizeOf(List<Widget> widgets) {
        if (widgets.isEmpty()) {
            return new Size(0, 0);
        }
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        for (Widget widget : widgets) {
            xMin = Math.min(xMin, widget.getPos().x);
            yMin = Math.min(yMin, widget.getPos().y);
        }
        int xMax = Integer.MIN_VALUE;
        int yMax = Integer.MIN_VALUE;
        for (Widget widget : widgets) {
            xMax = Math.max(xMax, widget.getPos().x + widget.getSize().width);
            yMax = Math.max(yMax, widget.getPos().y + widget.getSize().height);
        }
        return new Size(xMax - xMin, yMax - yMin);
    }

    public static class Wrapper
    implements IWidgetParent {
        private final List<Widget> children;

        public Wrapper(List<Widget> children) {
            this.children = children;
        }

        @Override
        public Size getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pos2d getAbsolutePos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pos2d getPos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Widget> getChildren() {
            return this.children;
        }

        @Override
        public ModularUIContext getContext() {
            throw new UnsupportedOperationException();
        }
    }
}

