/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.math;

import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MathExpression {
    private static final List<Object> DEFAULT = Collections.singletonList(0);

    public static double parseMathExpression(String expr) {
        return MathExpression.parseMathExpression(expr, 0.0);
    }

    public static double parseMathExpression(String expr, double onFailReturn) {
        Double newNum;
        Object obj;
        int i;
        List<Object> parsed = MathExpression.buildParsedList(expr, onFailReturn);
        if (parsed == DEFAULT || parsed.size() == 0) {
            return onFailReturn;
        }
        if (parsed.size() == 1) {
            Object value = parsed.get(0);
            return value instanceof Double ? (Double)value : onFailReturn;
        }
        Double lastNum = null;
        for (i = 0; i < parsed.size(); ++i) {
            obj = parsed.get(i);
            if (lastNum == null && obj instanceof Double) {
                lastNum = (Double)obj;
                continue;
            }
            if (obj == Operator.POWER) {
                newNum = Math.pow(lastNum, (Double)parsed.get(i + 1));
                parsed.remove(i - 1);
                parsed.remove(i - 1);
                parsed.remove(i - 1);
                parsed.add(i - 1, newNum);
                lastNum = newNum;
                --i;
                continue;
            }
            lastNum = null;
        }
        if (lastNum != null) {
            lastNum = null;
        }
        if (parsed.size() > 1) {
            for (i = 0; i < parsed.size(); ++i) {
                obj = parsed.get(i);
                if (lastNum == null && obj instanceof Double) {
                    lastNum = (Double)obj;
                    continue;
                }
                if (obj == Operator.MULTIPLY) {
                    newNum = lastNum * (Double)parsed.get(i + 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.add(i - 1, newNum);
                    lastNum = newNum;
                    --i;
                    continue;
                }
                if (obj == Operator.DIVIDE) {
                    newNum = lastNum / (Double)parsed.get(i + 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.add(i - 1, newNum);
                    lastNum = newNum;
                    --i;
                    continue;
                }
                if (obj == Operator.MOD) {
                    newNum = lastNum % (Double)parsed.get(i + 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.add(i - 1, newNum);
                    lastNum = newNum;
                    --i;
                    continue;
                }
                lastNum = null;
            }
            if (lastNum != null) {
                lastNum = null;
            }
        }
        if (parsed.size() > 1) {
            for (i = 0; i < parsed.size(); ++i) {
                obj = parsed.get(i);
                if (lastNum == null && obj instanceof Double) {
                    lastNum = (Double)obj;
                    continue;
                }
                if (obj == Operator.PLUS) {
                    newNum = lastNum + (Double)parsed.get(i + 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.add(i - 1, newNum);
                    lastNum = newNum;
                    --i;
                    continue;
                }
                if (obj == Operator.MINUS) {
                    newNum = lastNum - (Double)parsed.get(i + 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.remove(i - 1);
                    parsed.add(i - 1, newNum);
                    lastNum = newNum;
                    --i;
                    continue;
                }
                lastNum = null;
            }
        }
        if (parsed.size() != 1) {
            throw new IllegalStateException("Calculated expr has more than 1 result. " + parsed);
        }
        return (Double)parsed.get(0);
    }

    public static List<Object> buildParsedList(String expr, double onFailReturn) {
        ArrayList<Object> parsed = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        if (expr == null || expr.isEmpty()) {
            return parsed;
        }
        block8: for (int i = 0; i < expr.length(); ++i) {
            char c = expr.charAt(i);
            switch (c) {
                case '+': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.PLUS);
                    continue block8;
                }
                case '-': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.MINUS);
                    continue block8;
                }
                case '*': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.MULTIPLY);
                    continue block8;
                }
                case '/': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.DIVIDE);
                    continue block8;
                }
                case '%': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.MOD);
                    continue block8;
                }
                case '^': {
                    if (builder.length() > 0) {
                        parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
                        builder.delete(0, builder.length());
                    }
                    parsed.add((Object)Operator.POWER);
                    continue block8;
                }
                default: {
                    builder.append(c);
                }
            }
        }
        if (builder.length() > 0) {
            parsed.add(MathExpression.parse(builder.toString(), onFailReturn));
        }
        if (parsed.size() >= 2 && parsed.get(0) == Operator.MINUS && parsed.get(1) instanceof Double) {
            parsed.add(0, 0.0);
        }
        boolean shouldBeOperator = false;
        for (Object e : parsed) {
            if (shouldBeOperator) {
                if (!(e instanceof Operator)) {
                    return DEFAULT;
                }
                shouldBeOperator = false;
                continue;
            }
            if (!(e instanceof Double)) {
                return DEFAULT;
            }
            shouldBeOperator = true;
        }
        while (parsed.get(parsed.size() - 1) instanceof Operator) {
            parsed.remove(parsed.size() - 1);
        }
        return parsed;
    }

    public static double parse(String num, double onFailReturn) {
        try {
            return TextFieldWidget.format.parse(num).doubleValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return onFailReturn;
        }
    }

    public static enum Operator {
        PLUS("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        MOD("%"),
        POWER("^");

        public final String sign;

        private Operator(String sign) {
            this.sign = sign;
        }

        public String toString() {
            return this.sign;
        }
    }
}

