/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load;

import alexiil.mods.load.ModLoadingListener;
import alexiil.mods.load.ProgressDisplayer;
import alexiil.mods.load.git.Commit;
import alexiil.mods.load.git.GitHubUser;
import alexiil.mods.load.git.Release;
import com.google.common.eventbus.EventBus;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterloadingscreen", version="1.5.0-GTNH", name="Better Loading Screen GTNH", acceptedMinecraftVersions="[1.7.10]", guiFactory="alexiil.mods.load.gui.ConfigGuiFactory", acceptableRemoteVersions="*")
public class BetterLoadingScreen {
    @Mod.Instance(value="betterloadingscreen")
    public static BetterLoadingScreen instance;
    public static final Logger log;
    private static List<GitHubUser> contributors;
    private static List<Commit> commits;
    private static List<Release> releases;
    private static Commit thisCommit;
    public static ModMetadata meta;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) throws IOException {
        ModLoadingListener thisListener = null;
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!(mod instanceof FMLModContainer)) continue;
            EventBus bus = null;
            try {
                Field f = FMLModContainer.class.getDeclaredField("eventBus");
                f.setAccessible(true);
                bus = (EventBus)f.get(mod);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (bus == null) continue;
            if (mod.getModId().equals("betterloadingscreen")) {
                thisListener = new ModLoadingListener(mod);
                bus.register((Object)thisListener);
                continue;
            }
            bus.register((Object)new ModLoadingListener(mod));
        }
        if (thisListener != null) {
            ModLoadingListener.doProgress(ModLoadingListener.State.CONSTRUCT, thisListener);
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        FMLCommonHandler.instance().bus().register((Object)instance);
        meta = event.getModMetadata();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void guiOpen(GuiOpenEvent event) throws IOException {
        ProgressDisplayer.close();
    }

    @SubscribeEvent
    public void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (Objects.equals(event.modID, "betterloadingscreen")) {
            ProgressDisplayer.cfg.save();
        }
    }

    @Mod.EventHandler
    @SideOnly(value=Side.SERVER)
    public void serverAboutToStart(FMLServerAboutToStartEvent event) throws IOException {
        ProgressDisplayer.close();
    }

    public static void initSiteVersioning() {
    }

    public static List<Commit> getCommits() {
        if (contributors == null) {
            BetterLoadingScreen.initSiteVersioning();
        }
        return commits;
    }

    public static Commit getCurrentCommit() {
        if (contributors == null) {
            BetterLoadingScreen.initSiteVersioning();
        }
        return thisCommit;
    }

    public static List<Release> getReleases() {
        if (contributors == null) {
            BetterLoadingScreen.initSiteVersioning();
        }
        return releases;
    }

    static {
        log = LogManager.getLogger((String)"betterloadingscreen");
        contributors = null;
        commits = null;
        releases = null;
        thisCommit = null;
    }
}

