/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.api.block;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.LootGamesAPI;
import ru.timeconqueror.lootgames.api.block.GameBlock;
import ru.timeconqueror.lootgames.api.block.IGameField;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.BlockState;
import ru.timeconqueror.lootgames.utils.future.WorldExt;

@ParametersAreNonnullByDefault
public class BoardBorderBlock
extends GameBlock
implements IGameField {
    private IIcon bottomLeft;
    private IIcon bottomRight;
    private IIcon topLeft;
    private IIcon topRight;
    private IIcon horizontal;
    private IIcon vertical;

    public static BlockPos getMasterPos(World world, BlockPos pos, BlockState oldState) {
        BlockPos.Mutable currentPos = pos.mutable();
        Block currentBlock = oldState.getBlock();
        int currentMeta = oldState.getMeta();
        int limit = 128;
        while (--limit >= 0 && currentBlock instanceof BoardBorderBlock) {
            Type type = Type.byMeta(currentMeta);
            switch (type) {
                case HORIZONTAL: 
                case TOP_RIGHT: {
                    currentPos.move(-1, 0, 0);
                    break;
                }
                case BOTTOM_RIGHT: 
                case BOTTOM_LEFT: 
                case VERTICAL: {
                    currentPos.move(0, 0, -1);
                }
            }
            currentBlock = WorldExt.getBlock(world, currentPos);
            currentMeta = WorldExt.getMeta(world, currentPos);
        }
        return currentPos.immutable();
    }

    @Override
    public void func_149651_a(IIconRegister reg) {
        this.bottomLeft = reg.func_94245_a(LootGames.namespaced("border/bottom_left"));
        this.bottomRight = reg.func_94245_a(LootGames.namespaced("border/bottom_right"));
        this.topLeft = reg.func_94245_a(LootGames.namespaced("border/top_left"));
        this.topRight = reg.func_94245_a(LootGames.namespaced("border/top_right"));
        this.horizontal = reg.func_94245_a(LootGames.namespaced("border/horizontal"));
        this.vertical = reg.func_94245_a(LootGames.namespaced("border/vertical"));
    }

    @Override
    public IIcon func_149691_a(int sideIn, int meta) {
        ForgeDirection side = ForgeDirection.getOrientation((int)sideIn);
        Type type = Type.byMeta(meta);
        if (type == Type.HORIZONTAL || side.offsetY == 0) {
            return this.horizontal;
        }
        if (type == Type.VERTICAL) {
            return this.vertical;
        }
        if (type == Type.TOP_LEFT) {
            return this.topLeft;
        }
        if (type == Type.TOP_RIGHT) {
            return this.topRight;
        }
        if (type == Type.BOTTOM_RIGHT) {
            return this.bottomRight;
        }
        if (type == Type.BOTTOM_LEFT) {
            return this.bottomLeft;
        }
        return super.func_149691_a(sideIn, meta);
    }

    public void func_149749_a(World worldIn, int x, int y, int z, Block blockBroken, int meta) {
        if (!worldIn.field_72995_K) {
            BlockPos pos = BlockPos.of(x, y, z);
            LootGamesAPI.getFieldManager().onFieldBlockBroken(worldIn, () -> BoardBorderBlock.getMasterPos(worldIn, pos, BlockState.of(blockBroken, meta)));
        }
        super.func_149749_a(worldIn, x, y, z, blockBroken, meta);
    }

    public static enum Type {
        HORIZONTAL,
        VERTICAL,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT;

        private static final Type[] VALUES;

        public static Type byMeta(int meta) {
            if (meta >= VALUES.length) {
                throw new IllegalArgumentException(String.format("Provided meta (%s) which is more than type storage size (%s)", meta, VALUES.length));
            }
            return VALUES[meta];
        }

        static {
            VALUES = Type.values();
        }
    }
}

